package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_MARK_BRACKETS;

import java.awt.event.ItemEvent;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.ViewActionScope;
import jnpad.text.Viewer;

/**
 * The Class MarkBracketsAction.
 *
 * @version 0.3
 * @since   jNPad v0.3
 */
public final class MarkBracketsAction extends JNPadAction {
  /** UID */
  private static final long serialVersionUID = 2378316097520732616L;

  /**
   * Instantiates a new mark brackets action.
   *
   * @param jNPad the jNPad's frame
   */
  public MarkBracketsAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_MARK_BRACKETS,
          Group.VIEW,
          Accelerators.MARK_BRACKETS, "mark-brackets.png"); //$NON-NLS-1$
    
    setSelected(Config.BRACKET_HIGHLIGHTER_VISIBLE.getValue());
    setStateAction(true);
  }

  /**
   * Handle state changed.
   *
   * @param e the ItemEvent
   * @see jnpad.action.JNPadAction#handleStateChanged(java.awt.event.ItemEvent)
   */
  @Override
  public void handleStateChanged(final ItemEvent e) {
    final ViewActionScope scope = Config.VIEW_ACTION_SCOPE.getValue();

    Viewer viewer = jNPad.getViewer();
    
    switch(scope) {
      case VIEWER:
        viewer.setBracketHighlighterVisible(ItemEvent.SELECTED == e.getStateChange());
        break;
      case BUFFER_SET:
        viewer.getActiveBufferSet().setBracketHighlighterVisible(ItemEvent.SELECTED == e.getStateChange());
        break;
      case EDIT_PANE:
        viewer.getActiveEditPane().setBracketHighlighterVisible(ItemEvent.SELECTED == e.getStateChange());
        break;
      case BUFFER:
      default:  
        viewer.getActiveBuffer().setBracketHighlighterVisible(ItemEvent.SELECTED == e.getStateChange());
        break;
    }
  }

}
