/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_FONTS;
import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.Configurable;
import jnpad.ui.FontChooser;

/**
 * The Class FontsAction.
 *
 * @version 0.3
 * @since jNPad 0.1
 */
public final class FontsAction extends JNPadAction {
  /** UID */
  private static final long serialVersionUID = -5062141863038716047L;

  /**
   * Instantiates a new <code>FontsAction</code>.
   *
   * @param jNPad the jNPad's frame
   */
  public FontsAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_FONTS,
          Group.CONFIGURE,
          Accelerators.FONTS, null);
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    FontChooser fontChooser = new FontChooser(jNPad, ActionBundle.getString(ACTION_NAME_FONTS.concat(".title"))); //$NON-NLS-1$
    fontChooser.setSelectedFont(Config.TEXT_FONT.getValue());
    if (fontChooser.showDialog()) {
      Config.TEXT_FONT.setValue(fontChooser.getSelectedFont());
      jNPad.configure(Configurable.CFG_FONT);
    }
  }

}
