/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.tab;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;

import jnpad.config.Configurable;

/**
 * The Interface ITabbedPane.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public interface ITabbedPane extends Configurable {
  /**
   * To component.
   *
   * @return the component
   */
  JComponent toComponent();

  /**
   * Adds the change listener.
   *
   * @param listener the listener
   */
  void addChangeListener(ChangeListener listener);

  /**
   * Removes the change listener.
   *
   * @param listener the listener
   */
  void removeChangeListener(ChangeListener listener);

  /**
   * Gets the tab count.
   *
   * @return the tab count
   */
  int getTabCount();
  
  /**
   * Gets the selected index.
   *
   * @return the selected index
   */
  int getSelectedIndex();

  /**
   * Gets the selected component.
   *
   * @return the selected component
   */
  Component getSelectedComponent();

  /**
   * Sets the selected component.
   *
   * @param c the new selected component
   */
  void setSelectedComponent(Component c);

  /**
   * Sets the selected index.
   *
   * @param index the new selected index
   */
  void setSelectedIndex(int index);
  
  /**
   * Index of component.
   *
   * @param c the c
   * @return the int
   */
  int indexOfComponent(Component c);

  /**
   * Insert tab.
   *
   * @param title the title
   * @param icon the icon
   * @param c the c
   * @param tip the tip
   * @param index the index
   */
  void insertTab(String title, Icon icon, Component c, String tip, int index);
  
  /**
   * Removes the tab at.
   *
   * @param index the index
   */
  void removeTabAt(int index);

  /**
   * Gets the component at.
   *
   * @param i the i
   * @return the component at
   */
  Component getComponentAt(int i);

  /**
   * Sets the title at.
   *
   * @param index the index
   * @param title the title
   */
  void setTitleAt(int index, String title);

  /**
   * Sets the tool tip text at.
   *
   * @param index the index
   * @param toolTipText the tool tip text
   */
  void setToolTipTextAt(int index, String toolTipText);

  /**
   * Gets the tool tip text at.
   *
   * @param index the index
   * @return the tool tip text at
   */
  String getToolTipTextAt(int index);
  
  /**
   * Sets the component at.
   *
   * @param index the index
   * @param c the c
   */
  void setComponentAt(int index, Component c);

  /**
   * Sets the icon at.
   *
   * @param index the index
   * @param icon the icon
   */
  void setIconAt(int index, Icon icon);

  /**
   * Gets the icon at.
   *
   * @param index the index
   * @return the icon at
   */
  Icon getIconAt(int index);

  /**
   * Gets the title at.
   *
   * @param index the index
   * @return the title at
   */
  String getTitleAt(int index);

  /**
   * Focus on selected component.
   */
  void focusOnSelectedComponent();

  /**
   * Previous tab.
   */
  void previousTab();

  /**
   * Next tab.
   */
  void nextTab();

  /**
   * Sets the suppress state changed events.
   *
   * @param suppress the new suppress state changed events
   */
  void setSuppressStateChangedEvents(boolean suppress);

  /**
   * Checks if is suppress state changed events.
   *
   * @return true, if is suppress state changed events
   */
  boolean isSuppressStateChangedEvents();

  /**
   * Sets the auto focus on tab hide close.
   *
   * @param autoFocusOnTabHideClose the new auto focus on tab hide close
   */
  void setAutoFocusOnTabHideClose(boolean autoFocusOnTabHideClose);

  /**
   * Checks if is auto focus on tab hide close.
   *
   * @return true, if is auto focus on tab hide close
   */
  boolean isAutoFocusOnTabHideClose();

  /**
   * Checks if is auto request focus.
   *
   * @return true, if is auto request focus
   */
  boolean isAutoRequestFocus();

  /**
   * Sets the auto request focus.
   *
   * @param autoRequestFocus the new auto request focus
   */
  void setAutoRequestFocus(boolean autoRequestFocus);

  /**
   * Checks if is suppress set selected index.
   *
   * @return true, if is suppress set selected index
   */
  boolean isSuppressSetSelectedIndex();

  /**
   * Sets the suppress set selected index.
   *
   * @param suppressSetSelectedIndex the new suppress set selected index
   */
  void setSuppressSetSelectedIndex(boolean suppressSetSelectedIndex);

  /**
   * Scroll tab to visible.
   *
   * @param index the index
   */
  void scrollTabToVisible(int index);

  /**
   * Gets the tab layout policy.
   *
   * @return the tab layout policy
   */
  int getTabLayoutPolicy();

  /**
   * Sets the tab layout policy.
   *
   * @param policy the new tab layout policy
   */
  void setTabLayoutPolicy(int policy);
  
  /**
   * Move selected tab to.
   *
   * @param tabIndex the tab index
   */
  void moveSelectedTabTo(int tabIndex);

}
