/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.plaf;

import java.awt.Font;
import java.awt.Toolkit;

import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.OceanTheme;

import jnpad.util.Platform;

/**
 * The Class OceanTheme2.
 *
 * @version 0.3
 * @since jNPad 0.1
 */
@SuppressWarnings("all")
public class OceanTheme2 extends OceanTheme {
  private static final FontUIResource SUB_TEXT_FONT;
  private static final FontUIResource SYSTEM_FONT;
  private static final FontUIResource USER_TEXT_FONT;
  private static final FontUIResource WINDOW_TITLE_FONT;
  private static final FontUIResource CONTROL_TEXT_FONT;
  private static final FontUIResource MENU_TEXT_FONT;
  
  static {
    label0: {
      if (Platform.isWindows) {
        Font font = (Font) Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font"); //$NON-NLS-1$
        if (font != null) {
          SUB_TEXT_FONT     = new FontUIResource(font.getName(), Font.PLAIN, font.getSize());
          SYSTEM_FONT       = new FontUIResource(font.getName(), Font.PLAIN, font.getSize());
          USER_TEXT_FONT    = new FontUIResource(font.getName(), Font.PLAIN, font.getSize());
          WINDOW_TITLE_FONT = new FontUIResource(font.getName(), Font.BOLD , font.getSize());
          CONTROL_TEXT_FONT = new FontUIResource(font.getName(), Font.PLAIN, font.getSize());
          MENU_TEXT_FONT    = new FontUIResource(font.getName(), Font.PLAIN, font.getSize());
          break label0;
        }
      }
      SUB_TEXT_FONT     = new FontUIResource("Dialog"   , Font.PLAIN, 10); //$NON-NLS-1$
      SYSTEM_FONT       = new FontUIResource("Dialog"   , Font.PLAIN, 11); //$NON-NLS-1$
      USER_TEXT_FONT    = new FontUIResource("SansSerif", Font.PLAIN, 11); //$NON-NLS-1$
      WINDOW_TITLE_FONT = new FontUIResource("Dialog"   , Font.BOLD , 12); //$NON-NLS-1$
      CONTROL_TEXT_FONT = new FontUIResource("Dialog"   , Font.PLAIN, 11); //$NON-NLS-1$
      MENU_TEXT_FONT    = new FontUIResource("Dialog"   , Font.PLAIN, 11); //$NON-NLS-1$
    }
  }

  @Override public String getName() {return "Ocean2";} //$NON-NLS-1$

  @Override public FontUIResource getSubTextFont()     {return SUB_TEXT_FONT; }
  @Override public FontUIResource getControlTextFont() {return CONTROL_TEXT_FONT;}
  @Override public FontUIResource getMenuTextFont()    {return MENU_TEXT_FONT;}
  @Override public FontUIResource getSystemTextFont()  {return SYSTEM_FONT;}
  @Override public FontUIResource getUserTextFont()    {return USER_TEXT_FONT;}
  @Override public FontUIResource getWindowTitleFont() {return WINDOW_TITLE_FONT;}

}
