package jnpad.ui;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JScrollPane;

import jnpad.ui.plaf.LAFUtils;

/**
 * The Class MiniScrollPane.
 *
 * @version 0.3
 * @since   jNPad v0.3
 */
public class MiniScrollPane extends JScrollPane {
  /** UID */
  private static final long serialVersionUID = 5647660435129843262L;

  /**
   * Instantiates a new mini scroll pane.
   * 
   * @param view the component to display in the scrollpanes viewport
   * @param vsbPolicy an integer that specifies the vertical scrollbar policy
   * @param hsbPolicy an integer that specifies the horizontal scrollbar policy
   */
  public MiniScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
    super(view, vsbPolicy, hsbPolicy);
    
    int n;
    if (LAFUtils.isNimbusLAF())
      n = 10;
    else if (LAFUtils.isMotifLAF())
      n = 14;
    else
      n = 12;
    
    verticalScrollBar.setPreferredSize(new Dimension(n, Integer.MAX_VALUE));
    horizontalScrollBar.setPreferredSize(new Dimension(Integer.MAX_VALUE, n));
  }

  /**
   * Instantiates a new mini scroll pane.
   *
   * @param view the component to display in the scrollpanes viewport
   */
  public MiniScrollPane(Component view) {
    this(view, VERTICAL_SCROLLBAR_AS_NEEDED, HORIZONTAL_SCROLLBAR_AS_NEEDED);
  }

  /**
   * Instantiates a new mini scroll pane.
   *
   * @param vsbPolicy an integer that specifies the vertical scrollbar policy
   * @param hsbPolicy an integer that specifies the horizontal scrollbar policy
   */
  public MiniScrollPane(int vsbPolicy, int hsbPolicy) {
    this(null, vsbPolicy, hsbPolicy);
  }

  /**
   * Instantiates a new mini scroll pane.
   */
  public MiniScrollPane() {
    this(null, VERTICAL_SCROLLBAR_AS_NEEDED, HORIZONTAL_SCROLLBAR_AS_NEEDED);
  }
}
