/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

import javax.swing.border.Border;

import jnpad.ui.plaf.LAFUtils;

/**
 * 
 * @version 0.3
 * @since   jNPad v0.1
 */
public class EdgeBorder implements Border {
  private Insets          _insets = new Insets(2, 2, 2, 2);

  /** */
  public static final int EDGE_TOP    = 0x1;
  /** */
  public static final int EDGE_LEFT   = 0x2;
  /** */
  public static final int EDGE_BOTTOM = 0x4;
  /** */
  public static final int EDGE_RIGHT  = 0x8;
  /** */
  public static final int EDGE_ALL    = 0xF;

  private int             _edge   = EDGE_ALL;

  /**
   *
   */
  public EdgeBorder() {
    //empty
  }

  /**
   *
   * @param edge int
   */
  public EdgeBorder(int edge) {
    _edge = edge;
    recalcInsets();
  }

  /**
   *
   */
  protected void recalcInsets() {
    _insets.top    = ( ( (_edge & EDGE_TOP) != 0) ? 2 : 0);
    _insets.left   = ( ( (_edge & EDGE_LEFT) != 0) ? 2 : 0);
    _insets.bottom = ( ( (_edge & EDGE_BOTTOM) != 0) ? 2 : 0);
    _insets.right  = ( ( (_edge & EDGE_RIGHT) != 0) ? 2 : 0);
  }

  /**
   *
   * @return boolean
   */
  public boolean isBorderOpaque() {return true;}

  /**
   *
   * @param c Component
   * @return Insets
   */
  public Insets getBorderInsets(Component c) {return _insets;}

  /**
   *
   * @param c Component
   * @param g Graphics
   * @param x int
   * @param y int
   * @param width int
   * @param height int
   */
  public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    Color shadow    = LAFUtils.getSeparatorShadow();
    Color highlight = LAFUtils.getSeparatorHighlight();
    Color color     = g.getColor();

    if ( (_edge & EDGE_TOP) != 0) {
      g.setColor(shadow);
      g.drawLine(x, y, x + width - 1, y);
      g.setColor(highlight);
      g.drawLine(x, y + 1, x + width - 1, y + 1);
    }

    if ( (_edge & EDGE_LEFT) != 0) {
      g.setColor(shadow);
      g.drawLine(x, y, x, y + height - 1);
      g.setColor(highlight);
      g.drawLine(x + 1, y, x + 1, y + height - 1);
    }

    if ( (_edge & EDGE_BOTTOM) != 0) {
      g.setColor(shadow);
      g.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
      g.setColor(highlight);
      g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
    }

    if ( (_edge & EDGE_RIGHT) != 0) {
      g.setColor(shadow);
      g.drawLine(x + width - 2, y, x + width - 2, y + height - 1);
      g.setColor(highlight);
      g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
    }

    g.setColor(color);
  }

}
