/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.filebrowser;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Utilities;

/**
 * The Class FileListCellRenderer.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class FileListCellRenderer extends JLabel implements ListCellRenderer {
  /** The Constant DEFAULT_NO_FOCUS_BORDER. */
  private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

  /** UID */
  private static final long   serialVersionUID        = -7716429178046246911L;

  /**
   * Instantiates a new file list cell renderer.
   */
  public FileListCellRenderer() {
    setOpaque(true);
    setBorder(DEFAULT_NO_FOCUS_BORDER);
  }

  /**
   * Gets the list cell renderer component.
   *
   * @param list the list
   * @param value the value
   * @param index the index
   * @param isSelected is selected
   * @param cellHasFocus the cell has focus
   * @return the list cell renderer component
   * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
   */
  @Override
  public Component getListCellRendererComponent(JList list,
                                                Object value,
                                                int index,
                                                boolean isSelected,
                                                boolean cellHasFocus) {

    setComponentOrientation(list.getComponentOrientation());

    if (value instanceof FileBrowserObject) {
      setText(((FileBrowserObject)value).getLine());
      setFont(((FileBrowserObject)value).getFont());
      if (isSelected) {
        setBackground(list.getSelectionBackground());
        setForeground(list.getSelectionForeground());
      }
      else {
        setBackground(list.getBackground());
        setForeground(((FileBrowserObject)value).getForeground());
      }
    }
    else {
      setText(Utilities.toString(value));
      setFont(FileBrowserObject.font_bold); //setFont(list.getFont());
      if (isSelected) {
        setBackground(list.getSelectionBackground());
        setForeground(list.getSelectionForeground());
      }
      else {
        setBackground(list.getBackground());
        setForeground(FileBrowserObject.fg_dir); //setForeground(list.getForeground());
      }
    }

    setEnabled(list.isEnabled());
    setBorder( (cellHasFocus && !LAFUtils.isFullRowSelectionLAF())
               ? LAFUtils.getListFocusCellHighlightBorder()
               : DEFAULT_NO_FOCUS_BORDER);

    return this;
  }

}
