/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

/**
 * The Interface JNPadActions.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
@SuppressWarnings("all")
public interface JNPadActions {
  /**
   * The Enum Group.
   */
  enum Group {
    FILE, EDIT, SEARCH, VIEW, FORMAT, CONFIGURE, WINDOW, HELP, OTHERS
  }
  
  // File
  String ACTION_NAME_NEW_FILE                       = "new-file";
  String ACTION_NAME_OPEN_FILE                      = "open-file";
  String ACTION_NAME_OPEN_ALL_RECENT_FILES          = "open-all-recent-files";
  String ACTION_NAME_EMPTY_RECENT_FILES_LIST        = "empty-recent-files-list";
  String ACTION_NAME_CLOSE_FILE                     = "close-file";
  String ACTION_NAME_CLOSE_FILES                    = "close-files";
  String ACTION_NAME_CLOSE_ALL                      = "close-all";
  String ACTION_NAME_CLOSE_OTHER                    = "close-other";
  String ACTION_NAME_CLOSE_ALL_TO_LEFT              = "close-all-to-left";
  String ACTION_NAME_CLOSE_ALL_TO_RIGHT             = "close-all-to-right";
  String ACTION_NAME_SAVE_FILE                      = "save-file";
  String ACTION_NAME_SAVE_ALL                       = "save-all";
  String ACTION_NAME_SAVE_AS                        = "save-as";
  String ACTION_NAME_FILE_PROPERTIES                = "file-properties";
  String ACTION_NAME_FILE_BROWSER                   = "file-browser";
  String ACTION_NAME_PRINT_SET                      = "print-set";
  String ACTION_NAME_PRINT                          = "print";
  String ACTION_NAME_RELOAD                         = "reload";
  String ACTION_NAME_EXECUTE_ACTION                 = "execute-action";
  String ACTION_NAME_LOAD_SESSION                   = "load-session";
  String ACTION_NAME_SAVE_SESSION                   = "save-session";
  String ACTION_NAME_REDUCE_AS_TRAY_ICON            = "reduce-as-tray-icon";
  String ACTION_NAME_RESTART                        = "restart";
  String ACTION_NAME_EXIT                           = "exit";

  // Edit
  String ACTION_NAME_UNDO                           = "undo";
  String ACTION_NAME_REDO                           = "redo";
  String ACTION_NAME_COPY                           = "copy";
  String ACTION_NAME_COPY_LINE                      = "copy-line";
  String ACTION_NAME_CUT                            = "cut";
  String ACTION_NAME_CUT_LINE                       = "cut-line";
  String ACTION_NAME_PASTE                          = "paste";
  String ACTION_NAME_SELECT_ALL                     = "select-all";
  String ACTION_NAME_SELECT_PARAGRAPH               = "select-paragraph";
  String ACTION_NAME_SELECTION_END_PARAGRAPH        = "selection-end-paragraph";
  String ACTION_NAME_SELECTION_BEGIN_PARAGRAPH      = "selection-begin-paragraph";
  String ACTION_NAME_SELECT_LINE                    = "select-line";
  String ACTION_NAME_SELECTION_END_LINE             = "selection-end-line";
  String ACTION_NAME_SELECTION_BEGIN_LINE           = "selection-begin-line";
  String ACTION_NAME_SELECT_WORD                    = "select-word";
  String ACTION_NAME_DELETE                         = "delete";
  String ACTION_NAME_DELETE_WORD                    = "delete-word";
  String ACTION_NAME_DELETE_LINE                    = "delete-line";
  String ACTION_NAME_DELETION_BEGIN_LINE            = "deletion-begin-line";
  String ACTION_NAME_DELETION_END_LINE              = "deletion-end-line";
  String ACTION_NAME_DELETE_PARAGRAPH               = "delete-paragraph";
  String ACTION_NAME_DELETION_BEGIN_PARAGRAPH       = "deletion-begin-paragraph";
  String ACTION_NAME_DELETION_END_PARAGRAPH         = "deletion-end-paragraph";
  String ACTION_NAME_TABS_TO_SPACES                 = "tabs-to-spaces";
  String ACTION_NAME_SPACES_TO_TABS                 = "spaces-to-tabs";
  String ACTION_NAME_BEGIN_LINES                    = "begin-lines-with";
  String ACTION_NAME_END_LINES                      = "end-lines-with";
  String ACTION_NAME_DUPLICATE_CURRENT_LINE         = "duplicate-current-line";
  String ACTION_NAME_JOIN_LINES                     = "join-lines";
  String ACTION_NAME_SORT_LINES_IN_ASCENDING_ORDER  = "sort-lines-in-ascending-order";
  String ACTION_NAME_SORT_LINES_IN_DESCENDING_ORDER = "sort-lines-in-descending-order";
  String ACTION_NAME_REMOVE_END_LINES               = "remove-end-lines";
  String ACTION_NAME_REMOVE_EMPTY_LINES             = "remove-empty-lines";
  String ACTION_NAME_COMPLETE_WORD                  = "complete-word";
  String ACTION_NAME_COMPLETE_WORD_ALL              = "complete-word-all";
  String ACTION_NAME_WORD_COUNT                     = "word-count";
  String ACTION_NAME_INSERT_FILE_EXTENSION          = "insert-file-extension";
  String ACTION_NAME_INSERT_FILE_FULL_NAME          = "insert-file-full-name";
  String ACTION_NAME_INSERT_FILE_NAME               = "insert-file-name";
  String ACTION_NAME_INSERT_FILE_FULL_PATH          = "insert-file-full-path";
  String ACTION_NAME_INSERT_FILE_PATH               = "insert-file-path";
  String ACTION_NAME_INSERT_DATE                    = "insert-date";

  // Search
  String ACTION_NAME_FIND                           = "find";
  String ACTION_NAME_FIND_NEXT                      = "find-next";
  String ACTION_NAME_FIND_PREVIOUS                  = "find-previous";
  String ACTION_NAME_REPLACE                        = "replace";
  String ACTION_NAME_REPLACE_NEXT                   = "replace-next";
  String ACTION_NAME_INCREMENTAL_SEARCH             = "incremental-search";
  String ACTION_NAME_HIGHLIGHT_ALL_OCCURRENCES      = "highlight-all-occurrences";
  String ACTION_NAME_CLEAR_ALL_OCCURRENCES          = "clear-all-occurrences";
  String ACTION_NAME_NEXT_OCCURRENCE                = "next-occurrence";
  String ACTION_NAME_PREVIOUS_OCCURRENCE            = "previous-occurrence";
  String ACTION_NAME_GO_TO_LINE                     = "go-to-line";
  String ACTION_NAME_NEXT_BOOKMARK                  = "next-bookmark";
  String ACTION_NAME_PREVIOUS_BOOKMARK              = "previous-bookmark";
  String ACTION_NAME_TOGGLE_BOOKMARK                = "toggle-bookmark";
  String ACTION_NAME_CLEAR_ALL_BOOKMARKS            = "clear-all-bookmarks";

  // View
  String ACTION_NAME_TOOLBARS_FILE                  = "toolbars-file";
  String ACTION_NAME_TOOLBARS_EDIT_RECANTATION      = "toolbars-edit-recantation";
  String ACTION_NAME_TOOLBARS_EDIT_CLIPBOARD        = "toolbars-edit-clipboard";
  String ACTION_NAME_TOOLBARS_EDIT_SELECTION        = "toolbars-edit-selection";
  String ACTION_NAME_TOOLBARS_EDIT_DELETION         = "toolbars-edit-delete";
  String ACTION_NAME_TOOLBARS_VIEW                  = "toolbars-view";
  String ACTION_NAME_TOOLBARS_SEARCH                = "toolbars-search";
  String ACTION_NAME_TOOLBARS_FORMAT                = "toolbars-format";
  String ACTION_NAME_TOOLBARS_WINDOWS               = "toolbars-windows";
  String ACTION_NAME_TOOLBARS_ALL_VISIBLE           = "toolbars-all-visible";
  String ACTION_NAME_TOOLBARS_NONE_VISIBLE          = "toolbars-none-visible";
  String ACTION_NAME_TOOLBAR_VISIBLE                = "toolbar-visible";
  String ACTION_NAME_FIND_RESULTS_VISIBLE           = "find-results-visible";
  String ACTION_NAME_STATUSBAR_VISIBLE              = "statusbar-visible";
  String ACTION_NAME_LINE_WRAP                      = "line-wrap";
  String ACTION_NAME_LINE_NUMBERS                   = "line-numbers";
  String ACTION_NAME_ACTIVE_LINE                    = "active-line";
  String ACTION_NAME_RIGHT_MARGIN_LINE              = "right-margin-line";
  String ACTION_NAME_MARK_STRIP                     = "mark-strip";
  String ACTION_NAME_MARK_OCCURRENCES               = "mark-occurrences";
  String ACTION_NAME_MARK_BRACKETS                  = "mark-brackets"; // [added v0.3]
  String ACTION_NAME_FOCUS_ON_MAIN_VIEW             = "focus-on-main-view";
  String ACTION_NAME_SELECT_SCOPE_AS_VIEWER         = "select-view-action-scope-viewer";
  String ACTION_NAME_SELECT_SCOPE_AS_BUFFER_SET     = "select-view-action-scope-buffer-set";
  String ACTION_NAME_SELECT_SCOPE_AS_BUFFER         = "select-view-action-scope-buffer";
  String ACTION_NAME_SELECT_SCOPE_AS_EDIT_PANE      = "select-view-action-scope-edit-pane";
  String ACTION_NAME_FULLSCREEN                     = "fullscreen";

  // Format
  String ACTION_NAME_SELECT_EOL_AS_DOS              = "select-eol-as-dos";
  String ACTION_NAME_SELECT_EOL_AS_UNIX             = "select-eol-as-unix";
  String ACTION_NAME_SELECT_EOL_AS_MAC              = "select-eol-as-mac";
  String ACTION_NAME_RIGHT_INDENT                   = "right-indent";
  String ACTION_NAME_LEFT_INDENT                    = "left-indent";
  String ACTION_NAME_TO_UPPER_CASE                  = "to-upper-case";
  String ACTION_NAME_TO_LOWER_CASE                  = "to-lower-case";
  String ACTION_NAME_INVERT_UPPER_LOWER             = "invert-upper-lower";
  String ACTION_NAME_CAPITALIZE                     = "capitalize";
  String ACTION_NAME_TO_TITLE                       = "to-title";
  String ACTION_NAME_SET_READ_ONLY                  = "set-read-only";
  String ACTION_NAME_ALIGN_STRINGS_BY_COMMA         = "align-strings-by-comma";
  String ACTION_NAME_ALIGN_STRINGS_BY_EQUAL         = "align-strings-by-equal";
  String ACTION_NAME_ALIGN_STRINGS_BY_CLIPBOARD     = "align-strings-by-clipboard";
  String ACTION_NAME_INCREASE_FONT                  = "increase-font";
  String ACTION_NAME_DECREASE_FONT                  = "decrease-font";

  // Configure
  String ACTION_NAME_AUTOINDENT_ENABLED             = "autoindent-enabled";
  String ACTION_NAME_INDENT_USING_SPACES            = "indent-using-spaces";
  String ACTION_NAME_AUTOCOMPLETION_ENABLED         = "autocompletion-enabled";
  String ACTION_NAME_LOAD_OPTIONS_FILE              = "load-options-file";
  String ACTION_NAME_LOAD_DEFAULT_OPTIONS_FILE      = "load-default-options-file";
  String ACTION_NAME_LOAD_SHORTCUTS_FILE            = "load-shortcuts-file";
  String ACTION_NAME_LOAD_LOGGING_CONFIG_FILE       = "load-logging-config-file";
  String ACTION_NAME_FONTS                          = "fonts";
  String ACTION_NAME_RESET_FONT                     = "reset-fonts";
  String ACTION_NAME_FOREGROUND                     = "foreground";
  String ACTION_NAME_BRIGHTEN_FOREGROUND            = "brighten-foreground";
  String ACTION_NAME_DARKEN_FOREGROUND              = "darken-foreground";
  String ACTION_NAME_RESET_FOREGROUND               = "reset-foreground";
  String ACTION_NAME_BACKGROUND                     = "background";
  String ACTION_NAME_BRIGHTEN_BACKGROUND            = "brighten-background";
  String ACTION_NAME_DARKEN_BACKGROUND              = "darken-background";
  String ACTION_NAME_RESET_BACKGROND                = "reset-background";
  
  // Window
  String ACTION_NAME_WINDOWS                        = "windows";
  String ACTION_NAME_NEXT_BUFFER                    = "next-buffer";
  String ACTION_NAME_PREVIOUS_BUFFER                = "previous-buffer";
  String ACTION_NAME_UNSPLIT_CURRENT                = "unsplit-current";
  String ACTION_NAME_UNSPLIT                        = "unsplit";
  String ACTION_NAME_SPLIT_HORIZONTALLY             = "split-horizontally";
  String ACTION_NAME_SPLIT_VERTICALLY               = "split-vertically";
  String ACTION_NAME_RESTORE_SPLIT                  = "restore-split";
  String ACTION_NAME_NEXT_EDIT_PANE                 = "next-edit-pane";
  String ACTION_NAME_PREVIOUS_EDIT_PANE             = "previous-edit-pane";
  String ACTION_NAME_UNSPLIT_VIEWER_CURRENT         = "unsplit-viewer-current";
  String ACTION_NAME_UNSPLIT_VIEWER                 = "unsplit-viewer";
  String ACTION_NAME_SPLIT_VIEWER_HORIZONTALLY      = "split-viewer-horizontally";
  String ACTION_NAME_SPLIT_VIEWER_VERTICALLY        = "split-viewer-vertically";
  String ACTION_NAME_RESTORE_VIEWER_SPLIT           = "restore-viewer-split";
  String ACTION_NAME_NEXT_BUFFER_SET                = "next-buffer-set";
  String ACTION_NAME_PREVIOUS_BUFFER_SET            = "previous-buffer-set";

  // Help
  String ACTION_NAME_CLI_ARGS                       = "cli-args";
  String ACTION_NAME_LICENSE                        = "license";
  String ACTION_NAME_CHECK_FOR_UPDATES              = "check-for-updates";
  String ACTION_NAME_ABOUT                          = "about";
}
