/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import jnpad.JNPadFrame;
import jnpad.config.Accelerators;

/**
 * The Class AlignStringsByEqualAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class AlignStringsByEqualAction extends AlignStringsAction {
  /** UID */
  private static final long serialVersionUID = -5277755633274815367L;

  /**
   * Instantiates a new <code>AlignStringsByEqualAction</code>.
   *
   * @param jNPad the jNPad's frame
   */
  public AlignStringsByEqualAction(JNPadFrame jNPad) {
    super(jNPad, JNPadActions.ACTION_NAME_ALIGN_STRINGS_BY_EQUAL, Accelerators.ALIGN_STRINGS_BY_EQUAL);
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    alignStrings("="); //$NON-NLS-1$
  }

}
