/*
 * Decompiled with CFR 0.152.
 */
package jnpad.util;

import jnpad.util.Utilities;

public final class Platform {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase();
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model");
    public static final String SUN_DESKTOP = System.getProperty("sun.desktop");
    public static final boolean isWindows = OS_NAME.startsWith("windows");
    public static final boolean isWin2kOrNewer = isWindows && Platform.isOsVersionAtLeast("5.0");
    public static final boolean isWinVistaOrNewer = isWindows && Platform.isOsVersionAtLeast("6.0");
    public static final boolean isWin7OrNewer = isWindows && Platform.isOsVersionAtLeast("6.1");
    public static final boolean isWindowsNT = OS_NAME.startsWith("windows nt");
    public static final boolean isWindows2000 = OS_NAME.startsWith("windows 2000");
    public static final boolean isWindows2003 = OS_NAME.startsWith("windows 2003");
    public static final boolean isWindowsXP = OS_NAME.startsWith("windows xp");
    public static final boolean isWindowsVista = OS_NAME.startsWith("windows vista");
    public static final boolean isWindows7 = OS_NAME.startsWith("windows 7");
    public static final boolean isWindows9x = OS_NAME.startsWith("windows 9") || OS_NAME.startsWith("windows me");
    public static final boolean isOS2 = OS_NAME.startsWith("os/2") || OS_NAME.startsWith("os2");
    public static final boolean isMac = OS_NAME.startsWith("mac");
    public static final boolean isFreeBSD = OS_NAME.startsWith("freebsd");
    public static final boolean isLinux = OS_NAME.startsWith("linux");
    public static final boolean isSolaris = OS_NAME.startsWith("sunos");
    public static final boolean isUnix = !isWindows && !isOS2;
    public static final boolean isKDE = SUN_DESKTOP != null && SUN_DESKTOP.toLowerCase().contains("kde");
    public static final boolean isGnome = SUN_DESKTOP != null && SUN_DESKTOP.toLowerCase().contains("gnome");
    public static final boolean isXWindow = isUnix && !isMac;
    public static final boolean areSymLinksSupported = isUnix || isWinVistaOrNewer;
    public static final boolean is32Bit = ARCH_DATA_MODEL == null || ARCH_DATA_MODEL.equals("32");
    public static final boolean is64Bit = !is32Bit;
    public static final boolean isAMD64 = "amd64".equals(OS_ARCH);
    public static final boolean isMacIntel64 = isMac && "x86_64".equals(OS_ARCH);

    private Platform() {
    }

    public static boolean isOsVersionAtLeast(String version) {
        return Utilities.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    public static String getJREVersion() {
        return System.getProperty("java.version");
    }

    public static boolean isJRE4() {
        return Platform.getJREVersion().startsWith("1.4");
    }

    public static boolean isJRE5() {
        return Platform.getJREVersion().startsWith("1.5");
    }

    public static boolean isJRE6() {
        return Platform.getJREVersion().startsWith("1.6");
    }

    public static boolean isJRE7() {
        return Platform.getJREVersion().startsWith("1.7");
    }

    public static boolean isJRE8() {
        return Platform.getJREVersion().startsWith("1.8");
    }

    public static boolean isJRE4Above() {
        return Platform.getJREVersion().compareTo("1.4") >= 0;
    }

    public static boolean isJRE5Above() {
        return Platform.getJREVersion().compareTo("1.5") >= 0;
    }

    public static boolean isJRE6Above() {
        return Platform.getJREVersion().compareTo("1.6") >= 0;
    }

    public static boolean isJRE7Above() {
        return Platform.getJREVersion().compareTo("1.7") >= 0;
    }

    public static boolean isJRE8Above() {
        return Platform.getJREVersion().compareTo("1.8") >= 0;
    }

    public static boolean isJRESupported() {
        return Platform.isJRE6Above();
    }
}

