/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.toolbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import jnpad.ui.plaf.LAFUtils;

public abstract class DecoratedIcon
extends ImageIcon {
    public static final int ROLLOVER = 0;
    public static final int STANDARD = 1;
    protected int[][] buffer;
    protected int popupIconWidth = 11;
    protected int popupIconHeight = 16;
    private int popupIconOffset = 5;
    private ImageIcon imageIcon;
    private static final long serialVersionUID = 7144078227340209320L;

    protected DecoratedIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
    }

    protected void init(int[][] buffer) {
        this.buffer = buffer;
        this.popupIconWidth = buffer[0].length;
        this.popupIconHeight = buffer.length;
        int newWidth = this.imageIcon.getIconWidth() + this.popupIconOffset + this.popupIconWidth;
        int newHeight = this.imageIcon.getIconHeight();
        BufferedImage mergedImage = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g2D = mergedImage.createGraphics();
        g2D.drawImage(this.imageIcon.getImage(), null, null);
        this.setImage(mergedImage);
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        super.paintIcon(c, g, x, y);
        int xOffset = x + this.imageIcon.getIconWidth() + this.popupIconOffset;
        Color[] colors = new Color[]{c.getBackground(), LAFUtils.getControlDkShadow(), LAFUtils.getControlText(), LAFUtils.getControlHighlight()};
        int i = 0;
        while (i < this.popupIconWidth) {
            int j = 0;
            while (j < this.popupIconHeight) {
                if (this.buffer[j][i] != 0) {
                    g.setColor(colors[this.buffer[j][i]]);
                    g.drawLine(xOffset + i, y + j, xOffset + i, y + j);
                }
                ++j;
            }
            ++i;
        }
    }
}

