/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.tab;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import jnpad.GUIUtilities;
import jnpad.config.Configurable;
import jnpad.ui.tab.ITabbedPane;
import jnpad.util.Platform;

public abstract class AbstractTabbedPane
extends JTabbedPane
implements ITabbedPane {
    private boolean _suppressStateChangedEvents = false;
    private boolean _autoFocusOnTabHideClose = true;
    private boolean _suppressSetSelectedIndex = false;
    private boolean _autoRequestFocus = true;
    private ScrollableTabSupport _scrollableTabSupport;
    private static final Logger LOGGER = Logger.getLogger(AbstractTabbedPane.class.getName());
    private static final long serialVersionUID = -5254761801301385146L;

    public AbstractTabbedPane() {
        this(1, 0);
    }

    public AbstractTabbedPane(int tabPlacement) {
        this(tabPlacement, 0);
    }

    public AbstractTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    @Override
    public JComponent toComponent() {
        return this;
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        try {
            super.processMouseEvent(e);
            if (e.getID() == 501) {
                this.handleMousePressed(e);
            } else if (e.getID() == 500) {
                this.handleMouseClicked(e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handleMousePressed(MouseEvent e) {
        int i = this.getSelectedIndex();
        if (i > -1 && this.getTabCount() > i) {
            Rectangle bounds = this.getUI().getTabBounds(this, i);
            if (bounds.contains(e.getPoint())) {
                this.focusOnSelectedComponent();
            }
        } else if (this.isAutoRequestFocus()) {
            this.requestFocusInWindow();
        }
    }

    protected void handleMouseClicked(MouseEvent e) {
        Rectangle bounds;
        int i = this.getSelectedIndex();
        if (i > -1 && this.getTabCount() > i && (bounds = this.getUI().getTabBounds(this, i)).contains(e.getPoint())) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                this.expand();
            } else if (SwingUtilities.isRightMouseButton(e)) {
                this.showPopupMenu(e);
            }
        }
    }

    protected void close(int i) {
        this.remove(i);
    }

    protected abstract void expand();

    protected abstract void showPopupMenu(MouseEvent var1);

    @Override
    public void focusOnSelectedComponent() {
        Component selectedComponent = this.getSelectedComponent();
        if (selectedComponent != null) {
            GUIUtilities.requestFocus(selectedComponent);
        }
    }

    @Override
    public void previousTab() {
        if (this.getTabCount() > 1) {
            int i = this.getSelectedIndex();
            i = i == 0 ? this.getTabCount() - 1 : --i;
            this.setSelectedIndex(i);
        }
    }

    @Override
    public void nextTab() {
        if (this.getTabCount() > 1) {
            int i = this.getSelectedIndex();
            i = i == this.getTabCount() - 1 ? 0 : ++i;
            this.setSelectedIndex(i);
        }
    }

    @Override
    public void configure(int cfg) {
        int i = 0;
        while (i < this.getTabCount()) {
            Component c = this.getComponentAt(i);
            if (c instanceof Configurable) {
                ((Configurable)((Object)c)).configure(cfg);
            }
            ++i;
        }
    }

    @Override
    public void setComponentAt(int index, Component component) {
        super.setComponentAt(index, component);
        if (!this.isAutoFocusOnTabHideClose()) {
            this.clearVisComp();
        }
    }

    @Override
    public void removeTabAt(int index) {
        int tabCount = this.getTabCount();
        int selected = this.getSelectedIndex();
        boolean enforce = false;
        if (selected == index && selected < tabCount - 1) {
            boolean bl = enforce = !Platform.isJRE5Above();
        }
        if (!this.isAutoFocusOnTabHideClose()) {
            this.clearVisComp();
        }
        super.removeTabAt(index);
        if (enforce) {
            try {
                this.fireStateChanged();
            }
            catch (Throwable th) {
                LOGGER.log(Level.WARNING, th.getMessage(), th);
            }
        }
    }

    @Override
    public void setSuppressStateChangedEvents(boolean suppress) {
        this._suppressStateChangedEvents = suppress;
    }

    @Override
    public boolean isSuppressStateChangedEvents() {
        return this._suppressStateChangedEvents;
    }

    @Override
    public void setAutoFocusOnTabHideClose(boolean autoFocusOnTabHideClose) {
        this._autoFocusOnTabHideClose = autoFocusOnTabHideClose;
    }

    @Override
    public boolean isAutoFocusOnTabHideClose() {
        return this._autoFocusOnTabHideClose;
    }

    @Override
    protected void fireStateChanged() {
        if (this.isSuppressStateChangedEvents()) {
            return;
        }
        if (!this.isAutoFocusOnTabHideClose()) {
            this.clearVisComp();
        }
        super.fireStateChanged();
    }

    @Override
    public boolean isAutoRequestFocus() {
        return this._autoRequestFocus;
    }

    @Override
    public void setAutoRequestFocus(boolean autoRequestFocus) {
        this._autoRequestFocus = autoRequestFocus;
    }

    @Override
    public boolean isSuppressSetSelectedIndex() {
        return this._suppressSetSelectedIndex;
    }

    @Override
    public void setSuppressSetSelectedIndex(boolean suppressSetSelectedIndex) {
        this._suppressSetSelectedIndex = suppressSetSelectedIndex;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index >= this.getTabCount() || this.isSuppressSetSelectedIndex()) {
            return;
        }
        boolean old = this.isFocusCycleRoot();
        this.setFocusCycleRoot(true);
        try {
            int oldIndex = this.getSelectedIndex();
            if (oldIndex != index) {
                super.setSelectedIndex(index);
            }
        }
        finally {
            this.setFocusCycleRoot(old);
        }
        this.scrollTabToVisible(index);
        this.doLayout();
    }

    @Override
    public void setUI(TabbedPaneUI ui) {
        super.setUI(ui);
        this._scrollableTabSupport = ui instanceof BasicTabbedPaneUI ? new ScrollableTabSupport((BasicTabbedPaneUI)ui) : null;
    }

    @Override
    public final void scrollTabToVisible(int index) {
        block10: {
            Rectangle tabBounds;
            TabbedPaneUI tabbedPaneUI;
            block8: {
                block9: {
                    if (this._scrollableTabSupport == null || this.getTabLayoutPolicy() == 0) {
                        return;
                    }
                    tabbedPaneUI = this.getUI();
                    tabBounds = tabbedPaneUI.getTabBounds(this, index);
                    int tabPlacement = this.getTabPlacement();
                    if (1 != tabPlacement && 3 != tabPlacement) break block8;
                    if (tabBounds.x >= 50) break block9;
                    int leadingTabIndex = this._scrollableTabSupport.getLeadingTabIndex();
                    while (leadingTabIndex != index && leadingTabIndex > 0 && tabBounds.x < 50) {
                        this._scrollableTabSupport.setLeadingTabIndex(leadingTabIndex - 1);
                        leadingTabIndex = this._scrollableTabSupport.getLeadingTabIndex();
                        tabBounds = tabbedPaneUI.getTabBounds(this, index);
                    }
                    break block10;
                }
                if (tabBounds.x + tabBounds.width <= this.getWidth() - 50) break block10;
                int leadingTabIndex = this._scrollableTabSupport.getLeadingTabIndex();
                while (leadingTabIndex != index && leadingTabIndex < this.getTabCount() - 1 && tabBounds.x + tabBounds.width > this.getWidth() - 50) {
                    this._scrollableTabSupport.setLeadingTabIndex(leadingTabIndex + 1);
                    leadingTabIndex = this._scrollableTabSupport.getLeadingTabIndex();
                    tabBounds = tabbedPaneUI.getTabBounds(this, index);
                }
                break block10;
            }
            if (tabBounds.y < 30) {
                int leadingTabIndex = this._scrollableTabSupport.getLeadingTabIndex();
                while (leadingTabIndex != index && leadingTabIndex > 0 && tabBounds.y < 30) {
                    this._scrollableTabSupport.setLeadingTabIndex(leadingTabIndex - 1);
                    leadingTabIndex = this._scrollableTabSupport.getLeadingTabIndex();
                    tabBounds = tabbedPaneUI.getTabBounds(this, index);
                }
            } else if (tabBounds.y + tabBounds.height > this.getHeight() - 30) {
                int leadingTabIndex = this._scrollableTabSupport.getLeadingTabIndex();
                while (leadingTabIndex != index && leadingTabIndex < this.getTabCount() - 1 && tabBounds.y + tabBounds.height > this.getHeight() - 30) {
                    this._scrollableTabSupport.setLeadingTabIndex(leadingTabIndex + 1);
                    leadingTabIndex = this._scrollableTabSupport.getLeadingTabIndex();
                    tabBounds = tabbedPaneUI.getTabBounds(this, index);
                }
            }
        }
    }

    @Override
    public void moveSelectedTabTo(int tabIndex) {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex == tabIndex || tabIndex < 0 || tabIndex >= this.getTabCount() || selectedIndex == -1) {
            return;
        }
        Component selectedComponent = this.getComponentAt(selectedIndex);
        boolean old = this.isAutoRequestFocus();
        boolean shouldChangeFocus = false;
        if (selectedComponent != null && GUIUtilities.isAncestorOfFocusOwner(selectedComponent) && this.isAutoFocusOnTabHideClose()) {
            shouldChangeFocus = true;
        }
        try {
            this.setSuppressStateChangedEvents(true);
            this.setAutoRequestFocus(false);
            if (selectedIndex - tabIndex == 1 || tabIndex - selectedIndex == 1) {
                Component frame = this.getComponentAt(tabIndex);
                String title = this.getTitleAt(tabIndex);
                String tooltip = this.getToolTipTextAt(tabIndex);
                Icon icon = this.getIconAt(tabIndex);
                this.setSuppressStateChangedEvents(true);
                try {
                    if (tabIndex > selectedIndex) {
                        this.insertTab(title, icon, frame, tooltip, selectedIndex);
                    }
                    this.insertTab(title, icon, frame, tooltip, selectedIndex + 1);
                }
                finally {
                    this.setSuppressStateChangedEvents(false);
                }
            } else {
                Component frame = this.getComponentAt(selectedIndex);
                String title = this.getTitleAt(selectedIndex);
                String tooltip = this.getToolTipTextAt(selectedIndex);
                Icon icon = this.getIconAt(selectedIndex);
                this.setSuppressStateChangedEvents(true);
                try {
                    if (tabIndex > selectedIndex) {
                        this.insertTab(title, icon, frame, tooltip, tabIndex + 1);
                    } else {
                        this.insertTab(title, icon, frame, tooltip, tabIndex);
                    }
                }
                finally {
                    this.setSuppressStateChangedEvents(false);
                }
            }
            if (!Platform.isJRE5Above() && tabIndex == this.getTabCount() - 2) {
                this.setSelectedIndex(this.getTabCount() - 1);
            }
            this.setAutoRequestFocus(old);
            this.setSelectedIndex(tabIndex);
        }
        finally {
            this.setSuppressStateChangedEvents(false);
            if (shouldChangeFocus) {
                this.requestFocusInWindow();
            }
        }
    }

    protected void clearVisComp() {
        try {
            Field field = JTabbedPane.class.getDeclaredField("visComp");
            field.setAccessible(true);
            field.set(this, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final class ScrollableTabSupport {
        private final BasicTabbedPaneUI myUI;
        public static final String TAB_SCROLLER_NAME = "tabScroller";
        public static final String LEADING_TAB_INDEX_NAME = "leadingTabIndex";
        public static final String SET_LEADING_TAB_INDEX_METHOD = "setLeadingTabIndex";

        public ScrollableTabSupport(BasicTabbedPaneUI ui) {
            this.myUI = ui;
        }

        public int getLeadingTabIndex() {
            try {
                Field tabScrollerField = BasicTabbedPaneUI.class.getDeclaredField(TAB_SCROLLER_NAME);
                tabScrollerField.setAccessible(true);
                Object tabScrollerValue = tabScrollerField.get(this.myUI);
                Field leadingTabIndexField = tabScrollerValue.getClass().getDeclaredField(LEADING_TAB_INDEX_NAME);
                leadingTabIndexField.setAccessible(true);
                return leadingTabIndexField.getInt(tabScrollerValue);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                return -1;
            }
        }

        public void setLeadingTabIndex(int leadingIndex) {
            try {
                Method[] methods;
                Field tabScrollerField = BasicTabbedPaneUI.class.getDeclaredField(TAB_SCROLLER_NAME);
                tabScrollerField.setAccessible(true);
                Object tabScrollerValue = tabScrollerField.get(this.myUI);
                Method setLeadingIndexMethod = null;
                Method[] methodArray = methods = tabScrollerValue.getClass().getDeclaredMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (SET_LEADING_TAB_INDEX_METHOD.equals(method.getName())) {
                        setLeadingIndexMethod = method;
                        break;
                    }
                    ++n2;
                }
                if (setLeadingIndexMethod == null) {
                    LOGGER.warning("method setLeadingTabIndex not found");
                    return;
                }
                setLeadingIndexMethod.setAccessible(true);
                setLeadingIndexMethod.invoke(tabScrollerValue, AbstractTabbedPane.this.getTabPlacement(), leadingIndex);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }
}

