/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.ui.ColorUtilities;
import jnpad.ui.GradientLabel;
import jnpad.ui.GradientPaintable;
import jnpad.util.Utilities;

public class TitledLabel
extends JPanel
implements GradientPaintable {
    private GradientLabel lbIconAndText = new GradientLabel();
    private JPanel pnComponents = new JPanel();
    private ExpandComponent expandComponent;
    private CloseComponent closeComponent;
    public static final int ACTION_EXPAND = 1;
    public static final int ACTION_CLOSE = 2;
    public static final int ACTION_ALL = 15;
    private int _actions;
    private Color fg = Color.BLACK;
    private Color sfg = Color.RED;
    public static final String ACTION_COMMAND_EXPAND = "expandComponent";
    public static final String ACTION_COMMAND_CLOSE = "closeComponent";
    private static final Logger LOGGER = Logger.getLogger(TitledLabel.class.getName());
    private static final long serialVersionUID = -3346585834547573367L;

    public TitledLabel() {
        this(15);
    }

    public TitledLabel(String title) {
        this(15);
        this.setTitle(title);
    }

    public TitledLabel(String title, Icon icon) {
        this(15);
        this.setTitle(title);
        this.setIcon(icon);
    }

    public TitledLabel(String title, String toolTip, Icon icon) {
        this(15);
        this.setTitle(title);
        this.setToolTipText(toolTip);
        this.setIcon(icon);
    }

    public TitledLabel(int actions) {
        super(new BorderLayout());
        try {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.add((Component)this.lbIconAndText, "Center");
            this.add((Component)this.pnComponents, "East");
            this.pnComponents.setLayout(new FlowLayout(4, 0, 0));
            this.setComponents(actions);
            this.setOrientation(10);
            MouseHandler mouseHandler = new MouseHandler();
            this.lbIconAndText.addMouseListener(mouseHandler);
            this.lbIconAndText.addMouseMotionListener(mouseHandler);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void handleMouseEvent(MouseEvent e) {
        MouseEvent me = SwingUtilities.convertMouseEvent(e.getComponent(), e, this);
        this.processMouseEvent(me);
    }

    private void handleMouseMotionEvent(MouseEvent e) {
        MouseEvent me = SwingUtilities.convertMouseEvent(e.getComponent(), e, this);
        this.processMouseMotionEvent(me);
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    protected void processActionEvent(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ActionListener.class) {
                ((ActionListener)listeners[i + 1]).actionPerformed(event);
            }
            i -= 2;
        }
    }

    private void setComponents(int actions) {
        this.pnComponents.removeAll();
        String text = Utilities.defaultString(this.lbIconAndText.getText());
        if ((actions & 1) != 0) {
            if (this.expandComponent == null) {
                this.expandComponent = new ExpandComponent(this.fg, JNPadBundle.getString("TitledLabel.maximize", new Object[0]).concat(text), JNPadBundle.getString("TitledLabel.restore", new Object[0]).concat(text));
                this.expandComponent.addMouseListener(new ActionMouseHandler(this.expandComponent, ACTION_COMMAND_EXPAND));
            }
            this.pnComponents.add(this.expandComponent);
        }
        if ((actions & 2) != 0) {
            if (this.closeComponent == null) {
                this.closeComponent = new CloseComponent(this.fg, JNPadBundle.getString("TitledLabel.close", new Object[0]).concat(text));
                this.closeComponent.addMouseListener(new ActionMouseHandler(this.closeComponent, ACTION_COMMAND_CLOSE));
            }
            this.pnComponents.add(this.closeComponent);
        }
        this.pnComponents.revalidate();
        this.pnComponents.repaint();
        this._actions = actions;
    }

    public void setActions(int actions) {
        if (this._actions != actions) {
            this.setComponents(actions);
        }
    }

    public void setCloseToolTipText(String text) {
        if (this.closeComponent != null) {
            this.closeComponent.setToolTipText(text);
        }
    }

    public void setExpandToolTipText(String text, boolean normalState) {
        if (this.expandComponent != null) {
            this.expandComponent.setToolTipText(text, normalState);
        }
    }

    public boolean isMaximized() {
        return this.expandComponent != null && (this._actions & 1) != 0 && this.expandComponent.isMaximized;
    }

    public void setAsMaximized(boolean b) {
        if (this.expandComponent != null && (this._actions & 1) != 0 && this.expandComponent.isMaximized != b) {
            this.expandComponent.setAsMaximized(b);
        }
    }

    public JComponent getExpandComponent() {
        return this.expandComponent;
    }

    public JComponent getCloseComponent() {
        return this.closeComponent;
    }

    public void setTitle(String title) {
        this.lbIconAndText.setText(title);
        this.setCloseToolTipText(JNPadBundle.getString("TitledLabel.close", new Object[0]).concat(title));
        this.setExpandToolTipText(JNPadBundle.getString("TitledLabel.maximize", new Object[0]).concat(title), true);
        this.setExpandToolTipText(JNPadBundle.getString("TitledLabel.restore", new Object[0]).concat(title), false);
    }

    @Override
    public void setToolTipText(String text) {
        this.lbIconAndText.setToolTipText(text);
    }

    public String getTitle() {
        return this.lbIconAndText.getText();
    }

    public void setIcon(Icon icon) {
        this.lbIconAndText.setIcon(icon);
    }

    public Icon getIcon() {
        return this.lbIconAndText.getIcon();
    }

    public void setIconTitleGap(int iconTextGap) {
        this.lbIconAndText.setIconTextGap(iconTextGap);
    }

    public int getIconTitleGap() {
        return this.lbIconAndText.getIconTextGap();
    }

    public void setTitleColor(Color color) {
        this.lbIconAndText.setForeground(color);
        if (this.closeComponent != null) {
            this.closeComponent.setForeground(color);
        }
        if (this.expandComponent != null) {
            this.expandComponent.setForeground(color);
        }
        this.fg = color;
        this.sfg = ColorUtilities.isVeryDark(color) ? ColorUtilities.deriveColor(color, 0.6f) : ColorUtilities.deriveColor(color, 0.3f);
    }

    public Color getTitleColor() {
        return this.lbIconAndText.getForeground();
    }

    public void setTitleFont(Font font) {
        this.lbIconAndText.setFont(font);
    }

    public Font getTitleFont() {
        return this.lbIconAndText.getFont();
    }

    public void setTitleHorizontalAlignment(int alignment) {
        this.lbIconAndText.setHorizontalAlignment(alignment);
    }

    public int getTitleHorizontalAlignment() {
        return this.lbIconAndText.getHorizontalAlignment();
    }

    @Override
    public Color getGradientColor1() {
        return this.lbIconAndText.getGradientColor1();
    }

    @Override
    public Color getGradientColor2() {
        return this.lbIconAndText.getGradientColor2();
    }

    @Override
    public int getOrientation() {
        return this.lbIconAndText.getOrientation();
    }

    @Override
    public void setColor(Color color) {
        this.lbIconAndText.setColor(color);
        if (this.expandComponent != null) {
            this.expandComponent.setColor(color);
        }
        if (this.closeComponent != null) {
            this.closeComponent.setColor(color);
        }
    }

    @Override
    public void setGradientColor1(Color color1) {
        this.lbIconAndText.setGradientColor1(color1);
        if (this.expandComponent != null) {
            this.expandComponent.setGradientColor1(color1);
        }
        if (this.closeComponent != null) {
            this.closeComponent.setGradientColor1(color1);
        }
    }

    @Override
    public void setGradientColor2(Color color2) {
        this.lbIconAndText.setGradientColor2(color2);
        if (this.expandComponent != null) {
            this.expandComponent.setGradientColor2(color2);
        }
        if (this.closeComponent != null) {
            this.closeComponent.setGradientColor2(color2);
        }
    }

    @Override
    public void setGradientColors(Color color1, Color color2) {
        this.lbIconAndText.setGradientColors(color1, color2);
        if (this.expandComponent != null) {
            this.expandComponent.setGradientColors(color1, color2);
        }
        if (this.closeComponent != null) {
            this.closeComponent.setGradientColors(color1, color2);
        }
    }

    @Override
    public void setOrientation(int orientation) {
        this.lbIconAndText.setOrientation(orientation);
        if (this.expandComponent != null) {
            this.expandComponent.setOrientation(orientation);
        }
        if (this.closeComponent != null) {
            this.closeComponent.setOrientation(orientation);
        }
    }

    @Override
    public boolean supportOrientation(int orientation) {
        return this.lbIconAndText.supportOrientation(orientation);
    }

    private class ActionMouseHandler
    extends MouseAdapter {
        private Component _component;
        private String _action;

        ActionMouseHandler(Component component, String action) {
            this._component = component;
            this._action = action;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this._component.setForeground(TitledLabel.this.sfg);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this._component.setForeground(TitledLabel.this.fg);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                TitledLabel.this.processActionEvent(new ActionEvent(TitledLabel.this, 1001, this._action, e.getWhen(), e.getModifiers()));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this._component.setForeground(TitledLabel.this.fg);
            }
        }
    }

    private static class CloseComponent
    extends JComponent
    implements GradientPaintable {
        private Color _gradientColor1;
        private Color _gradientColor2;
        private int _orientation = 11;
        private BasicStroke _stroke = new BasicStroke(2.5f);
        private static final long serialVersionUID = 6377704503042360998L;

        CloseComponent(Color foreground, String tooltip) {
            this.setForeground(foreground);
            this.setToolTipText(tooltip);
        }

        @Override
        public void paintComponent(Graphics g) {
            Dimension d = this.getSize();
            try {
                Graphics2D g2D = (Graphics2D)g;
                Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this._orientation == 11) {
                    GradientPaint paint = new GradientPaint((float)d.width / 2.0f, 0.0f, this.getGradientColor1(), (float)d.width / 2.0f, d.height, this.getGradientColor2(), true);
                    g2D.setPaint(paint);
                } else {
                    g2D.setColor(this.getGradientColor2());
                }
                g2D.fillRect(0, 0, d.width, d.height);
                g.setColor(this.getForeground());
                g2D.setStroke(this._stroke);
                g2D.drawLine(5, 5, d.width - 5, d.height - 5);
                g2D.drawLine(5, d.height - 5, d.width - 5, 5);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
            }
            catch (Exception e) {
                g.setColor(this.getGradientColor2());
                g.fillRect(0, 0, d.width, d.height);
                GUIUtilities.paintCross(g, this.getForeground(), d.width / 2, d.height / 2, 6, 2);
            }
        }

        @Override
        public Color getGradientColor1() {
            return this._gradientColor1 == null ? this.getBackground() : this._gradientColor1;
        }

        @Override
        public Color getGradientColor2() {
            return this._gradientColor2 == null ? this.getBackground() : this._gradientColor2;
        }

        @Override
        public void setColor(Color color) {
            this.setGradientColors(color, color);
            this.setBackground(color);
        }

        @Override
        public void setGradientColor1(Color color1) {
            Color oldGC1 = this._gradientColor1;
            this._gradientColor1 = color1;
            if (oldGC1 != null ? !oldGC1.equals(color1) : color1 != null) {
                this.repaint();
            }
        }

        @Override
        public void setGradientColor2(Color color2) {
            Color oldGC2 = this._gradientColor2;
            this._gradientColor2 = color2;
            if (oldGC2 != null ? !oldGC2.equals(color2) : color2 != null) {
                this.repaint();
            }
        }

        @Override
        public void setGradientColors(Color color1, Color color2) {
            Color oldGC1 = this._gradientColor1;
            Color oldGC2 = this._gradientColor2;
            this._gradientColor1 = color1;
            this._gradientColor2 = color2;
            if (!(oldGC1 != null ? oldGC1.equals(color1) : color1 == null) || (oldGC2 != null ? !oldGC2.equals(color2) : color2 != null)) {
                this.repaint();
            }
        }

        @Override
        public int getOrientation() {
            return this._orientation;
        }

        @Override
        public void setOrientation(int orientation) {
            int oldOrientation = this._orientation;
            this._orientation = orientation;
            if (oldOrientation != orientation) {
                this.repaint();
            }
        }

        @Override
        public boolean supportOrientation(int orientation) {
            switch (orientation) {
                case 11: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }
    }

    private static class ExpandComponent
    extends JComponent
    implements GradientPaintable {
        private Color _gradientColor1;
        private Color _gradientColor2;
        private int _orientation = 11;
        private boolean isMaximized;
        private String tooltip_normal;
        private String tooltip_maximized;
        private static final long serialVersionUID = -3954029750338007549L;

        ExpandComponent(Color foreground, String tooltip_normal, String tooltip_maximized) {
            this.tooltip_normal = tooltip_normal;
            this.tooltip_maximized = tooltip_maximized;
            this.setForeground(foreground);
            this.setToolTipText(tooltip_normal);
        }

        void setToolTipText(String text, boolean normalState) {
            if (normalState) {
                this.tooltip_normal = text;
                if (!this.isMaximized) {
                    this.setToolTipText(this.tooltip_normal);
                }
            } else {
                this.tooltip_maximized = text;
                if (this.isMaximized) {
                    this.setToolTipText(this.tooltip_maximized);
                }
            }
        }

        void setAsMaximized(boolean b) {
            this.isMaximized = b;
            this.setToolTipText(b ? this.tooltip_maximized : this.tooltip_normal);
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            Dimension d = this.getSize();
            int thickness = 2;
            try {
                Graphics2D g2D = (Graphics2D)g;
                Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this._orientation == 11) {
                    GradientPaint paint = new GradientPaint((float)d.width / 2.0f, 0.0f, this.getGradientColor1(), (float)d.width / 2.0f, d.height, this.getGradientColor2(), true);
                    g2D.setPaint(paint);
                } else {
                    g2D.setColor(this.getGradientColor2());
                }
                g2D.fillRect(0, 0, d.width, d.height);
                if (this.isMaximized) {
                    GUIUtilities.paintRestore(g, this.getForeground(), 3, 6, d.width - 10, d.height - 10, thickness);
                } else {
                    GUIUtilities.paintMaximize(g, this.getForeground(), 4, 4, d.width - 8, d.height - 8, 2, thickness);
                }
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
            }
            catch (Exception e) {
                g.setColor(this.getGradientColor2());
                g.fillRect(0, 0, d.width, d.height);
                if (this.isMaximized) {
                    GUIUtilities.paintRestore(g, this.getForeground(), 3, 6, d.width - 10, d.height - 10, thickness);
                }
                GUIUtilities.paintMaximize(g, this.getForeground(), 4, 4, d.width - 8, d.height - 8, 2, thickness);
            }
        }

        @Override
        public Color getGradientColor1() {
            return this._gradientColor1 == null ? this.getBackground() : this._gradientColor1;
        }

        @Override
        public Color getGradientColor2() {
            return this._gradientColor2 == null ? this.getBackground() : this._gradientColor2;
        }

        @Override
        public void setColor(Color color) {
            this.setGradientColors(color, color);
            this.setBackground(color);
        }

        @Override
        public void setGradientColor1(Color color1) {
            Color oldGC1 = this._gradientColor1;
            this._gradientColor1 = color1;
            if (oldGC1 != null ? !oldGC1.equals(color1) : color1 != null) {
                this.repaint();
            }
        }

        @Override
        public void setGradientColor2(Color color2) {
            Color oldGC2 = this._gradientColor2;
            this._gradientColor2 = color2;
            if (oldGC2 != null ? !oldGC2.equals(color2) : color2 != null) {
                this.repaint();
            }
        }

        @Override
        public void setGradientColors(Color color1, Color color2) {
            Color oldGC1 = this._gradientColor1;
            Color oldGC2 = this._gradientColor2;
            this._gradientColor1 = color1;
            this._gradientColor2 = color2;
            if (!(oldGC1 != null ? oldGC1.equals(color1) : color1 == null) || (oldGC2 != null ? !oldGC2.equals(color2) : color2 != null)) {
                this.repaint();
            }
        }

        @Override
        public int getOrientation() {
            return this._orientation;
        }

        @Override
        public void setOrientation(int orientation) {
            int oldOrientation = this._orientation;
            this._orientation = orientation;
            if (oldOrientation != orientation) {
                this.repaint();
            }
        }

        @Override
        public boolean supportOrientation(int orientation) {
            switch (orientation) {
                case 11: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }
    }

    private class MouseHandler
    implements MouseInputListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TitledLabel.this.handleMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TitledLabel.this.handleMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TitledLabel.this.handleMouseEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TitledLabel.this.handleMouseEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TitledLabel.this.handleMouseEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TitledLabel.this.handleMouseMotionEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TitledLabel.this.handleMouseMotionEvent(e);
        }
    }
}

