/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.ui.EscapableDialog;
import jnpad.ui.JNPadLabel;
import jnpad.util.Utilities;

public final class ExceptionDialog
extends EscapableDialog {
    JPanel contentPane;
    JLabel lbIntro = new JNPadLabel();
    JEditorPane editorPane = new JEditorPane();
    JScrollPane scrollPane = new JScrollPane();
    JPanel pnButtons = new JPanel();
    JButton btOk = GUIUtilities.createOkButton();
    private String intro;
    private String message;
    public static final String TITLE_DEFAULT = JNPadBundle.getString("ExceptionDialog.title", new Object[0]);
    public static final String INTRO_DEFAULT = JNPadBundle.getString("ExceptionDialog.intro", new Object[0]);
    private static final Logger LOGGER = Logger.getLogger(ExceptionDialog.class.getName());
    private static final long serialVersionUID = 7269698195907364339L;

    public ExceptionDialog(Window w, Throwable e) throws HeadlessException {
        this(w, TITLE_DEFAULT, INTRO_DEFAULT, ExceptionDialog.formatException(e, false));
    }

    public ExceptionDialog(Window w, String intro, Throwable e) throws HeadlessException {
        this(w, TITLE_DEFAULT, intro, ExceptionDialog.formatException(e, false));
    }

    public ExceptionDialog(Window w, String intro, Throwable e, boolean highlightCause) throws HeadlessException {
        this(w, TITLE_DEFAULT, intro, ExceptionDialog.formatException(e, highlightCause));
    }

    public ExceptionDialog(Window w, String title, String intro, Throwable e, boolean highlightCause) throws HeadlessException {
        this(w, title, intro, ExceptionDialog.formatException(e, highlightCause));
    }

    public ExceptionDialog(Window w, String title, String intro, String message) throws HeadlessException {
        this(w, title, intro, message, true);
    }

    public ExceptionDialog(Window w, String title, String intro, String message, boolean modal) throws HeadlessException {
        super(w, title);
        try {
            this.intro = intro;
            this.message = message;
            this.jbInit();
            this.pack();
            Dimension size = this.getPreferredSize();
            Dimension sSize = GUIUtilities.getScreenDimension();
            Dimension max = new Dimension(sSize.width * 7 / 8, sSize.height * 7 / 8);
            this.setSize(GUIUtilities.getSize(size, max));
            this.setLocationRelativeTo(w);
            this.setModal(modal);
            this.setVisible(true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)super.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.lbIntro, "North");
        this.contentPane.add((Component)this.scrollPane, "Center");
        this.contentPane.add((Component)this.pnButtons, "South");
        this.lbIntro.setText(this.intro);
        this.lbIntro.setToolTipText(this.intro);
        this.lbIntro.setBorder(GUIUtilities.createEmptyBorder(5));
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        GUIUtilities.openBrowser(e.getURL());
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            }
        });
        this.editorPane.setText(this.message.replaceAll("\n", "<p>"));
        this.editorPane.setCaretPosition(0);
        this.editorPane.setPreferredSize(new Dimension(500, 200));
        this.scrollPane.getViewport().add((Component)this.editorPane, null);
        this.btOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.dispose();
            }
        });
        this.pnButtons.setLayout(new FlowLayout(2));
        this.pnButtons.add(this.btOk);
        this.setDefaultCloseOperation(2);
    }

    @Override
    protected void escapePressed() {
        this.dispose();
    }

    public static String formatException(Throwable e, boolean highlightCause) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (highlightCause && e.getCause() != null) {
            pw.print(String.valueOf(JNPadBundle.getString("ExceptionDialog.exception1", new Object[0])) + Utilities.now());
            pw.print(JNPadBundle.getString("ExceptionDialog.exception2", new Object[0]));
            e.getCause().printStackTrace(pw);
            pw.print(JNPadBundle.getString("ExceptionDialog.exception3", new Object[0]));
        }
        e.printStackTrace(pw);
        return sw.toString();
    }
}

