/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import jnpad.text.JNPadDocument;
import jnpad.text.syntax.JavaScheme;
import jnpad.text.syntax.SyntaxScheme;
import jnpad.text.syntax.SyntaxView;

public class JavaView
extends SyntaxView {
    JavaScheme scheme;

    public JavaView(Element elem, boolean mini) {
        super(elem, mini);
        this.scheme = !mini ? (JavaScheme)((JNPadDocument)this.getDocument()).getScheme() : (JavaScheme)((JNPadDocument)this.getDocument()).getMiniScheme();
    }

    @Override
    int doDrawUnselectedText(Graphics g, int x, int y, int start, int length) throws BadLocationException {
        Segment content = new Segment();
        this.getDocument().getText(start, length, content);
        boolean inComment = this.isParagraphInComment(start);
        boolean inJavadoc = this.isParagraphInJavadoc(start);
        int wordIndex = 0;
        while (wordIndex < content.length()) {
            Color color;
            Font savedFont;
            Font savedFont2;
            Segment text;
            char indexedChar = content.charAt(wordIndex);
            if (Character.isJavaIdentifierStart(indexedChar) && !inComment && !inJavadoc) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex);
                int scannedIdentifierLength = scannedIdentifier.length();
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                savedFont2 = g.getFont();
                JavaScheme.WordType type = this.scheme.getWordType(scannedIdentifier);
                g.setColor(this.scheme.getWordColor(type));
                g.setFont(this.scheme.getWordFont(type));
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (Character.isDigit(indexedChar) && !inComment && !inJavadoc) {
                String scannedNumericLiteral = this.scanNumericLiteral(content, wordIndex);
                int scannedNumericLiteralLength = scannedNumericLiteral.length();
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedNumericLiteralLength, text);
                g.setColor(this.scheme.getNumberColor());
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                wordIndex += scannedNumericLiteralLength;
                continue;
            }
            if (this.isStringDelimiter(indexedChar) && !inComment && !inJavadoc) {
                int scannedStringLength = this.scanStringLiteral(content, wordIndex);
                Segment text2 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedStringLength, text2);
                savedFont = g.getFont();
                g.setColor(this.scheme.getStringColor());
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text2, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedStringLength;
                continue;
            }
            if (this.isCharDelimiter(indexedChar) && !inComment && !inJavadoc) {
                int scannedCharLength = this.scanCharLiteral(content, wordIndex);
                Segment text3 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCharLength, text3);
                g.setColor(this.scheme.getStringColor());
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text3, x, y, g, (TabExpander)this, start + wordIndex);
                wordIndex += scannedCharLength;
                continue;
            }
            if (this.isSingleLineCommentStart(content, wordIndex) && !inComment && !inJavadoc) {
                int scannedCommentLength = this.scanSingleLineComment(content, wordIndex);
                Segment text4 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text4);
                savedFont = g.getFont();
                g.setColor(this.scheme.getCommentColor());
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text4, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isAnnotationStart(content, wordIndex) && inJavadoc && wordIndex < content.length() - 1) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex + 1);
                int scannedIdentifierLength = scannedIdentifier.length() + 1;
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                savedFont2 = g.getFont();
                if (this.scheme.isJavadocTag("@".concat(scannedIdentifier))) {
                    Font f = this.scheme.getJavadocTagFont();
                    g.setFont(f);
                    g.setColor(this.scheme.getJavadocTagColor());
                    if (f.isItalic()) {
                        Graphics2D g2D = (Graphics2D)g;
                        Object oldTextAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldTextAntialiasing);
                    } else {
                        x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                    }
                    if ("param".equals(scannedIdentifier)) {
                        scannedIdentifier = this.scanIdentifier(content, (wordIndex += scannedIdentifierLength) + 1);
                        scannedIdentifierLength = scannedIdentifier.length() + 1;
                        text = this.getLineBuffer();
                        this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                        g.setColor(this.scheme.getJavadocParamColor());
                        g.setFont(this.scheme.getJavadocParamFont());
                        x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                    }
                } else {
                    g.setFont(this.scheme.getJavadocFont());
                    g.setColor(this.scheme.getJavadocColor());
                    x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                }
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (this.isAnnotationStart(content, wordIndex) && !inComment && !inJavadoc && wordIndex < content.length() - 1) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex + 1);
                int scannedIdentifierLength = scannedIdentifier.length() + 1;
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                savedFont2 = g.getFont();
                if ("interface".equals(scannedIdentifier)) {
                    g.setColor(this.scheme.getKeywordColor());
                    g.setFont(this.scheme.getKeywordFont());
                } else {
                    g.setColor(this.scheme.getAnnotationColor());
                    g.setFont(this.scheme.getAnnotationFont());
                }
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (this.isJavadocEnd(content, wordIndex) && inJavadoc) {
                Segment text5 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 2, text5);
                Font savedFont3 = g.getFont();
                g.setFont(this.scheme.getJavadocFont());
                g.setColor(this.scheme.getJavadocColor());
                x = Utilities.drawTabbedText(text5, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont3);
                inJavadoc = false;
                wordIndex += 2;
                continue;
            }
            if (this.isMultiLineCommentEnd(content, wordIndex) && inComment) {
                Segment text6 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 2, text6);
                Font savedFont4 = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                g.setColor(this.scheme.getCommentColor());
                x = Utilities.drawTabbedText(text6, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont4);
                inComment = false;
                wordIndex += 2;
                continue;
            }
            if (this.isJavadocStart(content, wordIndex)) {
                int scannedCommentLength = this.scanMultiLineComment(content, wordIndex);
                Segment text7 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text7);
                savedFont = g.getFont();
                g.setFont(this.scheme.getJavadocFont());
                g.setColor(this.scheme.getJavadocColor());
                x = Utilities.drawTabbedText(text7, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                inJavadoc = true;
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isMultiLineCommentStart(content, wordIndex)) {
                int scannedCommentLength = this.scanMultiLineComment(content, wordIndex);
                Segment text8 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text8);
                savedFont = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                g.setColor(this.scheme.getCommentColor());
                x = Utilities.drawTabbedText(text8, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                inComment = true;
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isBracket(indexedChar) && !inComment && !inJavadoc) {
                Segment text9 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text9);
                Font savedFont5 = g.getFont();
                g.setFont(this.scheme.getBracketFont());
                g.setColor(this.scheme.getBracketColor());
                x = Utilities.drawTabbedText(text9, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont5);
                ++wordIndex;
                continue;
            }
            if (this.isOperator(indexedChar) && !inComment && !inJavadoc) {
                Segment text10 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text10);
                Font savedFont6 = g.getFont();
                g.setFont(this.scheme.getOperatorFont());
                g.setColor(this.scheme.getOperatorColor());
                x = Utilities.drawTabbedText(text10, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont6);
                ++wordIndex;
                continue;
            }
            Font savedFont7 = g.getFont();
            if (inJavadoc) {
                g.setFont(this.scheme.getJavadocFont());
                color = this.scheme.getJavadocColor();
            } else if (inComment) {
                g.setFont(this.scheme.getCommentFont());
                color = this.scheme.getCommentColor();
            } else {
                color = this.scheme.getTextColor();
            }
            text = this.getLineBuffer();
            this.getDocument().getText(start + wordIndex, 1, text);
            g.setColor(color);
            x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
            g.setFont(savedFont7);
            ++wordIndex;
        }
        return x;
    }

    @Override
    int doDrawSelectedText(Graphics g, int x, int y, int start, int length) throws BadLocationException {
        Segment content = new Segment();
        this.getDocument().getText(start, length, content);
        boolean inComment = this.isParagraphInComment(start);
        boolean inJavadoc = this.isParagraphInJavadoc(start);
        g.setColor(this.scheme.getSelectedTextColor());
        int wordIndex = 0;
        while (wordIndex < content.length()) {
            Font savedFont;
            Font savedFont2;
            Segment text;
            char indexedChar = content.charAt(wordIndex);
            if (Character.isJavaIdentifierStart(indexedChar) && !inComment && !inJavadoc) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex);
                int scannedIdentifierLength = scannedIdentifier.length();
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                savedFont2 = g.getFont();
                JavaScheme.WordType type = this.scheme.getWordType(scannedIdentifier);
                g.setFont(this.scheme.getWordFont(type));
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (this.isStringDelimiter(indexedChar) && !inComment && !inJavadoc) {
                int scannedStringLength = this.scanStringLiteral(content, wordIndex);
                Segment text2 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedStringLength, text2);
                savedFont = g.getFont();
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text2, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedStringLength;
                continue;
            }
            if (this.isCharDelimiter(indexedChar) && !inComment && !inJavadoc) {
                int scannedCharLength = this.scanCharLiteral(content, wordIndex);
                Segment text3 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCharLength, text3);
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text3, x, y, g, (TabExpander)this, start + wordIndex);
                wordIndex += scannedCharLength;
                continue;
            }
            if (this.isSingleLineCommentStart(content, wordIndex) && !inComment && !inJavadoc) {
                int scannedCommentLength = this.scanSingleLineComment(content, wordIndex);
                Segment text4 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text4);
                savedFont = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text4, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isAnnotationStart(content, wordIndex) && inJavadoc && wordIndex < content.length() - 1) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex + 1);
                int scannedIdentifierLength = scannedIdentifier.length() + 1;
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                savedFont2 = g.getFont();
                if (this.scheme.isJavadocTag("@".concat(scannedIdentifier))) {
                    Font f = this.scheme.getJavadocTagFont();
                    g.setFont(f);
                    if (f.isItalic()) {
                        Graphics2D g2D = (Graphics2D)g;
                        Object oldTextAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldTextAntialiasing);
                    } else {
                        x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                    }
                    if ("param".equals(scannedIdentifier)) {
                        scannedIdentifier = this.scanIdentifier(content, (wordIndex += scannedIdentifierLength) + 1);
                        scannedIdentifierLength = scannedIdentifier.length() + 1;
                        text = this.getLineBuffer();
                        this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                        g.setFont(this.scheme.getJavadocParamFont());
                        x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                    }
                } else {
                    g.setFont(this.scheme.getJavadocFont());
                    x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                }
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (this.isAnnotationStart(content, wordIndex) && !inComment && !inJavadoc && wordIndex < content.length() - 1) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex + 1);
                int scannedIdentifierLength = scannedIdentifier.length() + 1;
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                savedFont2 = g.getFont();
                if ("interface".equals(scannedIdentifier)) {
                    g.setFont(this.scheme.getKeywordFont());
                } else {
                    g.setFont(this.scheme.getAnnotationFont());
                }
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (this.isJavadocEnd(content, wordIndex) && inJavadoc) {
                Segment text5 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 2, text5);
                Font savedFont3 = g.getFont();
                g.setFont(this.scheme.getJavadocFont());
                x = Utilities.drawTabbedText(text5, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont3);
                inJavadoc = false;
                wordIndex += 2;
                continue;
            }
            if (this.isMultiLineCommentEnd(content, wordIndex) && inComment) {
                Segment text6 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 2, text6);
                Font savedFont4 = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text6, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont4);
                inComment = false;
                wordIndex += 2;
                continue;
            }
            if (this.isJavadocStart(content, wordIndex)) {
                int scannedCommentLength = this.scanMultiLineComment(content, wordIndex);
                Segment text7 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text7);
                savedFont = g.getFont();
                g.setFont(this.scheme.getJavadocFont());
                x = Utilities.drawTabbedText(text7, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                inJavadoc = true;
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isMultiLineCommentStart(content, wordIndex)) {
                int scannedCommentLength = this.scanMultiLineComment(content, wordIndex);
                Segment text8 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text8);
                savedFont = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text8, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                inComment = true;
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isBracket(indexedChar) && !inComment && !inJavadoc) {
                Segment text9 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text9);
                Font savedFont5 = g.getFont();
                g.setFont(this.scheme.getBracketFont());
                x = Utilities.drawTabbedText(text9, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont5);
                ++wordIndex;
                continue;
            }
            if (this.isOperator(indexedChar) && !inComment && !inJavadoc) {
                Segment text10 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text10);
                Font savedFont6 = g.getFont();
                g.setFont(this.scheme.getOperatorFont());
                x = Utilities.drawTabbedText(text10, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont6);
                ++wordIndex;
                continue;
            }
            Font savedFont7 = g.getFont();
            if (inJavadoc) {
                g.setFont(this.scheme.getJavadocFont());
            } else if (inComment) {
                g.setFont(this.scheme.getCommentFont());
            }
            Segment text11 = this.getLineBuffer();
            this.getDocument().getText(start + wordIndex, 1, text11);
            x = Utilities.drawTabbedText(text11, x, y, g, (TabExpander)this, start + wordIndex);
            g.setFont(savedFont7);
            ++wordIndex;
        }
        return x;
    }

    boolean isParagraphInComment(int startOffset) {
        Element root;
        Element previousElement;
        return startOffset > 0 && (previousElement = (root = this.getDocument().getDefaultRootElement()).getElement(root.getElementIndex(startOffset - 1))).getAttributes().containsAttribute(JNPadDocument.MULTILINE_COMMENT, JNPadDocument.MULTILINE_COMMENT);
    }

    boolean isParagraphInJavadoc(int startOffset) {
        Element root;
        Element previousElement;
        return startOffset > 0 && (previousElement = (root = this.getDocument().getDefaultRootElement()).getElement(root.getElementIndex(startOffset - 1))).getAttributes().containsAttribute(JNPadDocument.JAVADOC, JNPadDocument.JAVADOC);
    }

    @Override
    boolean isSingleLineCommentStart(Segment s, int index) {
        return s.charAt(index) == '/' && index + 1 < s.length() && s.charAt(index + 1) == '/';
    }

    @Override
    boolean isMultiLineCommentStart(Segment s, int index) {
        return s.charAt(index) == '/' && index + 1 < s.length() && s.charAt(index + 1) == '*';
    }

    @Override
    boolean isMultiLineCommentEnd(Segment s, int index) {
        return s.charAt(index) == '*' && index + 1 < s.length() && s.charAt(index + 1) == '/';
    }

    boolean isJavadocStart(Segment s, int index) {
        return s.charAt(index) == '/' && index + 1 < s.length() && s.charAt(index + 1) == '*' && index + 2 < s.length() && s.charAt(index + 2) == '*';
    }

    boolean isJavadocEnd(Segment s, int index) {
        return this.isMultiLineCommentEnd(s, index);
    }

    boolean isAnnotationStart(Segment s, int index) {
        return s.charAt(index) == '@';
    }

    @Override
    int scanMultiLineComment(Segment s, int index) {
        boolean starFound = false;
        int commentLength = 0;
        while (commentLength < s.length() - index) {
            char commentChar = s.charAt(index + commentLength);
            if (starFound && commentChar == '/') {
                ++commentLength;
                break;
            }
            starFound = false;
            if (commentChar == '\n') break;
            if (commentChar == '*') {
                starFound = true;
            }
            ++commentLength;
        }
        return commentLength;
    }

    @Override
    SyntaxScheme getScheme() {
        return this.scheme;
    }
}

