/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIDefaults;
import javax.swing.text.BadLocationException;
import jnpad.config.Config;
import jnpad.text.AbstractTextArea;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;
import jnpad.text.MiniViewerTextAreaUI;
import jnpad.ui.plaf.LAFUtils;

class MiniViewerTextArea
extends AbstractTextArea {
    private JNPadTextArea textArea;
    private JViewport viewPort;
    private Rectangle viewRect;
    private JScrollPane scrollPane;
    private boolean isViewRectVisible;
    private final AdjustmentListener adjustmentListener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            MiniViewerTextArea.this.adjustViewRect();
            MiniViewerTextArea.this.repaint();
        }
    };
    private static final long serialVersionUID = 3948063257147844952L;

    MiniViewerTextArea(EditPane editPane) {
        super(editPane);
        this.textArea = editPane.textArea;
        this.setDocument(editPane.getDocument());
        this.scrollPane = editPane.scrollPane;
        this.viewPort = this.scrollPane.getViewport();
        this.setViewRectVisible(Config.MINIMAP_VIEWRECT_VISIBLE.getValue());
        this.setUI(new MiniViewerTextAreaUI());
        this.setEditable(false);
        this.doConfigure(7);
        this.setCaretPosition(this.textArea.getCaretPosition());
    }

    void adjustViewRect() {
        if (this.isViewRectVisible() && !this.textArea.getLineWrap() && this.textArea.getText().length() > 0) {
            this.adjustViewRect(this.viewPort);
        }
    }

    private void adjustViewRect(JViewport vp) {
        Rectangle vr = vp.getViewRect();
        Point p = vr.getLocation();
        int startIndex = this.textArea.viewToModel(p);
        p.x += vr.width;
        p.y += vr.height;
        int endIndex = this.textArea.viewToModel(p);
        if (endIndex - startIndex >= 0) {
            String s = "WWWWWWWWW";
            int sw1 = this.textArea.getFontMetrics(this.textArea.getFont()).stringWidth("WWWWWWWWW");
            int sw2 = this.getFontMetrics(this.getFont()).stringWidth("WWWWWWWWW");
            try {
                Rectangle r1 = this.modelToView(startIndex);
                Rectangle r2 = this.modelToView(endIndex);
                if (r1 != null && r2 != null) {
                    int x = vr.x * sw2 / sw1;
                    int y = r1.y;
                    int w = vr.width * sw2 / sw1;
                    int h = r2.y - r1.y;
                    this.viewRect = new Rectangle(x, y, w, h);
                } else {
                    this.viewRect = null;
                }
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public Rectangle getViewRect() {
        return this.viewRect;
    }

    @Override
    public boolean isViewRectVisible() {
        return this.isViewRectVisible;
    }

    @Override
    public void setViewRectVisible(boolean b) {
        if (this.isViewRectVisible != b) {
            System.out.println(b);
            if (b) {
                this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(this.adjustmentListener);
                this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
            } else {
                this.scrollPane.getHorizontalScrollBar().removeAdjustmentListener(this.adjustmentListener);
                this.scrollPane.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
            }
            this.isViewRectVisible = b;
            Config.MINIMAP_VIEWRECT_VISIBLE.setValue(b);
        }
    }

    @Override
    public void configure(int cfg) {
        this.doConfigure(cfg);
    }

    private void doConfigure(int cfg) {
        if ((cfg & 1) != 0) {
            Color bg = this.textArea.getBackground();
            if (LAFUtils.isNimbusLAF()) {
                UIDefaults overrides = new UIDefaults();
                overrides.put("TextPane[Enabled].backgroundPainter", bg);
                this.putClientProperty("Nimbus.Overrides", overrides);
                this.putClientProperty("Nimbus.Overrides.InheritDefaults", Boolean.TRUE);
            }
            this.setBackground(bg);
            this.setForeground(this.textArea.getForeground());
            this.setSelectionColor(this.textArea.getSelectionColor());
            this.setSelectedTextColor(this.textArea.getSelectedTextColor());
            this.setCaretColor(this.textArea.getCaretColor());
        }
        if ((cfg & 2) != 0) {
            this.setFont(this.textArea.getFont().deriveFont(Config.MINIMAP_FONT_SIZE.getValue().floatValue()));
        }
        if ((cfg & 4) != 0) {
            this.setRightMarginLineVisible(this.textArea.isRightMarginLineVisible());
            this.setRightMarginLineWidth(this.textArea.getRightMarginLineWidth());
            this.setLineWrap(this.textArea.getLineWrap());
            this.setWrapStyleWord(this.textArea.getWrapStyleWord());
            this.setTabSize(this.textArea.getTabSize());
        }
    }

    @Override
    public String getContentType() {
        return this.textArea.getContentType();
    }

    @Override
    public boolean isRightMarginLineVisible() {
        return this.textArea.isRightMarginLineVisible();
    }

    @Override
    public int getRightMarginLineWidth() {
        return this.textArea.getRightMarginLineWidth();
    }

    @Override
    public Color getRightMarginLineColor() {
        return this.textArea.getRightMarginLineColor();
    }

    @Override
    boolean isMain() {
        return this.textArea.isMain();
    }
}

