/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import jnpad.text.JNPadTextArea;
import jnpad.text.JNPadTextAreaEditorKit;
import jnpad.text.syntax.ASN1View;
import jnpad.text.syntax.CPPView;
import jnpad.text.syntax.CView;
import jnpad.text.syntax.ContentTypes;
import jnpad.text.syntax.JavaView;
import jnpad.text.syntax.PlainView2;
import jnpad.text.syntax.PropertiesView;
import jnpad.text.syntax.WrappedPlainView2;

public class JNPadTextAreaUI
extends BasicTextAreaUI
implements ContentTypes {
    private static final EditorKit defaultKit = new JNPadTextAreaEditorKit();

    public static ComponentUI createUI(JComponent ta) {
        return new JNPadTextAreaUI();
    }

    @Override
    protected void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("jnpad.contentType")) {
            this.modelChanged();
        }
    }

    @Override
    public View create(Element elem) {
        JTextComponent c = this.getComponent();
        if (c instanceof JNPadTextArea) {
            JNPadTextArea area = (JNPadTextArea)c;
            String style = area.getContentType();
            if ("text/java".equals(style)) {
                return new JavaView(elem, false);
            }
            if ("text/c".equals(style)) {
                return new CView(elem, false);
            }
            if ("text/cpp".equals(style)) {
                return new CPPView(elem, false);
            }
            if ("text/properties".equals(style)) {
                return new PropertiesView(elem, false);
            }
            if ("text/asn1".equals(style)) {
                return new ASN1View(elem, false);
            }
            if ("text/plain".equals(style)) {
                if (area.getLineWrap()) {
                    return new WrappedPlainView2(elem, area.getWrapStyleWord());
                }
                return new PlainView2(elem, false);
            }
        }
        return super.create(elem);
    }

    @Override
    public void installUI(JComponent c) {
        if (!(c instanceof JNPadTextArea)) {
            throw new Error("JNPadTextAreaUI needs an instance of JNPadTextArea!");
        }
        super.installUI(c);
    }

    @Override
    public EditorKit getEditorKit(JTextComponent tc) {
        return defaultKit;
    }
}

