/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.Utilities;
import jnpad.GUIUtilities;
import jnpad.action.ActionManager;
import jnpad.config.Config;
import jnpad.text.DocumentRange;
import jnpad.text.JNPadTextArea;
import jnpad.text.SimpleGutter;
import jnpad.text.TextUtilities;
import jnpad.ui.JNPadMenuItem;

public class Gutter
extends SimpleGutter {
    boolean bracketScopeVisible = true;
    Color bracketScopeColor = Color.ORANGE;
    private static final Logger LOGGER = Logger.getLogger(Gutter.class.getName());
    private static final long serialVersionUID = -5244882856595180262L;

    public Gutter(JNPadTextArea textArea) {
        this(textArea, 3);
    }

    public Gutter(JNPadTextArea textArea, int minimumDisplayDigits) {
        super(textArea, minimumDisplayDigits);
        this.doConfigure(7);
    }

    @Override
    public void configure(int cfg) {
        super.configure(cfg);
        this.doConfigure(cfg);
    }

    private void doConfigure(int cfg) {
        if ((cfg & 1) != 0) {
            this.setBracketScopeColor(Config.GUTTER_BRACKET_SCOPE_COLOR.getValue());
        }
        if ((cfg & 4) != 0) {
            this.setBracketScopeVisible(Config.GUTTER_BRACKET_SCOPE_VISIBLE.getValue());
        }
    }

    public boolean isBracketScopeVisible() {
        return this.bracketScopeVisible;
    }

    public void setBracketScopeVisible(boolean b) {
        this.bracketScopeVisible = b;
    }

    public Color getBracketScopeColor() {
        return this.bracketScopeColor;
    }

    public void setBracketScopeColor(Color color) {
        if (color != null) {
            this.bracketScopeColor = color;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        GUIUtilities.setRenderingHints(g);
        this.superPaintComponent(g);
        g.setColor(this.getBookmarkBackground());
        if (this.textArea.isMain()) {
            g.fillRect(0, 0, this.getBookmarkAreaWidth(), this.getHeight());
        } else {
            g.drawLine(this.getBookmarkAreaWidth(), 0, this.getBookmarkAreaWidth(), this.getHeight());
        }
        FontMetrics fontMetrics = this.textArea.getFontMetrics(this.textArea.getFont());
        Insets insets = this.getInsets();
        int availableWidth = this.getSize().width - insets.left - insets.right;
        Rectangle clip = g.getClipBounds();
        int rowStartOffset = this.textArea.viewToModel(new Point(0, clip.y));
        int endOffset = this.textArea.viewToModel(new Point(0, clip.y + clip.height));
        while (rowStartOffset <= endOffset) {
            try {
                Rectangle r = this.textArea.modelToView(rowStartOffset);
                boolean isCurrentLine = this.isCurrentLine(rowStartOffset);
                if (isCurrentLine && this.isCurrentLineBackgroundEnabled() && !this.editPane.isActiveLineVisible()) {
                    g.setColor(this.getCurrentLineBackground());
                    g.fillRect(r.x + this.getBookmarkAreaWidth(), r.y, this.getWidth(), r.height);
                }
                if (this.isBracketScopeVisible()) {
                    this.paintBracketScope(g, rowStartOffset, r);
                }
                g.setColor(isCurrentLine ? this.getCurrentLineForeground() : this.getForeground());
                String lineNumber = this.getTextLineNumber(rowStartOffset);
                int stringWidth = fontMetrics.stringWidth(lineNumber);
                int x = this.getOffsetX(availableWidth, stringWidth) + insets.left;
                int y = this.getOffsetY(rowStartOffset, fontMetrics);
                g.drawString(lineNumber, x, y);
                rowStartOffset = Utilities.getRowEnd(this.textArea, rowStartOffset) + 1;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        Graphics2D g2D = (Graphics2D)g;
        Object oldRendering = g2D.getRenderingHint(RenderingHints.KEY_RENDERING);
        Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            if (this.editPane.hasBookmarks()) {
                DocumentRange[] ranges;
                DocumentRange[] documentRangeArray = ranges = this.editPane.getBookmarks();
                int n = ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    DocumentRange range = documentRangeArray[n2];
                    this.paintBookmark(g, range.getStartOffset());
                    ++n2;
                }
            }
            if (this.textArea.hasSelection() && this.getSelectionWidth() > 1) {
                this.paintSelection(g);
            }
        }
        finally {
            g2D.setRenderingHint(RenderingHints.KEY_RENDERING, oldRendering);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
        }
    }

    void paintBracketScope(Graphics g, int rowStartOffset, Rectangle r) {
        try {
            int iScopeStart = this.editPane.getBracketLineIndex();
            int iScopeEnd = this.editPane.getOtherBracketLineIndex();
            int iLineIndex = this.textArea.getLineOfOffset(rowStartOffset);
            if (iScopeStart >= 0) {
                g.setColor(this.getBracketScopeColor());
                int iX = this.getBookmarkAreaWidth() + 2;
                int iY = r.y;
                int iW = 2;
                int iH = r.height;
                if (iScopeStart != iScopeEnd) {
                    if (iLineIndex == iScopeStart) {
                        g.fillRect(iX, iY + iH / 2, 2 * iW, iW);
                        g.fillRect(iX, iY + iH / 2 + iW, iW, iH - iH / 2);
                    } else if (iLineIndex == iScopeEnd) {
                        g.fillRect(iX, iY, iW, iH / 2);
                        g.fillRect(iX, iY + iH / 2, 2 * iW, iW);
                    } else if (iLineIndex > iScopeStart && iLineIndex < iScopeEnd) {
                        g.fillRect(iX, iY, iW, iH);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    @Override
    void checkForRepaint() {
        super.checkForRepaint();
        this.editPane.updateSelection();
    }

    @Override
    void handleMouseReleased(MouseEvent e) {
        Rectangle bounds;
        Object obj = e.getSource();
        if (obj == this && (bounds = new Rectangle(0, 0, this.getBookmarkAreaWidth(), this.getHeight())).contains(e.getPoint()) && e.isPopupTrigger()) {
            this.showTogglePopup(e);
        }
    }

    @Override
    void handleMousePressed(MouseEvent e) {
        Object obj = e.getSource();
        if (obj == this.textArea) {
            this.checkForRepaint();
        } else if (obj == this) {
            Rectangle bounds = new Rectangle(0, 0, this.getBookmarkAreaWidth(), this.getHeight());
            if (bounds.contains(e.getPoint())) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    this.toggleBookmark(e);
                } else if (e.isPopupTrigger()) {
                    this.showTogglePopup(e);
                }
            } else if (e.isControlDown() && e.getClickCount() == 2) {
                this.toggleBookmark(e);
            } else if (!e.isControlDown() && e.getClickCount() == 1) {
                if (e.isShiftDown()) {
                    int rowPos = this.textArea.viewToModel(new Point(0, e.getY()));
                    Element line = this.textArea.getJNPadDocument().getParagraphElement(rowPos);
                    this.selectionEnd = line.getEndOffset() - 1;
                    if (this.selectionBegin <= this.selectionEnd) {
                        this.textArea.select(this.selectionBegin, this.selectionEnd);
                    } else {
                        this.textArea.select(this.selectionEnd, this.selectionBegin);
                    }
                } else {
                    int rowPos = this.textArea.viewToModel(new Point(0, e.getY()));
                    Element line = this.textArea.getJNPadDocument().getParagraphElement(rowPos);
                    this.selectionBegin = line.getStartOffset();
                    this.selectionEnd = line.getEndOffset() - 1;
                    this.textArea.select(this.selectionBegin, this.selectionEnd);
                }
            }
        }
    }

    private void showTogglePopup(MouseEvent e) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JNPadMenuItem(ActionManager.INSTANCE.get("next-bookmark")));
        popupMenu.add(new JNPadMenuItem(ActionManager.INSTANCE.get("previous-bookmark")));
        popupMenu.add(new JNPadMenuItem(ActionManager.INSTANCE.get("clear-all-bookmarks")));
        SwingUtilities.updateComponentTreeUI(popupMenu);
        popupMenu.pack();
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void toggleBookmark(MouseEvent e) {
        int row = this.textArea.viewToModel(new Point(0, e.getY()));
        this.editPane.toggleBookmark(TextUtilities.getLineNumber(this.textArea.getDocument(), row));
    }
}

