/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.util.LinkedList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import jnpad.GUIUtilities;
import jnpad.config.Config;
import jnpad.text.Buffer;

public class CompoundUndoManager
implements UndoableEditListener {
    MyUndoManager undoManager;
    private LinkedList<CompoundEdit> editStack;
    private CompoundEdit currentEdit;
    private Buffer buffer;
    private volatile UndoableEdit savePoint;

    public CompoundUndoManager(Buffer buffer) {
        this.buffer = buffer;
        this.undoManager = new MyUndoManager();
        this.currentEdit = this.undoManager;
        this.editStack = new LinkedList();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.addUndoableEdit(e.getEdit());
    }

    public void addUndoableEdit(UndoableEdit edit) {
        this.currentEdit.addEdit(edit);
        this.notifyUndoHappened();
    }

    public void beginCompoundEdit() {
        this.editStack.add(this.currentEdit);
        this.currentEdit = new CompoundEdit();
    }

    public void endCompoundEdit() {
        this.currentEdit.end();
        CompoundEdit lastEdit = this.editStack.removeLast();
        lastEdit.addEdit(this.currentEdit);
        this.currentEdit = lastEdit;
        this.notifyUndoHappened();
    }

    private void notifyUndoHappened() {
        if (this.currentEdit == this.undoManager) {
            GUIUtilities.runOrInvokeLater(new Runnable(){

                @Override
                public void run() {
                    CompoundUndoManager.this.buffer.updateControls(1);
                }
            });
        }
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void undo() throws CannotUndoException {
        this.undoManager.undo();
    }

    public void redo() throws CannotUndoException {
        this.undoManager.redo();
    }

    public void discardAllEdits() {
        this.undoManager.discardAllEdits();
    }

    public void documentSaved() {
        this.savePoint = this.undoManager.editToBeUndone();
    }

    public boolean isModified() {
        return this.undoManager.editToBeUndone() != this.savePoint;
    }

    static class MyUndoManager
    extends UndoManager {
        private static final long serialVersionUID = -3588486176872330816L;

        MyUndoManager() {
            this.setLimit(Config.UNDO_LIMIT.getValue());
        }

        @Override
        protected UndoableEdit lastEdit() {
            return super.lastEdit();
        }

        @Override
        protected UndoableEdit editToBeUndone() {
            return super.editToBeUndone();
        }
    }
}

