/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import jnpad.GUIUtilities;
import jnpad.config.Accelerators;
import jnpad.text.CompletionUtilities;
import jnpad.text.JNPadTextArea;
import jnpad.text.TextBundle;
import jnpad.ui.ColorUtilities;
import jnpad.ui.JNPadLabel;
import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Utilities;

public class CompletionPopup
extends JPopupMenu {
    private JLabel lbMatches;
    private JList list;
    private String word;
    private JNPadTextArea textArea;
    private String[] completions;
    private static int maxWidth;
    private Listener listener = new Listener();
    private static final Logger LOGGER;
    private static final long serialVersionUID = -4013987311209191365L;

    static {
        LOGGER = Logger.getLogger(CompletionPopup.class.getName());
    }

    public CompletionPopup(JNPadTextArea textArea) {
        try {
            this.textArea = textArea;
            this.list = new JList();
            this.lbMatches = new JNPadLabel();
            this.jbInit();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public CompletionPopup(JNPadTextArea textArea, String word, String[] completions) {
        try {
            this.textArea = textArea;
            this.word = word;
            this.completions = Utilities.copyOf(completions);
            this.list = new JList<String>(completions);
            this.lbMatches = new JNPadLabel(TextBundle.getString("CompletionPopup.label", word));
            this.jbInit();
            if (completions.length > 0) {
                this.list.setSelectedIndex(0);
            }
            this.showCompletionPopup();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        Color fg;
        Color bg;
        this.setLayout(new BorderLayout());
        if (LAFUtils.isNimbusLAF()) {
            bg = new Color(242, 242, 189);
            fg = ColorUtilities.createPureColor(LAFUtils.getToolTipForeground());
        } else {
            bg = LAFUtils.getToolTipBackground();
            fg = LAFUtils.getToolTipForeground();
        }
        Font font = new Font("Monospaced", 2, 11);
        this.lbMatches.setHorizontalAlignment(0);
        this.lbMatches.setOpaque(true);
        this.lbMatches.setBackground(bg.darker());
        this.lbMatches.setBorder(BorderFactory.createRaisedBevelBorder());
        this.lbMatches.setFont(font);
        this.add((Component)this.lbMatches, "North");
        this.list.setBackground(bg);
        this.list.setForeground(fg);
        this.list.setSelectionBackground(this.textArea.getSelectionColor());
        this.list.setSelectionForeground(this.textArea.getSelectedTextColor());
        this.list.setFont(this.textArea.getFont());
        this.setOpaque(true);
        this.list.setSelectionMode(0);
        this.list.getSelectionModel().setAnchorSelectionIndex(4);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CompletionPopup.this.handleMouseClick(e);
            }
        });
        FontMetrics fm = this.getFontMetrics(this.textArea.getFont());
        maxWidth = 50 * fm.charWidth('m');
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pSize = super.getPreferredSize();
        return new Dimension(Math.min(pSize.width, maxWidth), pSize.height);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.textArea.addKeyListener(this.listener);
        if (Accelerators.isUsingCompositeShortcuts()) {
            this.textArea.setKeyEventInterceptor(this.listener);
        }
        this.textArea.getDocument().addDocumentListener(this.listener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.textArea.removeKeyListener(this.listener);
        if (Accelerators.isUsingCompositeShortcuts()) {
            this.textArea.setKeyEventInterceptor(null);
        }
        this.textArea.getDocument().removeDocumentListener(this.listener);
    }

    public void setWord(String word) {
        this.word = word;
        this.lbMatches.setText(TextBundle.getString("CompletionPopup.label", word));
        if (this.completions != null) {
            Vector<String> v = CompletionUtilities.refreshListData(word, this.completions);
            if (v.size() > 0) {
                this.list.setListData(v);
                this.list.setSelectedIndex(0);
            } else {
                this.setVisible(false);
            }
        }
    }

    public void showCompletions(String word, String[] completions) {
        if (Utilities.isEmptyString(word) || completions == null || completions.length == 0) {
            this.setVisible(false);
            return;
        }
        this.word = word;
        this.completions = Utilities.copyOf(completions);
        this.lbMatches.setText(TextBundle.getString("CompletionPopup.label", word));
        this.list.setListData(completions);
        if (completions.length > 0) {
            this.list.setSelectedIndex(0);
        }
        this.showCompletionPopup();
    }

    private void showCompletionPopup() {
        Point p;
        JNPadTextArea txtarea;
        block4: {
            Rectangle r;
            txtarea = this.textArea.getMain();
            this.pack();
            try {
                r = txtarea.modelToView(txtarea.getCaretPosition());
            }
            catch (BadLocationException blex) {
                Point pt = txtarea.getCaret().getMagicCaretPosition();
                int x = (int)pt.getX();
                int y = (int)pt.getY();
                int popupWidth = this.getPreferredSize().width;
                int popupHeight = this.getPreferredSize().height;
                int fontHeight = txtarea.getFont().getSize();
                int widthLimit = txtarea.getSize().width - popupWidth;
                int heightLimit = txtarea.getSize().height - (popupHeight + 2);
                if (x >= widthLimit) {
                    x -= popupWidth;
                }
                if (y >= heightLimit) {
                    y -= popupHeight + fontHeight;
                }
                p = new Point(x, y + fontHeight + 2);
                break block4;
            }
            p = new Point(r.x, r.y);
            int fontHeight = txtarea.getFont().getSize();
            SwingUtilities.convertPointToScreen(p, txtarea);
            Rectangle screenSize = GUIUtilities.getScreenBoundsForPoint(p);
            screenSize.height = screenSize.height - 30 - fontHeight;
            p.y = p.y + this.getPreferredSize().height >= screenSize.height ? (p.y -= this.getPreferredSize().height) : (p.y += fontHeight);
            SwingUtilities.convertPointFromScreen(p, txtarea);
        }
        this.show(txtarea, p.x, p.y);
        txtarea.requestFocus();
    }

    private void selectNextIndex() {
        int index = this.list.getSelectedIndex();
        int visibleIndexGap = 3;
        int lastIndex = this.getListSize() - 1;
        int gap = lastIndex - ++index;
        if (gap < 3) {
            visibleIndexGap = gap + 1;
            if (gap < 0) {
                index = lastIndex;
                visibleIndexGap = 0;
            }
        }
        this.highlightIndex(index, index + visibleIndexGap);
    }

    private void selectPreviousIndex() {
        int index = this.list.getSelectedIndex();
        int visibleIndexGap = 3;
        if (--index < 0) {
            index = 0;
            visibleIndexGap = 0;
        }
        this.highlightIndex(index, index - visibleIndexGap);
    }

    private void selectNextPageIndex() {
        int index = this.list.getSelectedIndex();
        int visibleIndexGap = 3;
        int lastIndex = this.getListSize() - 1;
        int gap = lastIndex - (index += 8);
        if (gap < 3) {
            visibleIndexGap = gap + 1;
            if (gap < 0) {
                index = lastIndex;
                visibleIndexGap = 0;
            }
        }
        this.highlightIndex(index, index + visibleIndexGap);
    }

    private void selectPreviousPageIndex() {
        int index = this.list.getSelectedIndex();
        int visibleIndexGap = 3;
        if ((index -= 8) < 0) {
            index = 0;
            visibleIndexGap = 0;
        }
        this.highlightIndex(index, index - visibleIndexGap);
    }

    private void selectHomeIndex() {
        this.highlightIndex(0, 0);
    }

    private void selectEndIndex() {
        int lastIndex = this.getListSize() - 1;
        this.highlightIndex(lastIndex, lastIndex);
    }

    private int getListSize() {
        ListModel lm = this.list.getModel();
        return lm.getSize();
    }

    private void highlightIndex(int index, int visibleIndex) {
        this.list.setSelectedIndex(index);
        this.list.ensureIndexIsVisible(visibleIndex);
    }

    void handleMouseClick(MouseEvent e) {
        if (this.isVisible()) {
            this.insertSelectedCompletion();
        }
    }

    private void insertSelectedCompletion() {
        String selectedValue = (String)this.list.getSelectedValue();
        this.setVisible(false);
        if (Utilities.isNotEmptyString(selectedValue)) {
            try {
                this.textArea.insert(selectedValue.substring(this.word.length()), this.textArea.getCaretPosition());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    void handleKeyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 38) {
            this.selectPreviousIndex();
        } else if (keyCode == 40) {
            this.selectNextIndex();
        } else if (keyCode == 33) {
            this.selectPreviousPageIndex();
        } else if (keyCode == 34) {
            this.selectNextPageIndex();
        } else if (keyCode == 36) {
            this.selectHomeIndex();
        } else if (keyCode == 35) {
            this.selectEndIndex();
        } else if (keyCode == 27 || keyCode == 32 || keyCode == 9) {
            this.setVisible(false);
        } else {
            if (keyCode == 10) {
                if (this.isVisible()) {
                    e.consume();
                    this.insertSelectedCompletion();
                }
                return;
            }
            if (keyCode != 37 && keyCode != 39) {
                return;
            }
        }
        e.consume();
    }

    void handleDocumentEvent(int offset) {
        try {
            String word = CompletionUtilities.getWord(this.textArea, offset);
            if (Utilities.isBlankString(word)) {
                this.setVisible(false);
                return;
            }
            this.setWord(word);
        }
        catch (BadLocationException blex) {
            LOGGER.log(Level.WARNING, blex.getMessage(), blex);
        }
    }

    private class Listener
    extends KeyAdapter
    implements DocumentListener {
        private Listener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            CompletionPopup.this.handleKeyPressed(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CompletionPopup.this.handleDocumentEvent(CompletionPopup.this.textArea.getCaretPosition() - e.getLength());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CompletionPopup.this.handleDocumentEvent(CompletionPopup.this.textArea.getCaretPosition() + e.getLength());
        }
    }
}

