/*
 * Decompiled with CFR 0.152.
 */
package jnpad.filebrowser;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import jnpad.config.Config;
import jnpad.config.Configurable;
import jnpad.filebrowser.FileBrowser;
import jnpad.filebrowser.FileBrowserBundle;
import jnpad.filebrowser.FileBrowserObject;
import jnpad.filebrowser.FileListCellRenderer;
import jnpad.util.Utilities;

public class FileList
extends JList
implements Configurable {
    private DefaultListModel listModel = new DefaultListModel();
    private File[] files = new File[0];
    private File[] directories = new File[0];
    private File _file;
    static final File[] FILE_SYSTEM_ROOTS = Utilities.file_system_roots();
    private static File[] _fileSystemRoots = (File[])FILE_SYSTEM_ROOTS.clone();
    private FileBrowser browser;
    private static final long serialVersionUID = 3508127063550226812L;

    public FileList(FileBrowser browser) {
        this.enableEvents(24L);
        this.browser = browser;
        this.configure(1);
        this.setModel(this.listModel);
        this.setSelectionMode(0);
        this.setCellRenderer(new FileListCellRenderer());
    }

    @Override
    public void configure(int cfg) {
        if ((cfg & 1) != 0) {
            this.setFont(Config.BROWSER_NORMAL_FONT.getValue());
            this.setBackground(Config.TEXT_BACKGROUND.getValue());
            this.setForeground(Config.TEXT_FOREGROUND.getValue());
            this.setSelectionBackground(Config.TEXT_SELECTION_BACKGROUND.getValue());
            this.setSelectionForeground(Config.TEXT_SELECTION_FOREGROUND.getValue());
            FileBrowserObject.updateDirColors();
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (e.getID() == 401) {
            int keyCode = e.getKeyCode();
            int modifiers = e.getModifiers();
            if (keyCode == 10 || keyCode == 32) {
                if (modifiers == 2) {
                    this.refresh(this.getSelectedValue().toString());
                } else {
                    this.action();
                }
            } else if (keyCode == 8) {
                this.backSpace();
            } else if (keyCode == 36) {
                if (modifiers == 2) {
                    this.browser.goToHomeDir();
                } else if (modifiers == 8) {
                    this.browser.setHomeDir(this.getFile().getPath());
                }
            } else if (modifiers == 2 && (keyCode == 97 || keyCode == 49)) {
                this.browser.setPositionFrameOnScreen(0.0, 1.0);
            } else if (modifiers == 2 && (keyCode == 98 || keyCode == 50)) {
                this.browser.setPositionFrameOnScreen(0.5, 1.0);
            } else if (modifiers == 2 && (keyCode == 99 || keyCode == 51)) {
                this.browser.setPositionFrameOnScreen(1.0, 1.0);
            } else if (modifiers == 2 && (keyCode == 100 || keyCode == 52)) {
                this.browser.setPositionFrameOnScreen(0.0, 0.5);
            } else if (modifiers == 2 && (keyCode == 101 || keyCode == 53)) {
                this.browser.setPositionFrameOnScreen(0.5, 0.5);
            } else if (modifiers == 2 && (keyCode == 102 || keyCode == 54)) {
                this.browser.setPositionFrameOnScreen(1.0, 0.5);
            } else if (modifiers == 2 && (keyCode == 103 || keyCode == 55)) {
                this.browser.setPositionFrameOnScreen(0.0, 0.0);
            } else if (modifiers == 2 && (keyCode == 104 || keyCode == 56)) {
                this.browser.setPositionFrameOnScreen(0.5, 0.0);
            } else if (modifiers == 2 && (keyCode == 105 || keyCode == 57)) {
                this.browser.setPositionFrameOnScreen(1.0, 0.0);
            } else if (keyCode == 112) {
                this.browser.toggleInfoVisible();
            } else if (keyCode == 113) {
                this.browser.toggleColor();
            } else if (keyCode == 114) {
                this.browser.toggleHumanReadable();
            } else if (keyCode == 115) {
                this.browser.toggleClassify();
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 502 && e.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(e)) {
            this.action();
        }
    }

    public void refresh(Object obj) {
        this.refresh();
        if (this.listModel.contains(obj)) {
            this.setSelectedValue(obj, true);
        } else {
            FileBrowserObject fileBrowserObject = new FileBrowserObject(new File(this._file, obj.toString()));
            this.setSelectedValue(fileBrowserObject, true);
        }
    }

    public void refresh() {
        int selectedIndex = this.getSelectedIndex();
        Object obj = this.getSelectedValue();
        this.listFile(this._file);
        if (this.listModel.indexOf(obj) > 0) {
            this.setSelectedValue(obj, true);
        } else if (selectedIndex < this.listModel.getSize()) {
            this.setSelectedValue(this.listModel.getElementAt(selectedIndex), true);
        }
    }

    public boolean listFile(File file) {
        this._file = file;
        try {
            this.browser.setStatus(this._file.getAbsolutePath());
            this.files = this._file.listFiles(this.browser.fileFilter);
            this.directories = this._file.listFiles(this.browser.directoryFilter);
            Arrays.sort(this.files);
            Arrays.sort(this.directories);
            this.listModel.removeAllElements();
            this.removeAll();
            String dotdot = Config.BROWSER_CLASSIFY.getValue() != false ? "../" : "..";
            this.listModel.addElement(dotdot);
            File[] fileArray = this.directories;
            int n = this.directories.length;
            int n2 = 0;
            while (n2 < n) {
                File directory = fileArray[n2];
                this.listModel.addElement(new FileBrowserObject(directory));
                ++n2;
            }
            fileArray = this.files;
            n = this.files.length;
            n2 = 0;
            while (n2 < n) {
                File file1 = fileArray[n2];
                this.listModel.addElement(new FileBrowserObject(file1));
                ++n2;
            }
            this.setSelectedValue(dotdot, true);
            int k = 0;
            while (k < FILE_SYSTEM_ROOTS.length) {
                this.listModel.addElement(new FileBrowserObject(FILE_SYSTEM_ROOTS[k], true));
                ++k;
            }
            return true;
        }
        catch (Exception ex) {
            if (this.files == null) {
                this.files = new File[0];
            }
            if (this.directories == null) {
                this.directories = new File[0];
            }
            return false;
        }
    }

    public void backSpace() {
        File file = this._file;
        File file1 = this._file.getParentFile();
        if (file1 != null) {
            this.listFile(file1);
            this.setSelectedValue(new FileBrowserObject(file), true);
        }
    }

    public File getFile() {
        return this._file;
    }

    public String getPath() {
        String s = "";
        if (!Utilities.isFileSystemRoot(this._file)) {
            s = Utilities.DIR_SEPARATOR_STRING;
        }
        return String.valueOf(this._file.getAbsolutePath()) + s + this.getSelectedName();
    }

    public String getSelectedName() {
        String s = "";
        int i = this.getSelectedIndex();
        if (i > 0) {
            if (i - 1 < this.directories.length) {
                s = this.directories[i - 1].getName();
            } else if (i - 1 < this.directories.length + this.files.length) {
                s = this.files[i - this.directories.length - 1].getName();
            }
        }
        return s;
    }

    private void action() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex >= 0) {
            if (selectedIndex == 0) {
                this.backSpace();
            } else if (selectedIndex <= this.directories.length) {
                File file = new File(this._file, this.directories[selectedIndex - 1].getName());
                File file1 = this._file;
                if (file.exists() && !this.listFile(file)) {
                    this.listFile(file1);
                    this.browser.setStatus(FileBrowserBundle.getString("FileList.action.error", file.getAbsolutePath()));
                }
            } else if (selectedIndex <= this.directories.length + this.files.length) {
                this.browser.openFile();
            } else {
                this.driveChanged();
            }
        }
    }

    private void driveChanged() {
        File file = this._file.getAbsoluteFile();
        int selectedIndex = this.getSelectedIndex();
        File file1 = this._file;
        File file2 = this._file.getParentFile();
        while (file2 != null) {
            file1 = file2;
            file2 = file2.getParentFile();
        }
        int j = 0;
        while (j < _fileSystemRoots.length) {
            if (FILE_SYSTEM_ROOTS[j].equals(file1)) {
                FileList._fileSystemRoots[j] = this._file.getAbsoluteFile();
                j = _fileSystemRoots.length;
            }
            ++j;
        }
        int k = selectedIndex - 1 - (this.directories.length + this.files.length);
        if (!this.listFile(_fileSystemRoots[k])) {
            this._file = file;
            if (!this.listFile(FILE_SYSTEM_ROOTS[k])) {
                this.listFile(file);
                this.setSelectedValue(this.listModel.getElementAt(selectedIndex), true);
                this.browser.setStatus(FileBrowserBundle.getString("FileList.driveChanged.error", FILE_SYSTEM_ROOTS[k]));
            }
        }
    }
}

