/*
 * Decompiled with CFR 0.152.
 */
package jnpad.config;

import java.awt.event.KeyEvent;
import jnpad.util.Platform;

public class KeyEventWorkaround {
    public static final boolean ALT_KEY_PRESSED_DISABLED = Platform.isMac;
    public static final boolean ALTERNATIVE_DISPATCHER = Platform.isMac;
    private static int last;
    private static final int LAST_NOTHING = 0;
    private static final int LAST_NUMKEYPAD = 1;
    private static final int LAST_ALT = 2;

    public static boolean isPrintable(int keyCode) {
        switch (keyCode) {
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 160: 
            case 161: 
            case 162: 
            case 192: 
            case 222: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMacControl(KeyEvent evt) {
        return Platform.isMac && (evt.getModifiers() & 2) != 0 && evt.getKeyChar() <= '+';
    }

    public static boolean isNumericKeypad(int keyCode) {
        switch (keyCode) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: {
                return true;
            }
        }
        return false;
    }

    public static KeyEvent processKeyEvent(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        char ch = evt.getKeyChar();
        int modifiers = evt.getModifiers();
        block0 : switch (evt.getID()) {
            case 401: {
                switch (keyCode) {
                    case 0: {
                        return null;
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 157: 
                    case 65406: {
                        break block0;
                    }
                }
                if (!evt.isMetaDown() && !evt.isControlDown() && !evt.isAltDown() && KeyEventWorkaround.isPrintable(keyCode)) {
                    return null;
                }
                if (ALT_KEY_PRESSED_DISABLED && (modifiers & 8) != 0) {
                    return null;
                }
                if (KeyEventWorkaround.isNumericKeypad(keyCode)) {
                    last = 1;
                    break;
                }
                last = 0;
                break;
            }
            case 400: {
                if (!(KeyEventWorkaround.isMacControl(evt) || ch >= ' ' && ch != '\u007f' && ch != '\u00ff' || ch == '\b' || ch == '\t' || ch == '\n')) {
                    return null;
                }
                if (!ALTERNATIVE_DISPATCHER && ((modifiers & 2) != 0 ^ (modifiers & 8) != 0 || (modifiers & 4) != 0)) {
                    return null;
                }
                if (last == 1) {
                    last = 0;
                    if ((ch < '0' || ch > '9') && ch != '.' && ch != '/' && ch != '*' && ch != '-' && ch != '+') break;
                    return null;
                }
                if (last != 2) break;
                last = 0;
                switch (ch) {
                    case '!': 
                    case ',': 
                    case '?': 
                    case 'B': 
                    case 'M': 
                    case 'X': 
                    case 'c': {
                        return null;
                    }
                }
                break;
            }
            case 402: {
                switch (keyCode) {
                    case 18: {
                        evt.consume();
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 157: 
                    case 65406: {
                        break;
                    }
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        if (modifiers != 8) break;
                        last = 2;
                    }
                }
                break;
            }
        }
        return evt;
    }
}

