/*
 * Decompiled with CFR 0.152.
 */
package jnpad.config;

import java.awt.Font;
import java.util.StringTokenizer;
import jnpad.config.Config;
import jnpad.config.IntProp;
import jnpad.config.Prop;

public class FontProp
extends Prop<Font> {
    private static final long serialVersionUID = 4550275088818908648L;

    public FontProp(String name, Font def) {
        super(name, def);
    }

    @Override
    public String getDefaultString() {
        return FontProp.format((Font)this.defaultValue);
    }

    public static Font parse(String value) throws IllegalArgumentException {
        int style;
        int size;
        String name;
        try {
            StringTokenizer st = new StringTokenizer(value, ",");
            name = st.nextToken().trim();
            String s_style = st.nextToken().trim();
            size = IntProp.parse(st.nextToken().trim());
            style = s_style.equalsIgnoreCase("Font.BOLD") ? 1 : (s_style.equalsIgnoreCase("Font.ITALIC") ? 2 : (s_style.equalsIgnoreCase("Font.BOLD|Font.ITALIC") || s_style.equalsIgnoreCase("Font.ITALIC|Font.BOLD") ? 3 : IntProp.parse(s_style)));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Fuente inv\u00ef\u00bf\u00bdlida: " + value);
        }
        return new Font(name, style, size);
    }

    public static String format(Font value) {
        StringBuilder sb = new StringBuilder();
        sb.append(value.getName()).append(",").append(value.getStyle()).append(",").append(value.getSize());
        return sb.toString();
    }

    @Override
    public Font getValue() {
        return Config.getFontProp(this);
    }

    @Override
    protected void doSetValue(Font value) {
        Config.setFontProp(this, value);
    }
}

