/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.Font;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Config;

public final class SelectFontSizeAction
extends JNPadAction {
    private GUIUtilities.FontSize fontSize;
    static final String NAME = "select-fontsize";
    private static Map<String, JNPadAction> map = new HashMap<String, JNPadAction>();
    private static final long serialVersionUID = -4771867648034883226L;

    public SelectFontSizeAction(JNPadFrame jNPad, GUIUtilities.FontSize fontSize) {
        super(jNPad, NAME, JNPadActions.Group.CONFIGURE);
        boolean selected;
        String name;
        String description;
        String actionLabel;
        this.fontSize = fontSize;
        int fsize1 = Config.TEXT_FONT.getValue().getSize();
        int fsize2 = ((Font)Config.TEXT_FONT.getDefault()).getSize();
        switch (fontSize) {
            case TINY: {
                actionLabel = ActionBundle.getString(NAME.concat(".tiny.label"), new Object[0]);
                description = ActionBundle.getString(NAME.concat(".tiny.description"), "tiny");
                name = "select-fontsize tiny";
                selected = fsize1 == fsize2 - 4;
                break;
            }
            case SMALL: {
                actionLabel = ActionBundle.getString(NAME.concat(".small.label"), new Object[0]);
                description = ActionBundle.getString(NAME.concat(".small.description"), "small");
                name = "select-fontsize small";
                selected = fsize1 == fsize2 - 2;
                break;
            }
            case LARGE: {
                actionLabel = ActionBundle.getString(NAME.concat(".large.label"), new Object[0]);
                description = ActionBundle.getString(NAME.concat(".large.description"), "large");
                name = "select-fontsize large";
                selected = fsize1 == fsize2 + 2;
                break;
            }
            case HUGE: {
                actionLabel = ActionBundle.getString(NAME.concat(".huge.label"), new Object[0]);
                description = ActionBundle.getString(NAME.concat(".huge.description"), "huge");
                name = "select-fontsize huge";
                selected = Config.isDefaultMode();
                selected = fsize1 == fsize2 + 4;
                break;
            }
            default: {
                actionLabel = ActionBundle.getString(NAME.concat(".normal.label"), new Object[0]);
                description = ActionBundle.getString(NAME.concat(".normal.description"), "normal");
                name = "select-fontsize normal";
                selected = fsize1 == fsize2;
            }
        }
        this.setName(name);
        this.setActionLabel(actionLabel);
        this.setDescription(description);
        this.setSelected(selected);
        this.setStateAction(true);
        map.put(name, this);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            Config.TEXT_FONT.setValue(GUIUtilities.getFont(this.fontSize, (Font)Config.TEXT_FONT.getDefault()));
            this.jNPad.configure(2);
        }
    }

    static List<String> getCompletionsForPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            JNPadAction action = map.get(key);
            if (!key.startsWith(prefix) || !action.isEnabled()) continue;
            list.add(key);
        }
        Collections.sort(list);
        return list;
    }

    static boolean performAction(String name) {
        JNPadAction action = map.get(name);
        if (action != null && action.isEnabled()) {
            action.setSelected(!action.isSelected());
            return true;
        }
        return false;
    }
}

