/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Config;
import jnpad.text.JNPadTextArea;

public final class SelectAutoCompletionFromNthAction
extends JNPadAction {
    private int nth;
    static final String NAME = "select-autocompletion-from-nth";
    private static Map<String, JNPadAction> map = new HashMap<String, JNPadAction>();
    private static final long serialVersionUID = -6303808091700393893L;

    public SelectAutoCompletionFromNthAction(JNPadFrame jNPad, int nth, boolean selected) {
        super(jNPad, NAME, JNPadActions.Group.CONFIGURE);
        this.nth = nth;
        String name = "select-autocompletion-from-nth " + nth;
        this.setName(name);
        this.setLabel(ActionBundle.getString(NAME.concat(".label"), nth));
        this.setMnemonic(String.valueOf(nth).charAt(0));
        this.setDescription(ActionBundle.getString(NAME.concat(".description"), nth));
        this.setSelected(selected);
        this.setStateAction(true);
        map.put(name, this);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            Config.TEXT_AUTOCOMPLETION_TRIGGER.setValue(this.nth);
            JNPadTextArea[] jNPadTextAreaArray = this.jNPad.getViewer().getGlobalTextAreas();
            int n = jNPadTextAreaArray.length;
            int n2 = 0;
            while (n2 < n) {
                JNPadTextArea etxarea = jNPadTextAreaArray[n2];
                etxarea.setAutoCompletionTrigger(this.nth);
                ++n2;
            }
        }
    }

    static List<String> getCompletionsForPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            JNPadAction action = map.get(key);
            if (!key.startsWith(prefix) || !action.isEnabled()) continue;
            list.add(key);
        }
        Collections.sort(list);
        return list;
    }

    static boolean performAction(String name) {
        JNPadAction action = map.get(name);
        if (action != null && action.isEnabled()) {
            action.setSelected(!action.isSelected());
            return true;
        }
        return false;
    }
}

