/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextArea;
import jnpad.ui.ReporterUtilities;
import jnpad.ui.status.StatusDisplayable;

public final class JoinLinesAction
extends JNPadAction
implements IEditAction {
    private static final Logger LOGGER = Logger.getLogger(JoinLinesAction.class.getName());
    private static final long serialVersionUID = -7779330402635811907L;

    public JoinLinesAction(JNPadFrame jNPad) {
        super(jNPad, "join-lines", JNPadActions.Group.EDIT, Accelerators.JOIN_LINES, null);
    }

    @Override
    public void performAction() {
        Buffer buffer = this.jNPad.getActiveBuffer();
        if (buffer != null) {
            try {
                boolean finalSpace;
                int len;
                String text;
                int start;
                buffer.beginCompoundEdit();
                JNPadTextArea textArea = buffer.getSelectedTextArea();
                Document doc = textArea.getDocument();
                if (textArea.hasSelection()) {
                    start = textArea.getSelectionStart();
                    text = textArea.getSelectedText();
                    len = textArea.getSelectionEnd() - start;
                    finalSpace = doc.getLength() != textArea.getSelectionEnd();
                } else {
                    start = 0;
                    text = textArea.getText();
                    len = doc.getLength();
                    finalSpace = false;
                }
                if (len > 5000) {
                    ReporterUtilities.reportInfo(this.jNPad, ActionBundle.getString("join-lines".concat(".tooBig"), new Object[0]), this.getLabel());
                    return;
                }
                try {
                    StringTokenizer st = new StringTokenizer(text, "\n");
                    doc.remove(start, len);
                    int offset = start;
                    while (st.hasMoreTokens()) {
                        String insert = st.nextToken().trim();
                        if (st.hasMoreTokens() || finalSpace) {
                            insert = String.valueOf(insert) + ' ';
                        }
                        doc.insertString(offset, insert, null);
                        offset += insert.length();
                    }
                    textArea.setCaretPosition(offset);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    this.jNPad.setStatus(StatusDisplayable.StatusType.ERROR, "Error - ".concat(this.getLabel()));
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
    }
}

