/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.Element;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextArea;
import jnpad.text.TextUtilities;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.Utilities;

public final class EndLinesAction
extends JNPadAction
implements IEditAction {
    private static final Logger LOGGER = Logger.getLogger(EndLinesAction.class.getName());
    private static final long serialVersionUID = 6092319355567550328L;

    public EndLinesAction(JNPadFrame jNPad) {
        super(jNPad, "end-lines-with", JNPadActions.Group.EDIT, Accelerators.END_LINES, null);
    }

    @Override
    public void performAction() {
        Buffer buffer = this.jNPad.getActiveBuffer();
        if (buffer != null) {
            String response = JOptionPane.showInputDialog(this.jNPad, ActionBundle.getString("end-lines-with".concat(".text"), new Object[0]), this.getLabel(), 3);
            if (Utilities.isEmptyString(response)) {
                return;
            }
            try {
                try {
                    buffer.beginCompoundEdit();
                    JNPadTextArea target = buffer.getSelectedTextArea();
                    Document doc = target.getDocument();
                    Element map = doc.getDefaultRootElement();
                    int firstLine = map.getElementIndex(target.getSelectionStart());
                    int lastLine = map.getElementIndex(target.getSelectionEnd());
                    int i = firstLine;
                    while (i <= lastLine) {
                        Element lineElement = map.getElement(i);
                        int start = lineElement.getStartOffset();
                        int end = lineElement.getEndOffset() - 1;
                        String text = String.valueOf(TextUtilities.getText(doc, start, end -= start)) + response;
                        doc.remove(start, end);
                        doc.insertString(start, text, null);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    this.jNPad.setStatus(StatusDisplayable.StatusType.ERROR, "Error - ".concat(this.getLabel()));
                    buffer.endCompoundEdit();
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
    }
}

