/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import jnpad.JNPadActionHelper;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.config.Config;
import jnpad.ui.JNPadCheckBoxMenuItem;
import jnpad.ui.JNPadMenuItem;
import jnpad.ui.layout.ModifiedFlowLayout;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.toolbar.JNPadToolBar;
import jnpad.ui.toolbar.PopupButton2;
import jnpad.ui.toolbar.PopupToolBoxButton;
import jnpad.ui.toolbar.ToolBarButton;
import jnpad.ui.toolbar.ToolBarToggleButton;

final class JNPadToolBarHelper {
    JToolBar toolBar;
    private boolean setToolbarsEnabled = true;
    private JNPadFrame jNPad;

    JNPadToolBarHelper(JNPadFrame jNPad) {
        this.jNPad = jNPad;
        if (Config.isDefaultMode()) {
            if (Config.TOOLBAR_ROWS.getValue().booleanValue()) {
                this.toolBar = new JToolBar();
                this.toolBar.setLayout(new ModifiedFlowLayout(3, 0, 0));
            } else {
                this.toolBar = new JNPadToolBar();
            }
        } else {
            this.toolBar = new JToolBar();
        }
        this.toolBar.setFloatable(false);
        if (Config.isDefaultMode() || Config.isBasicMode()) {
            this.toolBar.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JNPadToolBarHelper.this.showToolBarPopupMenu(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JNPadToolBarHelper.this.showToolBarPopupMenu(e);
                    }
                }
            });
        }
    }

    private void showToolBarPopupMenu(MouseEvent e) {
        JNPadActionHelper actions = this.jNPad.actions;
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JNPadCheckBoxMenuItem(actions.toolbarsFileAction));
        popupMenu.add(new JNPadCheckBoxMenuItem(actions.toolbarsEditRecantationAction));
        popupMenu.add(new JNPadCheckBoxMenuItem(actions.toolbarsEditClipboardAction));
        if (Config.isDefaultMode()) {
            popupMenu.add(new JNPadCheckBoxMenuItem(actions.toolbarsEditSelectionAction));
            popupMenu.add(new JNPadCheckBoxMenuItem(actions.toolbarsEditDeletionAction));
        }
        popupMenu.add(new JNPadCheckBoxMenuItem(actions.toolbarsSearchAction));
        if (Config.isDefaultMode()) {
            popupMenu.add(new JNPadCheckBoxMenuItem(actions.toolbarsViewAction));
            popupMenu.add(new JNPadCheckBoxMenuItem(actions.toolbarsFormatAction));
        }
        popupMenu.add(new JNPadCheckBoxMenuItem(actions.toolbarsWindowAction));
        popupMenu.addSeparator();
        popupMenu.add(new JNPadMenuItem(actions.toolbarsAllVisibleAction));
        popupMenu.add(new JNPadMenuItem(actions.toolbarsNoneVisibleAction));
        SwingUtilities.updateComponentTreeUI(popupMenu);
        popupMenu.pack();
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    void setToolBarVisible(boolean b) {
        this.toolBar.setVisible(b);
        JNPadAction.checkSelection(this.jNPad.actions.toolBarVisibleAction, b);
    }

    boolean isToolBarVisible() {
        return this.toolBar.isVisible();
    }

    void setToolBars() {
        if (!this.setToolbarsEnabled) {
            return;
        }
        switch (Config.getMode()) {
            case MINIMALIST: 
            case DISTRACTION_FREE: {
                return;
            }
            case BASIC: {
                this.setToolBars_basic();
                break;
            }
            default: {
                this.setToolBars_default();
            }
        }
    }

    private void setToolBars_basic() {
        JNPadActionHelper actions = this.jNPad.actions;
        Dimension d = null;
        if (LAFUtils.isJNPadLAF()) {
            d = new Dimension(8, 30);
        }
        this.toolBar.removeAll();
        if (Config.TOOLBARS_FILE_SELECTED.getValue().booleanValue()) {
            this.toolBar.add(new ToolBarButton(actions.newFileAction));
            this.toolBar.add(new ToolBarButton(actions.openFileAction));
            this.toolBar.add(new ToolBarButton(actions.closeFileAction));
            this.toolBar.add(new ToolBarButton(actions.saveFileAction));
            this.toolBar.add(new ToolBarButton(actions.saveAllFilesAction));
            this.addToolBarSeparator(d);
        }
        if (Config.TOOLBARS_EDIT_RECANTATION_SELECTED.getValue().booleanValue() || Config.TOOLBARS_EDIT_CLIPBOARD_SELECTED.getValue().booleanValue()) {
            if (Config.TOOLBARS_EDIT_RECANTATION_SELECTED.getValue().booleanValue()) {
                this.toolBar.add(new ToolBarButton(actions.undoAction));
                this.toolBar.add(new ToolBarButton(actions.redoAction));
            }
            if (Config.TOOLBARS_EDIT_CLIPBOARD_SELECTED.getValue().booleanValue()) {
                this.toolBar.add(new ToolBarButton(actions.copyAction));
                this.toolBar.add(new ToolBarButton(actions.cutAction));
                this.toolBar.add(new ToolBarButton(actions.pasteAction));
            }
            this.addToolBarSeparator(d);
        }
        if (Config.TOOLBARS_SEARCH_SELECTED.getValue().booleanValue()) {
            this.toolBar.add(new ToolBarButton(actions.findAction));
            this.toolBar.add(new ToolBarButton(actions.replaceAction));
            this.addToolBarSeparator(d);
        }
        if (Config.TOOLBARS_WINDOWS_SELECTED.getValue().booleanValue()) {
            this.toolBar.add(new ToolBarButton(actions.previousBufferAction));
            this.toolBar.add(new ToolBarButton(actions.nextBufferAction));
        }
        try {
            this.toolBar.doLayout();
            this.toolBar.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setToolBars_default() {
        JNPadActionHelper actions = this.jNPad.actions;
        Dimension d = null;
        if (LAFUtils.isJNPadLAF()) {
            d = new Dimension(8, 23);
        } else if (LAFUtils.isWindowsLAF() && Config.TOOLBAR_ROWS.getValue().booleanValue()) {
            d = new Dimension(8, 25);
        }
        this.toolBar.removeAll();
        if (Config.TOOLBARS_FILE_SELECTED.getValue().booleanValue()) {
            this.toolBar.add(new ToolBarButton(actions.newFileAction));
            this.toolBar.add(new ToolBarButton(actions.openFileAction));
            this.toolBar.add(this.jNPad.menus.btRecentFiles);
            this.toolBar.add(new ToolBarButton(actions.closeFileAction));
            this.toolBar.add(new ToolBarButton(actions.closeAllAction));
            this.toolBar.add(new ToolBarButton(actions.saveFileAction));
            this.toolBar.add(new ToolBarButton(actions.saveFileAsAction));
            this.toolBar.add(new ToolBarButton(actions.saveAllFilesAction));
            this.addToolBarSeparator(d);
        }
        if (Config.TOOLBARS_EDIT_RECANTATION_SELECTED.getValue().booleanValue() || Config.TOOLBARS_EDIT_CLIPBOARD_SELECTED.getValue().booleanValue() || Config.TOOLBARS_EDIT_SELECTION_SELECTED.getValue().booleanValue() || Config.TOOLBARS_EDIT_DELETION_SELECTED.getValue().booleanValue()) {
            if (Config.TOOLBARS_EDIT_RECANTATION_SELECTED.getValue().booleanValue()) {
                this.toolBar.add(new ToolBarButton(actions.undoAction));
                this.toolBar.add(new ToolBarButton(actions.redoAction));
            }
            if (Config.TOOLBARS_EDIT_CLIPBOARD_SELECTED.getValue().booleanValue()) {
                this.toolBar.add(new ToolBarButton(actions.copyAction));
                this.toolBar.add(new ToolBarButton(actions.cutAction));
                this.toolBar.add(new ToolBarButton(actions.pasteAction));
            }
            if (Config.TOOLBARS_EDIT_SELECTION_SELECTED.getValue().booleanValue()) {
                PopupButton2 btSelection = new PopupButton2();
                btSelection.setAction(actions.selectAllAction);
                btSelection.setDropDownToolTipText(JNPadBundle.getString("PopupButton.selection", new Object[0]));
                JPopupMenu pmSelection = new JPopupMenu();
                pmSelection.add(new JNPadMenuItem(actions.selectAllAction));
                pmSelection.addSeparator();
                pmSelection.add(new JNPadMenuItem(actions.selectParagraphAction));
                pmSelection.add(new JNPadMenuItem(actions.selectionBeginParagraphAction));
                pmSelection.add(new JNPadMenuItem(actions.selectionEndParagraphAction));
                pmSelection.addSeparator();
                pmSelection.add(new JNPadMenuItem(actions.selectLineAction));
                pmSelection.add(new JNPadMenuItem(actions.selectionBeginLineAction));
                pmSelection.add(new JNPadMenuItem(actions.selectionEndLineAction));
                pmSelection.addSeparator();
                pmSelection.add(new JNPadMenuItem(actions.selectWordAction));
                btSelection.setPopupMenu(pmSelection);
                this.toolBar.add(btSelection);
            }
            if (Config.TOOLBARS_EDIT_DELETION_SELECTED.getValue().booleanValue()) {
                PopupButton2 btDeletion = new PopupButton2();
                btDeletion.setAction(actions.deleteAction);
                btDeletion.setDropDownToolTipText(JNPadBundle.getString("PopupButton.deletion", new Object[0]));
                JPopupMenu pmDeletion = new JPopupMenu();
                pmDeletion.add(new JNPadMenuItem(actions.deleteAction));
                pmDeletion.addSeparator();
                pmDeletion.add(new JNPadMenuItem(actions.deleteParagraphAction));
                pmDeletion.add(new JNPadMenuItem(actions.deletionBeginParagraphAction));
                pmDeletion.add(new JNPadMenuItem(actions.deletionEndParagraphAction));
                pmDeletion.addSeparator();
                pmDeletion.add(new JNPadMenuItem(actions.deleteLineAction));
                pmDeletion.add(new JNPadMenuItem(actions.deletionBeginLineAction));
                pmDeletion.add(new JNPadMenuItem(actions.deletionEndLineAction));
                pmDeletion.addSeparator();
                pmDeletion.add(new JNPadMenuItem(actions.deleteWordAction));
                btDeletion.setPopupMenu(pmDeletion);
                this.toolBar.add(btDeletion);
            }
            this.addToolBarSeparator(d);
        }
        if (Config.TOOLBARS_SEARCH_SELECTED.getValue().booleanValue()) {
            this.toolBar.add(new ToolBarButton(actions.findAction));
            this.toolBar.add(new ToolBarButton(actions.replaceAction));
            this.toolBar.add(new ToolBarButton(actions.nextOccurrenceAction));
            this.toolBar.add(new ToolBarButton(actions.previousOccurrenceAction));
            this.toolBar.add(new ToolBarButton(actions.goToLineAction));
            this.addToolBarSeparator(d);
        }
        if (Config.TOOLBARS_VIEW_SELECTED.getValue().booleanValue()) {
            this.toolBar.add(new ToolBarToggleButton(actions.lineWrapAction));
            this.toolBar.add(new ToolBarToggleButton(actions.lineNumbersAction));
            this.toolBar.add(new ToolBarToggleButton(actions.activeLineAction));
            this.toolBar.add(new ToolBarToggleButton(actions.rightMarginLineAction));
            this.toolBar.add(new ToolBarToggleButton(actions.markOccurrencesAction));
            this.addToolBarSeparator(d);
        }
        if (Config.TOOLBARS_FORMAT_SELECTED.getValue().booleanValue()) {
            PopupToolBoxButton btCharCaseChange = new PopupToolBoxButton(1, 0);
            btCharCaseChange.setDefault(new ToolBarButton(actions.toUpperCaseAction));
            btCharCaseChange.add(btCharCaseChange.getDefault());
            btCharCaseChange.add(new ToolBarButton(actions.toLowerCaseAction));
            btCharCaseChange.add(new ToolBarButton(actions.invertUpperLowerAction));
            btCharCaseChange.add(new ToolBarButton(actions.capitalizeAction));
            btCharCaseChange.add(new ToolBarButton(actions.toTitleAction));
            btCharCaseChange.setDescription(JNPadBundle.getString("PopupButton.charCaseChange", new Object[0]));
            this.toolBar.add(btCharCaseChange);
            this.toolBar.add(new ToolBarToggleButton(actions.setReadOnlyAction));
            this.addToolBarSeparator(d);
        }
        if (Config.TOOLBARS_WINDOWS_SELECTED.getValue().booleanValue()) {
            this.toolBar.add(new ToolBarButton(actions.previousBufferAction));
            this.toolBar.add(new ToolBarButton(actions.nextBufferAction));
            this.toolBar.add(new ToolBarButton(actions.splitHorizontallyAction));
            this.toolBar.add(new ToolBarButton(actions.splitVerticallyAction));
            this.toolBar.add(new ToolBarButton(actions.unsplitCurrentAction));
            this.toolBar.add(new ToolBarButton(actions.unsplitAction));
        }
        try {
            this.toolBar.doLayout();
            this.toolBar.revalidate();
            this.toolBar.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addToolBarSeparator(Dimension d) {
        if (d != null) {
            this.toolBar.addSeparator(d);
        } else {
            this.toolBar.addSeparator();
        }
    }

    void viewToolBarsVisible(boolean b) {
        switch (Config.getMode()) {
            case MINIMALIST: 
            case DISTRACTION_FREE: {
                return;
            }
            case BASIC: {
                this.viewToolBarsVisible_basic(b);
                break;
            }
            default: {
                this.viewToolBarsVisible_default(b);
            }
        }
    }

    private void viewToolBarsVisible_default(boolean b) {
        JNPadActionHelper actions = this.jNPad.actions;
        this.setToolbarsEnabled = false;
        if (actions.toolbarsFileAction.isSelected() != b) {
            actions.toolbarsFileAction.setSelected(b);
        }
        if (actions.toolbarsEditRecantationAction.isSelected() != b) {
            actions.toolbarsEditRecantationAction.setSelected(b);
        }
        if (actions.toolbarsEditClipboardAction.isSelected() != b) {
            actions.toolbarsEditClipboardAction.setSelected(b);
        }
        if (actions.toolbarsEditSelectionAction.isSelected() != b) {
            actions.toolbarsEditSelectionAction.setSelected(b);
        }
        if (actions.toolbarsEditDeletionAction.isSelected() != b) {
            actions.toolbarsEditDeletionAction.setSelected(b);
        }
        if (actions.toolbarsSearchAction.isSelected() != b) {
            actions.toolbarsSearchAction.setSelected(b);
        }
        if (actions.toolbarsViewAction.isSelected() != b) {
            actions.toolbarsViewAction.setSelected(b);
        }
        if (actions.toolbarsFormatAction.isSelected() != b) {
            actions.toolbarsFormatAction.setSelected(b);
        }
        if (actions.toolbarsWindowAction.isSelected() != b) {
            actions.toolbarsWindowAction.setSelected(b);
        }
        this.setToolbarsEnabled = true;
        this.setToolBars();
    }

    private void viewToolBarsVisible_basic(boolean b) {
        JNPadActionHelper actions = this.jNPad.actions;
        this.setToolbarsEnabled = false;
        if (actions.toolbarsFileAction.isSelected() != b) {
            actions.toolbarsFileAction.setSelected(b);
        }
        if (actions.toolbarsEditRecantationAction.isSelected() != b) {
            actions.toolbarsEditRecantationAction.setSelected(b);
        }
        if (actions.toolbarsEditClipboardAction.isSelected() != b) {
            actions.toolbarsEditClipboardAction.setSelected(b);
        }
        if (actions.toolbarsSearchAction.isSelected() != b) {
            actions.toolbarsSearchAction.setSelected(b);
        }
        if (actions.toolbarsWindowAction.isSelected() != b) {
            actions.toolbarsWindowAction.setSelected(b);
        }
        this.setToolbarsEnabled = true;
        this.setToolBars();
    }
}

