/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jnpad.config.Config;

public final class JNPadBundle {
    private static final String BUNDLE_NAME = "jnpad.i18n.JNPadBundle";
    private static Reference<ResourceBundle> ourBundle;

    public static String getString(String key, Object ... params) {
        return JNPadBundle.getString(JNPadBundle.getBundle(), key, params);
    }

    public static String getString(ResourceBundle bundle, String key, Object ... params) {
        return JNPadBundle.getMessage(bundle, key, null, params);
    }

    public static String getMessage(String key, String defaultValue, Object ... params) {
        return JNPadBundle.getMessage(JNPadBundle.getBundle(), key, defaultValue, params);
    }

    public static String getMessage(ResourceBundle bundle, String key, String defaultValue, Object ... params) {
        String value;
        if (bundle == null) {
            return defaultValue;
        }
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            value = defaultValue != null ? defaultValue : String.valueOf('!') + key + '!';
        }
        if (params != null && params.length > 0 && value.indexOf(123) >= 0) {
            return MessageFormat.format(value, params);
        }
        return value;
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = null;
        if (ourBundle != null) {
            bundle = ourBundle.get();
        }
        if (bundle == null) {
            Locale locale = Config.getLocale();
            bundle = locale != null ? ResourceBundle.getBundle(BUNDLE_NAME, locale) : ResourceBundle.getBundle(BUNDLE_NAME);
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    public static String getCancelButtonText() {
        return JNPadBundle.getString("button.cancel", new Object[0]);
    }

    public static String getOkButtonText() {
        return JNPadBundle.getString("button.ok", new Object[0]);
    }

    public static String getActivateButtonText() {
        return JNPadBundle.getString("button.activate", new Object[0]);
    }

    public static String getSortButtonText() {
        return JNPadBundle.getString("button.sort", new Object[0]);
    }

    public static String getMoveButtonText() {
        return JNPadBundle.getString("button.move", new Object[0]);
    }

    public static String getCloseButtonText() {
        return JNPadBundle.getString("button.close", new Object[0]);
    }

    public static String getSaveButtonText() {
        return JNPadBundle.getString("button.save", new Object[0]);
    }

    public static String getAllButtonText() {
        return JNPadBundle.getString("button.all", new Object[0]);
    }

    public static String getNoneButtonText() {
        return JNPadBundle.getString("button.none", new Object[0]);
    }

    public static String getErrorTitle() {
        return JNPadBundle.getString("title.error", new Object[0]);
    }

    public static String getWarningTitle() {
        return JNPadBundle.getString("title.warning", new Object[0]);
    }

    public static String getInformationTitle() {
        return JNPadBundle.getString("title.information", new Object[0]);
    }

    public static String getOkOptionText() {
        return JNPadBundle.getString("option.ok", new Object[0]);
    }

    public static String getDetailsOptionText() {
        return JNPadBundle.getString("option.details", new Object[0]);
    }

    public static String getYesOptionText() {
        return JNPadBundle.getString("option.yes", new Object[0]);
    }

    public static String getNoOptionText() {
        return JNPadBundle.getString("option.no", new Object[0]);
    }

    public static String getCancelOptionText() {
        return JNPadBundle.getString("option.cancel", new Object[0]);
    }
}

