/*
 * Decompiled with CFR 0.152.
 */
package jnpad.util;

import jnpad.util.Platform;
import jnpad.util.Utilities;

public enum LineSeparator {
    DOS("DOS", "Windows/DOS (CR+LF)", "\r\n"),
    UNIX("UNIX", "Unix (LF)", "\n"),
    MAC("MAC", "Mac (CR)", "\r");

    private final String name;
    private final String longName;
    private final String lineSeparator;

    private LineSeparator(String name, String longName, String lineSeparator) {
        this.name = name;
        this.longName = longName;
        this.lineSeparator = lineSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getName() {
        return this.name;
    }

    public String getLongName() {
        return this.longName;
    }

    public String toString() {
        return this.name;
    }

    public static LineSeparator getDefault() {
        String lineSeparator = Utilities.LINE_SEPARATOR;
        if (lineSeparator.equals("\r\n")) {
            return DOS;
        }
        if (lineSeparator.equals("\r")) {
            return MAC;
        }
        if (lineSeparator.equals("\n")) {
            return UNIX;
        }
        if (Platform.isWindows) {
            return DOS;
        }
        if (Platform.isMac) {
            return MAC;
        }
        return UNIX;
    }
}

