/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import jnpad.ui.toolbar.ToolBarButton;
import jnpad.util.Utilities;

class ToolBoxButton
extends ToolBarButton {
    JButton _reference;
    Action _action;
    private PropertyChangeListener _actionPropertyChangeListener;
    private static final long serialVersionUID = -4210047031620478770L;

    ToolBoxButton(JButton reference) {
        String desc;
        String tooltip;
        String text;
        this._reference = reference;
        Icon icon = reference.getIcon();
        if (icon != null) {
            this.setIcon(icon);
        }
        if ((text = reference.getText()) != null) {
            this.setText(text);
        }
        if (Utilities.isEmptyString(tooltip = reference.getToolTipText())) {
            tooltip = reference.getText();
        }
        this.setToolTipText(tooltip);
        if (reference instanceof ToolBarButton && (desc = ((ToolBarButton)reference).getDescription()) != null) {
            this.setDescription(desc);
        }
        this.setEnabled(reference.isEnabled());
        this.setMargin(reference.getMargin());
        this.addActionListener(new ActionListenerImpl());
        if (this._action != null && this._actionPropertyChangeListener != null) {
            this._action.removePropertyChangeListener(this._actionPropertyChangeListener);
            this._actionPropertyChangeListener = null;
        }
        this._action = reference.getAction();
        if (this._action != null) {
            this._actionPropertyChangeListener = new PropertyChangeListenerImpl();
            this._action.addPropertyChangeListener(this._actionPropertyChangeListener);
        }
    }

    private class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionListener[] actionListenerArray = ToolBoxButton.this._reference.getActionListeners();
            int n = actionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener listener = actionListenerArray[n2];
                listener.actionPerformed(new ActionEvent(ToolBoxButton.this._reference, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
                ++n2;
            }
        }
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = -276468994510092616L;

        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("enabled".equals(e.getPropertyName())) {
                ToolBoxButton.this.setEnabled((Boolean)e.getNewValue());
            }
        }
    }
}

