/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.plaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jnpad.config.Config;
import jnpad.ui.Gray;
import jnpad.ui.plaf.JNPadDarkMetalTheme;
import jnpad.ui.plaf.JNPadLightMetalTheme;
import jnpad.ui.plaf.OceanTheme2;
import jnpad.util.Platform;

public final class LAFUtils {
    public static final Color BLACK = new Gray(51);
    private static final Color SECONDARY1 = new Color(122, 138, 153);
    private static final Color SECONDARY2 = new Color(184, 207, 229);
    private static final Color SECONDARY3;
    public static final Color BACKGROUND;
    public static final Color SELECTION_BACKGROUND;
    public static final Color DISABLED_TEXT_COLOR;
    public static final Font PLAIN_FONT;
    public static final Font BOLD_FONT;
    public static final String METAL_LAF_CLASS_NAME = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String MOTIF_LAF_CLASS_NAME = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String GTK_LAF_CLASS_NAME = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final String MAC_LAF_CLASS_NAME = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    public static final String NIMBUS_LAF_CLASS_NAME = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
    public static final String WINDOWS_LAF_CLASS_NAME = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String WINDOWS_CLASSIC_LAF_CLASS_NAME = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
    public static final String AQUA_LAF_CLASS_NAME = "apple.laf.AquaLookAndFeel";
    public static final String AQUA_LAF_CLASS_NAME_6 = "com.apple.laf.AquaLookAndFeel";
    public static final String LAF_KEY_JNPAD_LIGHT = "jNPad_light";
    public static final String LAF_KEY_JNPAD_DARK = "jNPad_dark";
    public static final String LAF_KEY_OCEAN2 = "Ocean2";
    public static final String LAF_KEY_STEEL = "Steel";
    public static final String LAF_KEY_NATIVE = "System";
    public static final String LAF_KEY_JAVA = "CrossPlatform";
    private static String _lafKey;

    static {
        BACKGROUND = SECONDARY3 = new Gray(238);
        SELECTION_BACKGROUND = SECONDARY2;
        DISABLED_TEXT_COLOR = new Gray(153);
        PLAIN_FONT = new Font("Dialog", 0, 12);
        BOLD_FONT = new Font("Dialog", 1, 12);
        _lafKey = LAF_KEY_JAVA;
    }

    private LAFUtils() {
    }

    public static void setLookAndFeel(String lafKey) throws Exception {
        if (LAF_KEY_JNPAD_LIGHT.equals(lafKey)) {
            MetalLookAndFeel.setCurrentTheme(new JNPadLightMetalTheme());
            UIManager.setLookAndFeel(METAL_LAF_CLASS_NAME);
        } else if (LAF_KEY_JNPAD_DARK.equals(lafKey)) {
            MetalLookAndFeel.setCurrentTheme(new JNPadDarkMetalTheme());
            UIManager.setLookAndFeel(METAL_LAF_CLASS_NAME);
        } else if (LAF_KEY_STEEL.equals(lafKey)) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            UIManager.setLookAndFeel(METAL_LAF_CLASS_NAME);
        } else if (LAF_KEY_OCEAN2.equals(lafKey)) {
            MetalLookAndFeel.setCurrentTheme(new OceanTheme2());
            UIManager.setLookAndFeel(METAL_LAF_CLASS_NAME);
        } else if (LAF_KEY_NATIVE.equals(lafKey)) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } else if (LAF_KEY_JAVA.equals(lafKey)) {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        } else {
            if (METAL_LAF_CLASS_NAME.equals(lafKey)) {
                boolean boldMetal = Config.JNPAD_LAF_BOLD_METAL.getValue();
                UIManager.put("swing.boldMetal", boldMetal);
            }
            UIManager.setLookAndFeel(lafKey);
        }
        _lafKey = lafKey;
    }

    public static String getCurrentLAFKey() {
        return _lafKey;
    }

    public static boolean isJNPadLAF() {
        return LAF_KEY_JNPAD_LIGHT.equals(_lafKey) || LAF_KEY_JNPAD_DARK.equals(_lafKey);
    }

    public static boolean isDarkLAF() {
        return UIManager.getBoolean("jnpad.dark.theme");
    }

    public static boolean isMetalLAF() {
        return "Metal".equals(UIManager.getLookAndFeel().getID());
    }

    public static boolean isGTKLAF() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    public static boolean isMotifLAF() {
        return "Motif".equals(UIManager.getLookAndFeel().getID());
    }

    public static boolean isNimbusLAF() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getID());
    }

    public static boolean isWindowsLAF() {
        return "Windows".equals(UIManager.getLookAndFeel().getID());
    }

    public static boolean isWinLafOnVista() {
        return LAFUtils.isWindowsLAF() && Platform.isWinVistaOrNewer;
    }

    public static boolean isWindowsXPLAF() {
        return LAFUtils.isWindowsLAF() && LAFUtils.isXPTheme();
    }

    public static boolean isXPTheme() {
        Boolean isXP = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return isXP != null && isXP != false;
    }

    public static boolean isUnderAquaLookAndFeel() {
        return Platform.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    public static boolean isUnderNativeMacLookAndFeel() {
        return LAFUtils.isUnderAquaLookAndFeel();
    }

    public static boolean isUnderGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static boolean isFullRowSelectionLAF() {
        return LAFUtils.isNimbusLAF() || LAFUtils.isUnderGTKLookAndFeel();
    }

    public static void setDefaultLookAndFeelDecorated(boolean b) {
        JDialog.setDefaultLookAndFeelDecorated(b);
        JFrame.setDefaultLookAndFeelDecorated(b);
        Toolkit.getDefaultToolkit().setDynamicLayout(b);
        if (b) {
            System.setProperty("sun.awt.noerasebackground", "true");
        } else {
            System.setProperty("sun.awt.noerasebackground", "false");
        }
    }

    public static Color getSeparatorShadow() {
        Color c = UIManager.getColor("Separator.shadow");
        if (c == null) {
            c = SystemColor.controlShadow;
        }
        return c;
    }

    public static Color getSeparatorHighlight() {
        Color c = UIManager.getColor("Separator.highlight");
        if (c == null) {
            c = SystemColor.controlHighlight;
        }
        return c;
    }

    public static Color getTableHeaderBackground() {
        Color c = UIManager.getColor("TableHeader.background");
        if (c == null) {
            c = BACKGROUND;
        }
        return c;
    }

    public static Color getTableHeaderForeground() {
        Color c = UIManager.getColor("TableHeader.foreground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Font getTableHeaderFont() {
        Font f = UIManager.getFont("TableHeader.font");
        if (f == null) {
            f = PLAIN_FONT;
        }
        return f;
    }

    public static Border getTableHeaderCellBorder() {
        return UIManager.getBorder("TableHeader.cellBorder");
    }

    public static Color getTextAreaBackground() {
        Color c = UIManager.getColor("TextArea.background");
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    public static Color getTextAreaForeground() {
        Color c = UIManager.getColor("TextArea.foreground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Color getTextAreaSelectionBackground() {
        Color c = UIManager.getColor("TextArea.selectionBackground");
        if (c == null) {
            c = SELECTION_BACKGROUND;
        }
        return c;
    }

    public static Color getTextAreaSelectionForeground() {
        Color c = UIManager.getColor("TextArea.selectionForeground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Color getListBackground() {
        Color c;
        Color color = c = LAFUtils.isGTKLAF() ? LAFUtils.getTreeTextBackground() : UIManager.getColor("List.background");
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    public static Color getListForeground() {
        Color c = UIManager.getColor("List.foreground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Font getListFont() {
        Font f = UIManager.getFont("List.font");
        if (f == null) {
            f = BOLD_FONT;
        }
        return f;
    }

    public static Color getListSelectionBackground() {
        Color c = UIManager.getColor("List.selectionBackground");
        if (c == null) {
            c = UIManager.getColor("List[Selected].textBackground");
        }
        if (c == null) {
            c = SELECTION_BACKGROUND;
        }
        return c;
    }

    public static Color getListSelectionForeground() {
        Color c = UIManager.getColor("List.selectionForeground");
        if (c == null) {
            c = UIManager.getColor("List[Selected].textForeground");
        }
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Border getListFocusCellHighlightBorder() {
        return UIManager.getBorder("List.focusCellHighlightBorder");
    }

    public static Color getTreeBackground() {
        Color c = UIManager.getColor("Tree.background");
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    public static Color getTreeForeground() {
        Color c = UIManager.getColor("Tree.foreground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Color getTreeSelectionBackground() {
        Color c = UIManager.getColor("Tree.selectionBackground");
        if (c == null) {
            c = SELECTION_BACKGROUND;
        }
        return c;
    }

    public static Color getTreeSelectionForeground() {
        Color c = UIManager.getColor("Tree.selectionForeground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Font getTreeFont() {
        Font f = UIManager.getFont("Tree.font");
        if (f == null) {
            f = PLAIN_FONT;
        }
        return f;
    }

    public static Color getTreeTextBackground() {
        Color c = UIManager.getColor("Tree.textBackground");
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    public static Color getTreeTextForeground() {
        Color c = UIManager.getColor("Tree.textForeground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Color getPanelBackground() {
        Color c = UIManager.getColor("Panel.background");
        if (c == null) {
            c = BACKGROUND;
        }
        return c;
    }

    public static Color getTextPaneBackground() {
        Color c = UIManager.getColor("TextPane.background");
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    public static Color getTextPaneForeground() {
        Color c = UIManager.getColor("TextPane.foreground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Color getControlDkShadow() {
        Color c = UIManager.getColor("controlDkShadow");
        if (c == null) {
            c = SECONDARY1;
        }
        return c;
    }

    public static Color getControlText() {
        Color c = UIManager.getColor("controlText");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Color getControlHighlight() {
        Color c = UIManager.getColor("controlHighlight");
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    public static Color getControlShadow() {
        Color c = UIManager.getColor("controlShadow");
        if (c == null) {
            c = SECONDARY2;
        }
        return c;
    }

    public static Color getControl() {
        Color c = UIManager.getColor("control");
        if (c == null) {
            c = BACKGROUND;
        }
        return c;
    }

    public static Color getControlLtHighlight() {
        Color c = UIManager.getColor("controlLtHighlight");
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    public static Color getToolBarShadow() {
        Color c = UIManager.getColor("ToolBar.shadow");
        if (c == null) {
            c = SECONDARY2;
        }
        return c;
    }

    public static Color getToolBarHighlight() {
        Color c = UIManager.getColor("ToolBar.highlight");
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    public static Color getLabelBackground() {
        Color c = UIManager.getColor("Label.background");
        if (c == null) {
            c = BACKGROUND;
        }
        return c;
    }

    public static Color getLabelForeground() {
        Color c = UIManager.getColor("Label.foreground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Font getLabelFont() {
        Font f = UIManager.getFont("Label.font");
        if (f == null) {
            f = BOLD_FONT;
        }
        return f;
    }

    public static Color getTextFieldInactiveForeground() {
        Color c = UIManager.getColor("TextField.inactiveForeground");
        if (c == null) {
            c = SECONDARY2;
        }
        return c;
    }

    public static Color getTextFieldInactiveBackground() {
        Color c = UIManager.getColor("TextField.inactiveBackground");
        if (c == null) {
            c = BACKGROUND;
        }
        return c;
    }

    public static Color getTextFieldForeground() {
        Color c = UIManager.getColor("TextField.foreground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Color getTextFieldBackground() {
        Color c = UIManager.getColor("TextField.background");
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    public static Font getTextFieldFont() {
        Font f = UIManager.getFont("TextField.font");
        if (f == null) {
            f = PLAIN_FONT;
        }
        return f;
    }

    public static Border getTextFieldBorder() {
        return UIManager.getBorder("TextField.border");
    }

    public static Font getProgressBarFont() {
        Font f = UIManager.getFont("ProgressBar.font");
        if (f == null) {
            f = BOLD_FONT;
        }
        return f;
    }

    public static Color getProgressBarBackground() {
        Color c = UIManager.getColor("ProgressBar.background");
        if (c == null) {
            c = BACKGROUND;
        }
        return c;
    }

    public static Color getButtonDisabledText() {
        Color c = UIManager.getColor("Button.disabledText");
        if (c == null) {
            c = DISABLED_TEXT_COLOR;
        }
        return c;
    }

    public static Color getButtonBackground() {
        Color c = UIManager.getColor("Button.background");
        if (c == null) {
            c = BACKGROUND;
        }
        return c;
    }

    public static Color getCheckBoxDisabledText() {
        Color c = UIManager.getColor("CheckBox.disabledText");
        if (c == null) {
            c = DISABLED_TEXT_COLOR;
        }
        return c;
    }

    public static Color getMenuBackground() {
        Color c = UIManager.getColor("Menu.background");
        if (c == null) {
            c = BACKGROUND;
        }
        return c;
    }

    public static Color getMenuForeground() {
        Color c = UIManager.getColor("Menu.foreground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Color getMenuSelectionBackground() {
        Color c;
        if (LAFUtils.isNimbusLAF()) {
            c = UIManager.getColor("Table[Enabled+Selected].textBackground");
            if (c == null) {
                c = UIManager.getColor("nimbusSelectionBackground");
            }
        } else {
            c = UIManager.getColor("Menu.selectionBackground");
        }
        if (c == null) {
            c = SELECTION_BACKGROUND;
        }
        return c;
    }

    public static Color getMenuSelectionForeground() {
        Color c;
        Color color = c = LAFUtils.isNimbusLAF() ? UIManager.getColor("Menu[Enabled+Selected].textForeground") : UIManager.getColor("Menu.selectionForeground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Color getTableSelectionBackground() {
        Color c;
        if (LAFUtils.isNimbusLAF()) {
            c = UIManager.getColor("Table[Enabled+Selected].textBackground");
            if (c == null) {
                c = UIManager.getColor("nimbusSelectionBackground");
            }
        } else {
            c = UIManager.getColor("Table.selectionBackground");
        }
        if (c == null) {
            c = SELECTION_BACKGROUND;
        }
        return c;
    }

    public static Color getTableSelectionForeground() {
        Color c;
        Color color = c = LAFUtils.isNimbusLAF() ? UIManager.getColor("Table[Enabled+Selected].textForeground") : UIManager.getColor("Table.selectionForeground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Color getTableBackground() {
        Color c;
        Color color = c = LAFUtils.isGTKLAF() ? LAFUtils.getTreeTextBackground() : UIManager.getColor("Table.background");
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    public static Color getTableForeground() {
        Color c = UIManager.getColor("Table.foreground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Font getTableFont() {
        Font f = UIManager.getFont("Table.font");
        if (f == null) {
            f = BOLD_FONT;
        }
        return f;
    }

    public static Color getTableFocusCellBackground() {
        Color c = UIManager.getColor("Table.focusCellBackground");
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    public static Color getTableFocusCellForeground() {
        Color c = UIManager.getColor("Table.focusCellForeground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Border getTableFocusCellHighlightBorder() {
        return UIManager.getBorder("Table.focusCellHighlightBorder");
    }

    public static Color getToolTipBackground() {
        Color c = UIManager.getColor("ToolTip.background");
        if (c == null) {
            c = SELECTION_BACKGROUND;
        }
        return c;
    }

    public static Color getToolTipForeground() {
        Color c = UIManager.getColor("ToolTip.foreground");
        if (c == null) {
            c = BLACK;
        }
        return c;
    }

    public static Border getToolTipBorder() {
        return UIManager.getBorder("ToolTip.border");
    }
}

