/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.icon;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jnpad.GUIUtilities;
import jnpad.ui.ColorUtilities;

public final class IconUtilities {
    private IconUtilities() {
    }

    public static ImageIcon getIcon(String picture, Class<?> source) throws FileNotFoundException {
        return GUIUtilities.getIcon(picture, source);
    }

    public static Image createImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage bim = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = bim.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return bim;
    }

    public static Icon getHorizontalNavigationIcon() {
        return new HArrow(8, 16, false, true, true, false, Color.BLACK);
    }

    public static Icon getVerticalNavigationIcon() {
        return new VArrow(16, 8, false, true, true, false, Color.BLACK);
    }

    public static FileIcon getTextFileIcon(int w) {
        FileIcon fi = new FileIcon(w, false);
        fi.isText = true;
        return fi;
    }

    public static FileIcon getDiffFileIcon(int w) {
        FileIcon fi = new FileIcon(w, false);
        fi.isText = true;
        fi.isDiffFile = true;
        return fi;
    }

    public static FileIcon getReadOnlyFileIcon(int w) {
        FileIcon fi = new FileIcon(w, false);
        fi.color = new Color(200, 20, 20, 180);
        return fi;
    }

    public static FileIcon getSystemFileIcon(int w, boolean isFolder) {
        FileIcon fi = new FileIcon(w, isFolder);
        fi.isSystem = true;
        return fi;
    }

    public static FileIcon getProjectFileIcon(int w, boolean isFolder) {
        FileIcon fi = new FileIcon(w, isFolder);
        fi.isProject = true;
        return fi;
    }

    public static FileIcon getResourceFileIcon(int w, boolean isFolder) {
        FileIcon fi = new FileIcon(w, isFolder);
        fi.isProject = true;
        fi.color = Color.yellow;
        return fi;
    }

    public static class EyeIcon
    extends Icons {
        boolean enabled;
        Color color;

        public EyeIcon(int w, int h, boolean enabled) {
            this(w, h, enabled, new Color(160, 180, 250));
        }

        public EyeIcon(int w, int h, boolean enabled, Color color) {
            super(w, h);
            this.enabled = enabled;
            this.color = color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        @Override
        public void doPaintIcon(Component c, Graphics2D g2) {
            Arc2D.Double disk = new Arc2D.Double(0.0, (double)this.w / 4.0, this.w, (double)this.w / 2.0, 0.0, 180.0, 0);
            Arc2D.Double disk2 = new Arc2D.Double(0.0, (double)this.w / 4.0, this.w, (double)this.w / 2.0, 180.0, 360.0, 0);
            Arc2D.Double disk3 = new Arc2D.Double((double)this.w / 2.0 - (double)this.w / 4.0, (double)this.w / 2.0 - (double)this.w / 8.0, (double)this.w / 4.0, (double)this.w / 4.0, 0.0, 360.0, 2);
            g2.setColor(this.enabled ? this.color : Color.lightGray);
            g2.fill(disk);
            g2.fill(disk2);
            g2.setColor(Color.black);
            g2.fill(disk3);
            g2.setStroke(new BasicStroke((float)this.h / 15.0f));
            g2.setColor(Color.black);
            g2.draw(disk);
            g2.draw(disk2);
        }
    }

    public static class FileIcon
    extends Icons {
        boolean enabled;
        String letter;
        boolean directory;
        boolean isText;
        boolean isDiffFile = false;
        Font letterFont;
        Color color = Color.white;
        boolean isSystem = false;
        boolean isProject = false;

        public FileIcon(int w, boolean directory) {
            this(w, w, directory, true, null);
        }

        public FileIcon(int w, int h, boolean directory, boolean enabled, String letter) {
            super(w, h);
            this.directory = directory;
            this.enabled = enabled;
            this.letter = letter;
            if (letter != null) {
                this.letterFont = new Font("Lucida Sans Typewriter", 0, w * 5 / 8);
            }
        }

        @Override
        public void doPaintIcon(Component c, Graphics2D g2) {
            GeneralPath poly = new GeneralPath();
            if (this.directory) {
                poly.moveTo((float)((double)this.w * 0.1), (float)((double)this.h * 0.16));
                poly.lineTo((float)((double)this.w * 0.45), (float)((double)this.h * 0.16));
                poly.lineTo((float)((double)this.w * 0.5), (float)((double)this.h * 0.04));
                poly.lineTo((float)((double)this.w * 0.88), (float)((double)this.h * 0.04));
                poly.lineTo(this.w - 1, (float)((double)this.h * 0.18));
                poly.lineTo(this.w - 1, (float)((double)this.h * 0.85));
                poly.lineTo((float)((double)this.w * 0.1), (float)((double)this.h * 0.85));
            } else {
                poly.moveTo((float)((double)this.w * 0.55), (float)((double)this.h * 0.1));
                poly.lineTo((float)((double)this.w * 0.55), (float)((double)this.h * 0.34));
                poly.lineTo((float)((double)this.w * 0.8), (float)((double)this.h * 0.34));
                poly.moveTo((float)((double)this.w * 0.15), (float)((double)this.h * 0.1));
                poly.lineTo((float)((double)this.w * 0.55), (float)((double)this.h * 0.1));
                poly.lineTo((float)((double)this.w * 0.8), (float)((double)this.h * 0.34));
                poly.lineTo((float)((double)this.w * 0.8), this.h);
                poly.lineTo((float)((double)this.w * 0.15), this.h);
            }
            poly.closePath();
            if (this.enabled) {
                if (this.isSystem) {
                    Color color1 = new Color(180, 180, 10);
                    Color color2 = new Color(220, 220, 10);
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, color1, this.w, this.w, color2, false));
                } else {
                    g2.setColor(this.color);
                }
                g2.fill(poly);
            }
            g2.setColor(Color.black);
            if (this.isProject) {
                g2.setColor(new Color(200, 20, 20, 120));
                if (this.directory) {
                    g2.fillRect(this.w - 5, this.w - 7, 5, 5);
                } else {
                    g2.fillRect(this.w - 8, this.w - 4, 5, 5);
                }
                g2.setColor(Color.black);
            }
            if (this.letter != null) {
                Font oldFont = g2.getFont();
                g2.setFont(this.letterFont);
                if (this.directory) {
                    g2.drawString(this.letter, this.w / 3 + 1, this.h * 6 / 8 + 1);
                } else {
                    g2.drawString(this.letter, this.w / 4, this.h * 7 / 8);
                }
                g2.setFont(oldFont);
            }
            g2.draw(poly);
            if (this.isText) {
                int i = 0;
                while (i < 3) {
                    if (this.isDiffFile) {
                        switch (i) {
                            case 0: {
                                g2.setColor(Color.BLACK);
                                break;
                            }
                            case 1: {
                                g2.setColor(Color.RED);
                                break;
                            }
                            case 2: {
                                g2.setColor(Color.GREEN);
                                break;
                            }
                        }
                    }
                    double hh = this.h / 3 + this.h / 8 + i * this.h / 6;
                    double d = i == 1 ? 2 : 0;
                    g2.drawLine(this.w / 2 - this.w / 5, (int)hh, (int)((double)(this.w / 2 + this.w / 7) - d), (int)hh);
                    ++i;
                }
            }
        }
    }

    public static class HArrow
    extends Icons {
        boolean enabled;
        Color color = Color.blue;
        boolean showLeft;
        boolean showRight;
        boolean withStopBar;

        public HArrow(int w, int h, boolean enabled) {
            this(w, h, false, true, enabled);
        }

        public HArrow(int w, int h, boolean showLeft, boolean showRight, boolean enabled) {
            this(w, h, showLeft, showRight, enabled, false, Color.blue);
        }

        public HArrow(int w, int h, boolean showLeft, boolean showRight, boolean enabled, boolean withStopBar, Color color) {
            super(w, h);
            this.showLeft = showLeft;
            this.showRight = showRight;
            this.enabled = enabled;
            this.withStopBar = withStopBar;
            this.color = color;
        }

        @Override
        protected void doPaintIcon(Component c, Graphics2D g2) {
            if (this.enabled) {
                g2.setColor(this.color);
                g2.setStroke(new BasicStroke((float)this.h / 15.0f));
            } else {
                g2.setColor(Color.gray);
            }
            g2.draw(new Line2D.Double((double)this.w / 8.0, (double)this.h / 2.0, (double)this.w - (double)this.w / 8.0, (double)this.h / 2.0));
            if (this.showRight) {
                g2.draw(new Line2D.Double((double)this.w - (double)this.w / 8.0, (double)this.h / 2.0, (double)(3 * this.w) / 4.0 - (double)this.w / 8.0, (double)this.h / 2.0 - (double)this.h / 5.0));
                g2.draw(new Line2D.Double((double)this.w - (double)this.w / 8.0, (double)this.h / 2.0, (double)(3 * this.w) / 4.0 - (double)this.w / 8.0, (double)this.h / 2.0 + (double)this.h / 5.0));
                if (this.withStopBar) {
                    g2.draw(new Line2D.Double((double)this.w - (double)this.w / 8.0, (double)this.h / 2.0 - (double)this.h / 3.0, (double)this.w - (double)this.w / 8.0, (double)this.h / 2.0 + (double)this.h / 3.0));
                }
            }
            if (this.showLeft) {
                g2.draw(new Line2D.Double((double)this.w / 8.0, (double)this.h / 2.0, (double)this.w / 4.0 + (double)this.w / 8.0, (double)this.h / 2.0 - (double)this.h / 5.0));
                g2.draw(new Line2D.Double((double)this.w / 8.0, (double)this.h / 2.0, (double)this.w / 4.0 + (double)this.w / 8.0, (double)this.h / 2.0 + (double)this.h / 5.0));
                if (this.withStopBar) {
                    g2.draw(new Line2D.Double((double)this.w / 8.0, (double)this.h / 2.0 - (double)this.h / 3.0, (double)this.w / 8.0, (double)this.h / 2.0 + (double)this.h / 3.0));
                }
            }
        }
    }

    public static abstract class Icons
    implements Icon {
        protected int w;
        protected int h;

        protected Icons(int w, int h) {
            this.w = w;
            this.h = h;
        }

        @Override
        public int getIconWidth() {
            return this.w;
        }

        @Override
        public int getIconHeight() {
            return this.h;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2D = (Graphics2D)g;
            Object oldRendering = g2D.getRenderingHint(RenderingHints.KEY_RENDERING);
            Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font oldFont = g2D.getFont();
            Stroke oldStroke = g2D.getStroke();
            Color oldColor = g2D.getColor();
            if (c != null) {
                g2D.setColor(c.getForeground());
            }
            g2D.translate(x, y);
            this.doPaintIcon(c, g2D);
            g2D.translate(-x, -y);
            g2D.setFont(oldFont);
            g2D.setStroke(oldStroke);
            g2D.setColor(oldColor);
            g2D.setRenderingHint(RenderingHints.KEY_RENDERING, oldRendering);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
        }

        protected abstract void doPaintIcon(Component var1, Graphics2D var2);
    }

    public static class LetterIcon
    extends Icons {
        boolean enabled;
        String letter;
        boolean border;
        Color letterColor;
        Font font = new Font("Lucida Sans Typewriter", 1, 12);

        public LetterIcon(String letter, boolean border, int w, int h, boolean enabled) {
            this(letter, border, w, h, enabled, Color.black);
        }

        public LetterIcon(String letter, boolean border, int w, int h, boolean enabled, Color letterColor) {
            super(w, h);
            this.enabled = enabled;
            this.letter = letter;
            this.border = border;
            this.letterColor = letterColor;
            this.font = this.font.canDisplayUpTo(letter) != -1 ? new Font("Lucida Sans Unicode", 1, h * 6 / 7) : new Font("Lucida Sans Typewriter", 1, h * 6 / 7);
        }

        @Override
        protected void doPaintIcon(Component c, Graphics2D g2) {
            g2.setColor(this.enabled ? this.letterColor : ColorUtilities.toGrayscale(this.letterColor));
            g2.setFont(this.font);
            g2.drawString(this.letter, this.w / 3, this.h - this.w / 5);
            if (this.border) {
                g2.setColor(Color.black);
                Rectangle2D.Double rect = new Rectangle2D.Double(1.0, 1.0, this.w - 2, this.h - 2);
                g2.draw(rect);
            }
        }
    }

    public static class MultilineIcon
    extends Icons {
        boolean enabled;
        Color color = Color.black;
        final float lineWidth;

        public MultilineIcon(int w, int h, float lineWidth, boolean enabled, Color color) {
            super(w, h);
            this.enabled = enabled;
            this.lineWidth = lineWidth;
            this.color = color;
        }

        @Override
        public void doPaintIcon(Component c, Graphics2D g2) {
            Line2D.Double line1 = new Line2D.Double((double)this.w / 8.0, (double)this.h / 2.0, (double)this.w - (double)this.w / 3.0, (double)this.h / 2.0);
            Line2D.Double line2 = new Line2D.Double((double)this.w / 8.0, (double)this.h / 2.0 - (double)this.h / 4.0, (double)this.w - (double)this.w / 8.0, (double)this.h / 2.0 - (double)this.h / 4.0);
            Line2D.Double line3 = new Line2D.Double((double)this.w / 8.0, (double)this.h / 2.0 + (double)this.h / 4.0, (double)this.w - (double)this.w / 8.0, (double)this.h / 2.0 + (double)this.h / 4.0);
            if (this.enabled) {
                g2.setColor(this.color);
                g2.setStroke(new BasicStroke(this.lineWidth));
                g2.draw(line1);
                g2.draw(line2);
                g2.draw(line3);
            } else {
                g2.setColor(Color.gray);
                g2.draw(line1);
                g2.draw(line2);
                g2.draw(line3);
            }
        }
    }

    public static class VArrow
    extends Icons {
        boolean enabled;
        Color color = Color.blue;
        boolean showUp;
        boolean showDown;
        boolean showRoot = true;
        boolean withStopBar;

        public VArrow(int w, int h, boolean enabled) {
            this(w, h, true, false, enabled);
        }

        public VArrow(int w, int h, boolean showUp, boolean showDown, boolean enabled) {
            this(w, h, showUp, showDown, enabled, false, Color.blue);
        }

        public VArrow(int w, int h, boolean showUp, boolean showDown, boolean enabled, boolean withStopBar, Color color) {
            super(w, h);
            this.enabled = enabled;
            this.showUp = showUp;
            this.showDown = showDown;
            this.withStopBar = withStopBar;
            this.color = color;
        }

        @Override
        protected void doPaintIcon(Component c, Graphics2D g2) {
            if (this.enabled) {
                g2.setColor(this.color);
                g2.setStroke(new BasicStroke((float)this.h / 15.0f));
            } else {
                g2.setColor(Color.gray);
            }
            g2.draw(new Line2D.Double((double)this.w / 2.0, (double)this.h / 8.0, (double)this.w / 2.0, (double)this.h - (double)this.h / 8.0));
            if (this.showUp) {
                g2.draw(new Line2D.Double((double)this.w / 2.0, (double)this.h / 8.0, (double)this.w / 2.0 - (double)this.w / 5.0, (double)this.h / 4.0 + (double)this.h / 8.0));
                g2.draw(new Line2D.Double((double)this.w / 2.0, (double)this.h / 8.0, (double)this.w / 2.0 + (double)this.w / 5.0, (double)this.h / 4.0 + (double)this.h / 8.0));
                if (this.withStopBar) {
                    g2.draw(new Line2D.Double((double)this.w / 2.0 - (double)this.w / 3.0, (double)this.h / 8.0, (double)this.w / 2.0 + (double)this.w / 3.0, (double)this.h / 8.0));
                }
            }
            if (this.showDown) {
                g2.draw(new Line2D.Double((double)this.w / 2.0, (double)this.h - (double)this.h / 8.0, (double)this.w / 2.0 - (double)this.w / 5.0, (double)(3 * this.h) / 4.0 - (double)this.h / 8.0));
                g2.draw(new Line2D.Double((double)this.w / 2.0, (double)this.h - (double)this.h / 8.0, (double)this.w / 2.0 + (double)this.w / 5.0, (double)(3 * this.h) / 4.0 - (double)this.h / 8.0));
                if (this.withStopBar) {
                    g2.draw(new Line2D.Double((double)this.w / 2.0 - (double)this.w / 3.0, (double)this.h - (double)this.h / 8.0, (double)this.w / 2.0 + (double)this.w / 3.0, (double)this.h - (double)this.h / 8.0));
                }
            }
            if (this.showRoot) {
                if (!this.showUp) {
                    g2.draw(new Line2D.Double((double)this.w / 2.0, (double)this.h / 8.0, (double)this.w / 2.0 - (double)this.w / 5.0, (double)this.h / 8.0));
                }
                if (!this.showDown) {
                    g2.draw(new Line2D.Double((double)this.w / 2.0, (double)this.h - (double)this.h / 8.0, (double)this.w / 2.0 - (double)this.w / 5.0, (double)this.h - (double)this.h / 8.0));
                }
            }
        }
    }
}

