/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import jnpad.text.JNPadDocument;
import jnpad.text.syntax.CScheme;
import jnpad.text.syntax.SyntaxScheme;
import jnpad.text.syntax.SyntaxView;

public class CView
extends SyntaxView {
    CScheme scheme;

    public CView(Element elem, boolean mini) {
        super(elem, mini);
        this.scheme = !mini ? (CScheme)((JNPadDocument)this.getDocument()).getScheme() : (CScheme)((JNPadDocument)this.getDocument()).getMiniScheme();
    }

    @Override
    int doDrawUnselectedText(Graphics g, int x, int y, int start, int length) throws BadLocationException {
        Segment content = new Segment();
        this.getDocument().getText(start, length, content);
        boolean inComment = this.isParagraphInComment(start);
        int wordIndex = 0;
        while (wordIndex < content.length()) {
            Color color;
            Font savedFont;
            CScheme.WordType type;
            Font savedFont2;
            Segment text;
            char indexedChar = content.charAt(wordIndex);
            if (Character.isJavaIdentifierStart(indexedChar) && !inComment) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex);
                int scannedIdentifierLength = scannedIdentifier.length();
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                savedFont2 = g.getFont();
                type = this.scheme.getWordType(scannedIdentifier);
                g.setColor(this.scheme.getWordColor(type));
                g.setFont(this.scheme.getWordFont(type));
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (Character.isDigit(indexedChar) && !inComment) {
                String scannedNumericLiteral = this.scanNumericLiteral(content, wordIndex);
                int scannedNumericLiteralLength = scannedNumericLiteral.length();
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedNumericLiteralLength, text);
                g.setColor(this.scheme.getNumberColor());
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                wordIndex += scannedNumericLiteralLength;
                continue;
            }
            if (this.isStringDelimiter(indexedChar) && !inComment) {
                int scannedStringLength = this.scanStringLiteral(content, wordIndex);
                Segment text2 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedStringLength, text2);
                savedFont = g.getFont();
                g.setColor(this.scheme.getStringColor());
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text2, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedStringLength;
                continue;
            }
            if (this.isCharDelimiter(indexedChar) && !inComment) {
                int scannedCharLength = this.scanCharLiteral(content, wordIndex);
                Segment text3 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCharLength, text3);
                g.setColor(this.scheme.getStringColor());
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text3, x, y, g, (TabExpander)this, start + wordIndex);
                wordIndex += scannedCharLength;
                continue;
            }
            if (this.isDirectiveStart(content, wordIndex) && !inComment && wordIndex < content.length() - 1) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex + 1);
                int scannedIdentifierLength = scannedIdentifier.length() + 1;
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                savedFont2 = g.getFont();
                type = this.scheme.getWordType("#".concat(scannedIdentifier));
                g.setColor(this.scheme.getWordColor(type));
                g.setFont(this.scheme.getWordFont(type));
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (this.isSingleLineCommentStart(content, wordIndex) && !inComment) {
                int scannedCommentLength = this.scanSingleLineComment(content, wordIndex);
                Segment text4 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text4);
                savedFont = g.getFont();
                g.setColor(this.scheme.getCommentColor());
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text4, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isMultiLineCommentEnd(content, wordIndex) && inComment) {
                Segment text5 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 2, text5);
                Font savedFont3 = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                g.setColor(this.scheme.getCommentColor());
                x = Utilities.drawTabbedText(text5, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont3);
                inComment = false;
                wordIndex += 2;
                continue;
            }
            if (this.isMultiLineCommentStart(content, wordIndex)) {
                int scannedCommentLength = this.scanMultiLineComment(content, wordIndex);
                Segment text6 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text6);
                savedFont = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                g.setColor(this.scheme.getCommentColor());
                x = Utilities.drawTabbedText(text6, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                inComment = true;
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isBracket(indexedChar) && !inComment) {
                Segment text7 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text7);
                Font savedFont4 = g.getFont();
                g.setFont(this.scheme.getBracketFont());
                g.setColor(this.scheme.getBracketColor());
                x = Utilities.drawTabbedText(text7, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont4);
                ++wordIndex;
                continue;
            }
            if (this.isOperator(indexedChar) && !inComment) {
                Segment text8 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text8);
                Font savedFont5 = g.getFont();
                g.setFont(this.scheme.getOperatorFont());
                g.setColor(this.scheme.getOperatorColor());
                x = Utilities.drawTabbedText(text8, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont5);
                ++wordIndex;
                continue;
            }
            Font savedFont6 = g.getFont();
            if (inComment) {
                g.setFont(this.scheme.getCommentFont());
                color = this.scheme.getCommentColor();
            } else {
                color = this.scheme.getTextColor();
            }
            text = this.getLineBuffer();
            this.getDocument().getText(start + wordIndex, 1, text);
            g.setColor(color);
            x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
            g.setFont(savedFont6);
            ++wordIndex;
        }
        return x;
    }

    @Override
    int doDrawSelectedText(Graphics g, int x, int y, int start, int length) throws BadLocationException {
        Segment content = new Segment();
        this.getDocument().getText(start, length, content);
        boolean inComment = this.isParagraphInComment(start);
        g.setColor(this.scheme.getSelectedTextColor());
        int wordIndex = 0;
        while (wordIndex < content.length()) {
            Font savedFont;
            CScheme.WordType type;
            Font savedFont2;
            Segment text;
            char indexedChar = content.charAt(wordIndex);
            if (Character.isJavaIdentifierStart(indexedChar) && !inComment) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex);
                int scannedIdentifierLength = scannedIdentifier.length();
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                savedFont2 = g.getFont();
                type = this.scheme.getWordType(scannedIdentifier);
                g.setFont(this.scheme.getWordFont(type));
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (this.isStringDelimiter(indexedChar) && !inComment) {
                int scannedStringLength = this.scanStringLiteral(content, wordIndex);
                Segment text2 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedStringLength, text2);
                savedFont = g.getFont();
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text2, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedStringLength;
                continue;
            }
            if (this.isCharDelimiter(indexedChar) && !inComment) {
                int scannedCharLength = this.scanCharLiteral(content, wordIndex);
                Segment text3 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCharLength, text3);
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text3, x, y, g, (TabExpander)this, start + wordIndex);
                wordIndex += scannedCharLength;
                continue;
            }
            if (this.isDirectiveStart(content, wordIndex) && !inComment && wordIndex < content.length() - 1) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex + 1);
                int scannedIdentifierLength = scannedIdentifier.length() + 1;
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                savedFont2 = g.getFont();
                type = this.scheme.getWordType("#".concat(scannedIdentifier));
                g.setFont(this.scheme.getWordFont(type));
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (this.isSingleLineCommentStart(content, wordIndex) && !inComment) {
                int scannedCommentLength = this.scanSingleLineComment(content, wordIndex);
                Segment text4 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text4);
                savedFont = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text4, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isMultiLineCommentEnd(content, wordIndex) && inComment) {
                Segment text5 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 2, text5);
                Font savedFont3 = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text5, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont3);
                inComment = false;
                wordIndex += 2;
                continue;
            }
            if (this.isMultiLineCommentStart(content, wordIndex)) {
                int scannedCommentLength = this.scanMultiLineComment(content, wordIndex);
                Segment text6 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text6);
                savedFont = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text6, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                inComment = true;
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isBracket(indexedChar) && !inComment) {
                Segment text7 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text7);
                Font savedFont4 = g.getFont();
                g.setFont(this.scheme.getBracketFont());
                x = Utilities.drawTabbedText(text7, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont4);
                ++wordIndex;
                continue;
            }
            if (this.isOperator(indexedChar) && !inComment) {
                Segment text8 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text8);
                Font savedFont5 = g.getFont();
                g.setFont(this.scheme.getOperatorFont());
                x = Utilities.drawTabbedText(text8, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont5);
                ++wordIndex;
                continue;
            }
            Font savedFont6 = g.getFont();
            if (inComment) {
                g.setFont(this.scheme.getCommentFont());
            }
            Segment text9 = this.getLineBuffer();
            this.getDocument().getText(start + wordIndex, 1, text9);
            x = Utilities.drawTabbedText(text9, x, y, g, (TabExpander)this, start + wordIndex);
            g.setFont(savedFont6);
            ++wordIndex;
        }
        return x;
    }

    boolean isParagraphInComment(int startOffset) {
        Element root;
        Element previousElement;
        return startOffset > 0 && (previousElement = (root = this.getDocument().getDefaultRootElement()).getElement(root.getElementIndex(startOffset - 1))).getAttributes().containsAttribute(JNPadDocument.MULTILINE_COMMENT, JNPadDocument.MULTILINE_COMMENT);
    }

    @Override
    boolean isSingleLineCommentStart(Segment s, int index) {
        return s.charAt(index) == '/' && index + 1 < s.length() && s.charAt(index + 1) == '/';
    }

    boolean isDirectiveStart(Segment s, int index) {
        return s.charAt(index) == '#';
    }

    @Override
    boolean isMultiLineCommentStart(Segment s, int index) {
        return s.charAt(index) == '/' && index + 1 < s.length() && s.charAt(index + 1) == '*';
    }

    @Override
    boolean isMultiLineCommentEnd(Segment s, int index) {
        return s.charAt(index) == '*' && index + 1 < s.length() && s.charAt(index + 1) == '/';
    }

    @Override
    int scanMultiLineComment(Segment s, int index) {
        boolean starFound = false;
        int commentLength = 0;
        while (commentLength < s.length() - index) {
            char commentChar = s.charAt(index + commentLength);
            if (starFound && commentChar == '/') {
                ++commentLength;
                break;
            }
            starFound = false;
            if (commentChar == '\n') break;
            if (commentChar == '*') {
                starFound = true;
            }
            ++commentLength;
        }
        return commentLength;
    }

    @Override
    SyntaxScheme getScheme() {
        return this.scheme;
    }
}

