/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnpad.JNPad;
import jnpad.config.Config;
import jnpad.text.syntax.SyntaxScheme;
import jnpad.util.Utilities;

public class ASN1Scheme
extends SyntaxScheme {
    static Color externalColor;
    static Color boolValueColor;
    static Color asnNumberColor;
    static Color stringTypeColor;
    static Color tagModifierColor;
    static Color typeInfoColor;
    static Color popTypeColor;
    static Color popValueColor;
    static Color fieldOptionColor;
    Font externalFont;
    Font boolValueFont;
    Font asnNumberFont;
    Font stringTypeFont;
    Font tagModifierFont;
    Font typeInfoFont;
    Font popTypeFont;
    Font popValueFont;
    Font fieldOptionFont;
    static boolean classify;
    static boolean known;
    private static final char[] OPERATORS;
    static Map<String, WordType> m_specialWords;
    private static final Logger LOGGER;
    private static final long serialVersionUID = -4256830535183354642L;

    static {
        OPERATORS = new char[]{'=', ':'};
        m_specialWords = new HashMap<String, WordType>();
        LOGGER = Logger.getLogger(ASN1Scheme.class.getName());
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("ASN.1 Scheme - init.");
        }
        classify = Config.SYNTAX_CLASSIFY_ENABLED.getValue();
        known = Config.SYNTAX_KNOWN_ENABLED.getValue();
        BufferedReader in = null;
        try {
            try {
                String line;
                String dir = String.valueOf(JNPad.PROPS_DIR) + Utilities.DIR_SEPARATOR + "schemes";
                String file = String.valueOf(dir) + Utilities.DIR_SEPARATOR + "asn1.words";
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                while ((line = in.readLine()) != null && !line.equals(":KEYWORDS")) {
                }
                while ((line = in.readLine()) != null && !line.equals(":EXTERNAL")) {
                    ASN1Scheme.read(line, WordType.KEYWORD);
                }
                while ((line = in.readLine()) != null && !line.equals(":BOOL_VALUES")) {
                    ASN1Scheme.read(line, WordType.EXTERNAL);
                }
                while ((line = in.readLine()) != null && !line.equals(":NUMBERS")) {
                    ASN1Scheme.read(line, WordType.BOOL_VALUE);
                }
                while ((line = in.readLine()) != null && !line.equals(":TYPE_INFO")) {
                    ASN1Scheme.read(line, WordType.NUMBER);
                }
                while ((line = in.readLine()) != null && !line.equals(":TAG_MODIFIERS")) {
                    ASN1Scheme.read(line, WordType.TYPE_INFO);
                }
                while ((line = in.readLine()) != null && !line.equals(":STRING_TYPES")) {
                    ASN1Scheme.read(line, WordType.TAG_MODIFIER);
                }
                while ((line = in.readLine()) != null && !line.equals(":FIELD_OPTIONS")) {
                    ASN1Scheme.read(line, WordType.STRING_TYPE);
                }
                while ((line = in.readLine()) != null && !line.equals(":POP_TYPES")) {
                    ASN1Scheme.read(line, WordType.FIELD_OPTION);
                }
                if (known) {
                    while ((line = in.readLine()) != null && !line.equals(":POP_VALUES")) {
                        ASN1Scheme.read(line, WordType.POP_TYPE);
                    }
                    while ((line = in.readLine()) != null) {
                        ASN1Scheme.read(line, WordType.POP_VALUE);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex2) {
                    LOGGER.log(Level.WARNING, ex2.getMessage(), ex2);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    private static void read(String line, WordType type) {
        if (Utilities.isBlankString(line) || line.startsWith("::")) {
            return;
        }
        m_specialWords.put(line.trim(), type);
    }

    public ASN1Scheme(boolean mini) {
        super(mini);
        this.doUpdateColors();
        this.doUpdateFonts();
    }

    private void doUpdateColors() {
        classify = Config.SYNTAX_CLASSIFY_ENABLED.getValue();
        externalColor = Config.SYNTAX_KEYWORD2_COLOR.getValue();
        boolValueColor = Config.SYNTAX_KEYWORD3_COLOR.getValue();
        stringTypeColor = Config.SYNTAX_KEYWORD4_COLOR.getValue();
        asnNumberColor = Config.SYNTAX_KEYWORD5_COLOR.getValue();
        tagModifierColor = Config.SYNTAX_KEYWORD6_COLOR.getValue();
        typeInfoColor = Config.SYNTAX_KEYWORD9_COLOR.getValue();
        fieldOptionColor = Config.SYNTAX_KEYWORD7_COLOR.getValue();
        popTypeColor = Config.SYNTAX_KEYWORD8_COLOR.getValue();
        popValueColor = Config.SYNTAX_KEYWORD8_COLOR.getValue();
    }

    private void doUpdateFonts() {
        this.externalFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD2_STYLE.getValue());
        this.boolValueFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD3_STYLE.getValue());
        this.stringTypeFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD4_STYLE.getValue());
        this.asnNumberFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD5_STYLE.getValue());
        this.tagModifierFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD6_STYLE.getValue());
        this.typeInfoFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD9_STYLE.getValue());
        this.fieldOptionFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD7_STYLE.getValue());
        this.popTypeFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD8_STYLE.getValue());
        this.popValueFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD8_STYLE.getValue());
    }

    @Override
    public void setTextFont(Font f) {
        super.setTextFont(f);
        this.doUpdateFonts();
    }

    @Override
    public void configure(int cfg) {
        super.configure(cfg);
        if ((cfg & 1) != 0) {
            this.doUpdateColors();
        }
        if ((cfg & 2) != 0) {
            this.doUpdateFonts();
        }
    }

    public WordType getWordType(String word) {
        WordType type = m_specialWords.get(word);
        return type != null ? type : WordType.TEXT;
    }

    public Color getWordColor(WordType type) {
        if (type == null) {
            return this.textColor;
        }
        switch (type) {
            case KEYWORD: {
                return keywordColor;
            }
            case EXTERNAL: {
                return classify ? externalColor : keywordColor;
            }
            case BOOL_VALUE: {
                return classify ? boolValueColor : keywordColor;
            }
            case NUMBER: {
                return classify ? asnNumberColor : keywordColor;
            }
            case STRING_TYPE: {
                return classify ? stringTypeColor : keywordColor;
            }
            case TAG_MODIFIER: {
                return classify ? tagModifierColor : keywordColor;
            }
            case TYPE_INFO: {
                return classify ? typeInfoColor : keywordColor;
            }
            case FIELD_OPTION: {
                return classify ? fieldOptionColor : keywordColor;
            }
            case POP_TYPE: {
                return classify && known ? popTypeColor : this.textColor;
            }
            case POP_VALUE: {
                return classify && known ? popValueColor : this.textColor;
            }
        }
        return this.textColor;
    }

    public Font getWordFont(WordType type) {
        if (type == null) {
            return this.textFont;
        }
        switch (type) {
            case KEYWORD: {
                return this.keywordFont;
            }
            case EXTERNAL: {
                return classify ? this.externalFont : this.keywordFont;
            }
            case BOOL_VALUE: {
                return classify ? this.boolValueFont : this.keywordFont;
            }
            case NUMBER: {
                return classify ? this.asnNumberFont : this.keywordFont;
            }
            case STRING_TYPE: {
                return classify ? this.stringTypeFont : this.keywordFont;
            }
            case TAG_MODIFIER: {
                return classify ? this.tagModifierFont : this.keywordFont;
            }
            case TYPE_INFO: {
                return classify ? this.typeInfoFont : this.keywordFont;
            }
            case FIELD_OPTION: {
                return classify ? this.fieldOptionFont : this.keywordFont;
            }
            case POP_TYPE: {
                return classify && known ? this.popTypeFont : this.textFont;
            }
            case POP_VALUE: {
                return classify && known ? this.popValueFont : this.textFont;
            }
        }
        return this.textFont;
    }

    @Override
    public char[] getOperators() {
        return Utilities.copyOf(OPERATORS);
    }

    @Override
    public String getContentType() {
        return "text/asn1";
    }

    @Override
    public String[] getStartComment() {
        return new String[]{"--"};
    }

    @Override
    public String[] getEndComment() {
        return new String[]{"--", "\n"};
    }

    static enum WordType {
        KEYWORD,
        EXTERNAL,
        BOOL_VALUE,
        NUMBER,
        TYPE_INFO,
        TAG_MODIFIER,
        STRING_TYPE,
        FIELD_OPTION,
        POP_TYPE,
        POP_VALUE,
        TEXT;

    }
}

