/*
 * Decompiled with CFR 0.152.
 */
package jnpad.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.config.Config;
import jnpad.config.Configurable;
import jnpad.search.FindResultsTreeCellRenderer;
import jnpad.search.SearchBundle;
import jnpad.search.Text;
import jnpad.ui.JNPadTreeCellRenderer;
import jnpad.ui.TitledLabel;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.status.StatusDisplayable;

public class FindResultsPanel
extends JPanel
implements Configurable {
    JPopupMenu popupMenu = new JPopupMenu();
    JMenuItem miClear = new JMenuItem(SearchBundle.getString("FindResultsPanel.clear", new Object[0]));
    JMenuItem miClearAndClose = new JMenuItem(SearchBundle.getString("FindResultsPanel.clearAndClose", new Object[0]));
    JMenuItem miClose = new JMenuItem(SearchBundle.getString("FindResultsPanel.close", new Object[0]));
    TitledLabel titledLabel = new TitledLabel(2);
    JScrollPane scrollPane = new JScrollPane();
    JTree tree = new JTree(){
        private static final long serialVersionUID = 7675171551634139805L;

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            try {
                if (!FindResultsPanel.this.hasResults()) {
                    Font font = this.getFont();
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(this.getForeground());
                    g.setFont(font);
                    String s = SearchBundle.getString("FindResultsPanel.noResults", new Object[0]);
                    int j = this.getFontMetrics(font).stringWidth(s);
                    g.drawString(s, this.getWidth() / 2 - j / 2, this.getHeight() / 2 + this.getFont().getSize() / 2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    DefaultMutableTreeNode target;
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("root", true);
    DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
    private JNPadTreeCellRenderer tcr;
    private JNPadFrame jNPad;
    private static final Logger LOGGER = Logger.getLogger(FindResultsPanel.class.getName());
    private static final long serialVersionUID = -228723987349195871L;

    public FindResultsPanel(JNPadFrame jNPad) {
        super(new BorderLayout());
        try {
            this.jNPad = jNPad;
            this.jbInit();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            jNPad.setStatus(StatusDisplayable.StatusType.ERROR, ex.getMessage());
        }
    }

    private void jbInit() throws Exception {
        this.add((Component)this.titledLabel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.tree, null);
        this.titledLabel.setTitle(SearchBundle.getString("FindResultsPanel.titledLabel", new Object[0]));
        this.tree.setModel(this.treeModel);
        this.tree.setScrollsOnExpand(true);
        this.tree.setRootVisible(false);
        this.tree.expandPath(new TreePath(new Object[]{this.root}));
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tcr = new FindResultsTreeCellRenderer();
        this.tree.setCellRenderer(this.tcr);
        this.root.setAllowsChildren(true);
        if (Config.isDefaultMode()) {
            this.titledLabel.setIcon(GUIUtilities.loadIcon("find.png"));
            this.miClear.setIcon(GUIUtilities.loadIcon("clear.png"));
            this.miClearAndClose.setIcon(GUIUtilities.EMPTY_ICON);
            this.miClose.setIcon(GUIUtilities.EMPTY_ICON);
        }
        this.popupMenu.add(this.miClear);
        this.popupMenu.add(this.miClearAndClose);
        this.popupMenu.add(this.miClose);
        this.miClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindResultsPanel.this.clearResults();
            }
        });
        this.miClearAndClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindResultsPanel.this.clearResults();
                FindResultsPanel.this.jNPad.setFindResultsVisible(false);
            }
        });
        this.miClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindResultsPanel.this.jNPad.setFindResultsVisible(false);
            }
        });
        this.configure(1);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    FindResultsPanel.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 16 && e.getClickCount() == 1) {
                    FindResultsPanel.this.handleValueChanged(new TreeSelectionEvent((Object)FindResultsPanel.this.tree, FindResultsPanel.this.tree.getSelectionPath(), false, FindResultsPanel.this.tree.getSelectionPath(), FindResultsPanel.this.tree.getSelectionPath()));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getModifiers() == 16 && e.getClickCount() > 1) {
                    FindResultsPanel.this.textReloadFocus();
                } else if (e.isPopupTrigger()) {
                    FindResultsPanel.this.showPopupMenu(e);
                }
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FindResultsPanel.this.textReloadFocus();
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FindResultsPanel.this.handleValueChanged(e);
            }
        });
        this.titledLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                if ("closeComponent".equals(actionCommand)) {
                    FindResultsPanel.this.jNPad.setFindResultsVisible(false);
                }
            }
        });
    }

    private void showPopupMenu(MouseEvent e) {
        try {
            Point p = e.getPoint();
            TreePath treePath = this.tree.getPathForLocation((int)p.getX(), (int)p.getY());
            if (treePath == null) {
                this.miClear.setEnabled(this.hasResults());
                SwingUtilities.updateComponentTreeUI(this.popupMenu);
                this.popupMenu.pack();
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void handleValueChanged(TreeSelectionEvent e) {
        Object obj = this.tree.getLastSelectedPathComponent();
        if (obj instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)obj).getUserObject()) instanceof Text) {
            this.jNPad.selectSearchedText((Text)obj, this.tree);
        }
    }

    private void textReloadFocus() {
        Object obj = this.tree.getLastSelectedPathComponent();
        if ((obj = ((DefaultMutableTreeNode)obj).getUserObject()) != null && obj instanceof Text) {
            this.jNPad.getActiveBuffer().requestFocus();
        }
    }

    public boolean hasResults() {
        return this.root.getChildCount() > 0;
    }

    public void clearResults() {
        this.root.removeAllChildren();
        this.treeModel.reload();
    }

    public void reload() {
        this.treeModel.reload();
    }

    @Override
    public void configure(int cfg) {
        if ((cfg & 1) != 0) {
            this.titledLabel.setTitleFont(Config.TITLED_LABEL_FONT.getValue());
            this.titledLabel.setTitleColor(Config.TITLED_LABEL_FOREGROUND.getValue());
            this.titledLabel.setGradientColors(Config.TITLED_LABEL_GRADIENT1.getValue(), Config.TITLED_LABEL_GRADIENT2.getValue());
            this.titledLabel.setOrientation(Config.TITLED_LABEL_ORIENTATION.getValue());
            this.tree.setBackground(Config.TEXT_BACKGROUND.getValue());
            this.tree.setForeground(Config.TEXT_FOREGROUND.getValue());
            if (LAFUtils.isNimbusLAF()) {
                Color selectionBackground = Config.TEXT_SELECTION_BACKGROUND.getValue();
                UIDefaults overrides = new UIDefaults();
                overrides.put("Tree:TreeCell[Focused+Selected].backgroundPainter", selectionBackground);
                overrides.put("Tree:TreeCell[Enabled+Selected].backgroundPainter", selectionBackground);
                overrides.put("Tree:TreeCell[Enabled+Focused].backgroundPainter", selectionBackground);
                this.tree.putClientProperty("Nimbus.Overrides", overrides);
            }
        }
        this.tcr.configure(cfg);
    }

    public void addNewFound(String text, String path) {
        DefaultMutableTreeNode node = null;
        this.target = new DefaultMutableTreeNode(SearchBundle.getString("FindResultsPanel.result", text).concat(path), true);
        Enumeration<TreeNode> enumeration = this.root.children();
        boolean flag = false;
        while (!flag && enumeration.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumeration.nextElement();
            flag = node.toString().equals(this.target.toString());
        }
        if (flag) {
            this.root.remove(node);
        }
        this.root.add(this.target);
        this.target.setAllowsChildren(true);
        this.treeModel.reload();
    }

    public void addNewText(Text text) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(text, false);
        this.target.add(node);
        node.setAllowsChildren(false);
        this.treeModel.reload();
    }

    public void showFoundTarget() {
        TreeNode treeNode = null;
        if (this.target.getChildCount() > 0) {
            treeNode = this.target.getChildAt(0);
        }
        if (treeNode == null) {
            this.tree.setSelectionPath(new TreePath(new Object[]{this.root, this.target}));
        } else {
            this.tree.setSelectionPath(new TreePath(new Object[]{this.root, this.target, treeNode}));
        }
    }

    @Override
    public void requestFocus() {
        if (this.tree != null) {
            this.tree.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.tree != null) {
            return this.tree.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }
}

