/*
 * Decompiled with CFR 0.152.
 */
package jnpad.filebrowser;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jnpad.config.Config;
import jnpad.util.Utilities;

public class FileBrowserObject
implements Comparable<FileBrowserObject> {
    private static final String[] EXEC = new String[]{"cmd", "exe", "com", "btm", "bat", "sh", "csh"};
    private static final String[] COMP = new String[]{"tar", "tgz", "arj", "taz", "lzh", "lzma", "tlz", "txz", "zip", "z", "Z", "dz", "gz", "lz", "xz", "bz2", "bz", "tbz", "tbz2", "tz", "deb", "rpm", "jar", "war", "ear", "sar", "rar", "ace", "zoo", "cpio", "7z", "rz", "pea"};
    private static final String[] IMAGE = new String[]{"jpg", "jpeg", "gif", "bmp", "pbm", "pgm", "ppm", "tga", "xbm", "xpm", "tif", "tiff", "png", "svg", "svgz", "mng", "pcx", "mov", "mpg", "mpeg", "m2v", "mkv", "webm", "ogm", "mp4", "m4v", "mp4v", "vob", "qt", "nuv", "wmv", "asf", "rm", "rmvb", "flc", "avi", "fli", "flv", "gl", "dl", "xcf", "xwd", "yuv", "cgm", "emf", "ico", "axv", "anx", "ogv", "ogx"};
    private static final String[] AUDIO = new String[]{"aac", "au", "flac", "mid", "midi", "mka", "mp3", "mpc", "ogg", "ra", "wav", "axa", "oga", "spx", "xspf"};
    static boolean colors_enabled;
    static Font font_normal;
    static Font font_bold;
    static Font font_device;
    static Color fg_dir;
    static Color fg_exec;
    static Color fg_link;
    static Color fg_comp;
    static Color fg_image;
    static Color fg_audio;
    private static final String SPACE = "  ";
    private static final String DIR = "     <DIR>";
    private static final int DIR_LENGTH;
    private static final SimpleDateFormat DATE_FOTMAT;
    private Font font = Config.BROWSER_NORMAL_FONT.getValue();
    private Color fg = Config.TEXT_FOREGROUND.getValue();
    private File file;
    private String linkedTo;
    private String line;

    static {
        DIR_LENGTH = DIR.length();
        DATE_FOTMAT = new SimpleDateFormat("MMM dd yyyy HH:mm");
        FileBrowserObject.updateDirColors();
    }

    public FileBrowserObject(File file) {
        this(file, false);
    }

    public FileBrowserObject(File file, boolean file_system_root) {
        this.file = file;
        if (file_system_root) {
            this.font = font_device;
            this.line = this.getName();
        } else {
            if (file.isDirectory()) {
                this.font = font_bold;
                this.fg = fg_dir;
            } else if (file.isFile()) {
                String name = file.getName();
                if (Utilities.isFileExtension(name, EXEC)) {
                    this.font = font_normal;
                    this.fg = fg_exec;
                } else if (Utilities.isFileExtension(name, COMP)) {
                    this.font = font_normal;
                    this.fg = fg_comp;
                } else if (Utilities.isFileExtension(name, IMAGE)) {
                    this.font = font_normal;
                    this.fg = fg_image;
                } else if (Utilities.isFileExtension(name, AUDIO)) {
                    this.font = font_normal;
                    this.fg = fg_audio;
                } else if (file.canExecute()) {
                    this.font = font_normal;
                    this.fg = fg_exec;
                }
            }
            try {
                String cp = file.getCanonicalPath();
                String ap = file.getAbsolutePath();
                if (!cp.equals(ap)) {
                    this.linkedTo = cp;
                    this.font = font_bold;
                    this.fg = fg_link;
                }
            }
            catch (IOException cp) {
                // empty catch block
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.getFilePermissions()).append(SPACE);
            sb.append(this.getSize()).append(SPACE);
            sb.append(this.getDateTime()).append(SPACE);
            sb.append(this.getName());
            if (this.linkedTo != null) {
                sb.append(" -> ");
                sb.append(this.linkedTo);
            }
            if (Config.BROWSER_CLASSIFY.getValue().booleanValue()) {
                if (file.isDirectory()) {
                    sb.append("/");
                } else if (file.canExecute()) {
                    sb.append("*");
                }
            }
            this.line = sb.toString();
        }
    }

    @Override
    public int compareTo(FileBrowserObject other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof FileBrowserObject && this.getName().equals(((FileBrowserObject)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        String name = this.file.getName();
        if (Utilities.isEmptyString(name)) {
            name = this.file.getPath();
        }
        return name;
    }

    public String getLine() {
        return this.line;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getForeground() {
        return this.fg;
    }

    public String getFilePermissions() {
        boolean r = this.file.canRead();
        boolean w = this.file.canWrite();
        boolean x = this.file.canExecute();
        return String.valueOf(this.file.isDirectory() ? "d" : "-") + (r ? (char)'r' : '-') + (w ? (char)'w' : '-') + (x ? (char)'x' : '-');
    }

    public String getOwner() {
        return Utilities.fixSizeString(7, true, "?");
    }

    public String getGroup() {
        return Utilities.fixSizeString(7, true, "?");
    }

    public String getSize() {
        String sizeString;
        if (this.file.isDirectory()) {
            return DIR;
        }
        long bytes = this.file.length();
        if (Config.BROWSER_HUMAN_READABLE.getValue().booleanValue()) {
            String units = "BKMG";
            int unit = 0;
            int fraction = 0;
            while (bytes > 1000L && unit + 1 < "BKMG".length()) {
                fraction = (int)((bytes /= 100L) % 10L);
                bytes /= 10L;
                ++unit;
            }
            sizeString = bytes < 10L ? String.valueOf(bytes) + "." + fraction + "BKMG".charAt(unit) : String.valueOf(bytes < 100L ? " " : "") + bytes + "BKMG".charAt(unit);
        } else {
            sizeString = String.valueOf(bytes);
        }
        return Utilities.fixSizeString(DIR_LENGTH, false, sizeString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDateTime() {
        SimpleDateFormat simpleDateFormat = DATE_FOTMAT;
        synchronized (simpleDateFormat) {
            return DATE_FOTMAT.format(new Date(this.file.lastModified()));
        }
    }

    public String toString() {
        return this.getName();
    }

    public static void updateDirColors() {
        font_normal = Config.BROWSER_NORMAL_FONT.getValue();
        font_bold = Config.BROWSER_BOLD_FONT.getValue();
        font_device = Config.BROWSER_DEVICE_FONT.getValue();
        colors_enabled = Config.BROWSER_COLORS_ENABLED.getValue();
        if (colors_enabled) {
            fg_dir = Config.BROWSER_DIR_FOREGROUND.getValue();
            fg_exec = Config.BROWSER_EXEC_FOREGROUND.getValue();
            fg_link = Config.BROWSER_LINK_FOREGROUND.getValue();
            fg_comp = Config.BROWSER_COMP_FOREGROUND.getValue();
            fg_image = Config.BROWSER_IMAGE_FOREGROUND.getValue();
            fg_audio = Config.BROWSER_AUDIO_FOREGROUND.getValue();
        } else {
            fg_image = fg_audio = Config.TEXT_FOREGROUND.getValue();
            fg_comp = fg_audio;
            fg_link = fg_audio;
            fg_exec = fg_audio;
            fg_dir = fg_audio;
        }
    }
}

