/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextArea;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.Utilities;

public final class RemoveEmptyLinesAction
extends JNPadAction
implements IEditAction {
    private static final Logger LOGGER = Logger.getLogger(RemoveEmptyLinesAction.class.getName());
    private static final long serialVersionUID = -6430269063436442536L;

    public RemoveEmptyLinesAction(JNPadFrame jNPad) {
        super(jNPad, "remove-empty-lines", JNPadActions.Group.EDIT, Accelerators.REMOVE_EMPTY_LINES, null);
    }

    @Override
    public void performAction() {
        block7: {
            Buffer buffer = this.jNPad.getActiveBuffer();
            if (buffer != null) {
                try {
                    try {
                        buffer.beginCompoundEdit();
                        JNPadTextArea textArea = buffer.getSelectedTextArea();
                        if (textArea.hasSelection()) {
                            textArea.replaceSelection(this.removeEmptyLines(textArea.getSelectedText()));
                            break block7;
                        }
                        textArea.setText(this.removeEmptyLines(textArea.getText()));
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                        this.jNPad.setStatus(StatusDisplayable.StatusType.ERROR, "Error - ".concat(this.getLabel()));
                        buffer.endCompoundEdit();
                    }
                }
                finally {
                    buffer.endCompoundEdit();
                }
            }
        }
    }

    private String removeEmptyLines(String s) {
        s = s.replaceAll("(?m)^[ \t]*\r?\n", "");
        s = Utilities.removeNewLine(s);
        return s;
    }
}

