/*
 * Decompiled with CFR 0.152.
 */
package com.textflex.jarajar.common;

import com.textflex.jarajar.common.JarAjarXML;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LibJarAjar {
    public static final String JAJ_VER = "0.7.1";
    public static final String JAJ_DTD_VER = "0.7.0";
    public static final String JAJ_DTD = "http://textflex.com/jarjar/dtd/jarajar.dtd";
    public static final String JAJ_PUBID_PRE = "-//Text Flex//DTD Jar Ajar Extractor, v.";
    public static final String JAJ_PUBID = "-//Text Flex//DTD Jar Ajar Extractor, v.0.7.0";
    private static final String NEWLINE = System.getProperty("line.separator");

    public static void addGridBagComponent(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6, Container container) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        container.add(component, gridBagConstraints);
    }

    public static ImageIcon makeIcon(String string) {
        URL uRL = LibJarAjar.class.getResource(string);
        return uRL != null ? new ImageIcon(uRL) : null;
    }

    public static void setRollover(JButton jButton, String string) {
        jButton.setRolloverIcon(LibJarAjar.makeIcon(string));
        jButton.setRolloverEnabled(true);
    }

    public static void setRollover(JButton jButton, ImageIcon imageIcon) {
        jButton.setRolloverIcon(imageIcon);
        jButton.setRolloverEnabled(true);
    }

    public static void setAcceleratedAction(Action action, String string, char c, KeyStroke keyStroke) {
        action.putValue("ShortDescription", string);
        action.putValue("MnemonicKey", new Integer(c));
        action.putValue("AcceleratorKey", keyStroke);
    }

    public static void setAction(Action action, String string, char c) {
        action.putValue("ShortDescription", string);
        action.putValue("MnemonicKey", new Integer(c));
    }

    public static void setAction(Action action, String string) {
        action.putValue("ShortDescription", string);
    }

    public static String setAction(Action action, String string, String string2, String string3) {
        char c = '\u0000';
        int n = 0;
        for (n = 0; n < string.length() && string3.indexOf(c = string.charAt(n)) != -1; ++n) {
        }
        if (n < string.length()) {
            action.putValue("MnemonicKey", new Integer(c));
            string3 = string3 + c;
        }
        action.putValue("ShortDescription", string2);
        return string3;
    }

    public static void setToolTipTiming(int n, int n2) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setInitialDelay(n);
        toolTipManager.setDismissDelay(n2);
    }

    public static void aboutDialog(JFrame jFrame, ImageIcon imageIcon, boolean bl) throws IOException {
        String string = "";
        string = LibJarAjar.readText("/docs/about.txt", bl, true);
        if (string == null) {
            string = "Jar Ajar\ncopyright (c) 2002-8, 2012-3 Text Flex\nPlease see http://textflex.com/jarajar\nfor more details, as the \"about.txt\"\nfile appears to be missing from this package.";
        }
        String string2 = "About Jar Ajar";
        Object[] objectArray = new String[]{"View License", "Close"};
        int n = JOptionPane.showOptionDialog(jFrame, string, string2, -1, -1, imageIcon, objectArray, objectArray[0]);
        if (n == 0) {
            string = LibJarAjar.readText("/docs/license.txt", bl, true);
            if (string == null) {
                string = "Please see http://textflex.com/jarajar\nfor more details, as the \"license.txt\"\nfile appears to be missing from this package.";
            }
            LibJarAjar.msgDialog(jFrame, null, string, "License.", 1, null, 450, 400, false);
        }
    }

    public static String readText(BufferedReader bufferedReader) {
        String string = "";
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2 + "\n";
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(String string, boolean bl, boolean bl2) {
        String string2 = "";
        BufferedReader bufferedReader = null;
        if (string == null || string.equals("")) {
            return string2;
        }
        try {
            Object object;
            if (bl) {
                if (bl2 && !string.startsWith("/")) {
                    string = "/" + string;
                }
                object = LibJarAjar.class.getResourceAsStream(string);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            } else {
                object = null;
                object = bl2 ? new File(LibJarAjar.getBaseFile(), string) : new File(string);
                bufferedReader = new BufferedReader(new FileReader((File)object));
            }
            while ((object = bufferedReader.readLine()) != null) {
                string2 = string2 + (String)object + "\n";
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(File file) {
        String string = "";
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2 + "\n";
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string;
    }

    public static File saveXML(String string, String string2, String string3, org.w3c.dom.Document document) throws TransformerException, IOException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("doctype-system", string2);
        transformer.setOutputProperty("doctype-public", string3);
        File file = new File(LibJarAjar.getBaseFile(), string);
        transformer.transform(new DOMSource(document), new StreamResult(new FileOutputStream(file)));
        return file;
    }

    public static JarAjarXML parseExtractor(Element element) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        int n = 0;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node;
            NodeList nodeList2;
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element)) continue;
            Element element3 = (Element)node2;
            if (element3.getTagName().equals("welcome")) {
                nodeList2 = element3.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    node = (Element)nodeList2.item(j);
                    Text text = (Text)node.getFirstChild();
                    if (text != null) {
                        string = string + text.getData().trim();
                    }
                    if (j == nodeList2.getLength() - 1) continue;
                    string = string + "\n";
                }
                continue;
            }
            if (element3.getTagName().equals("package")) {
                nodeList2 = element3.getChildNodes();
                Element element4 = (Element)nodeList2.item(0);
                node = (Text)element4.getFirstChild();
                if (node == null) continue;
                string2 = node.getData().trim();
                continue;
            }
            if (element3.getTagName().equals("version")) {
                nodeList2 = element3.getChildNodes();
                Element element5 = (Element)nodeList2.item(0);
                node = (Text)element5.getFirstChild();
                if (node == null) continue;
                string3 = node.getData().trim();
                continue;
            }
            if (element3.getTagName().equals("zip")) {
                nodeList2 = element3.getChildNodes();
                Element element6 = (Element)nodeList2.item(0);
                node = (Text)element6.getFirstChild();
                if (node == null) continue;
                string4 = node.getData().trim();
                continue;
            }
            if (element3.getTagName().equals("file")) {
                nodeList2 = element3.getChildNodes();
                Element element7 = (Element)nodeList2.item(0);
                node = (Text)element7.getFirstChild();
                if (node == null) continue;
                arrayList.add(node.getData().trim());
                continue;
            }
            if (element3.getTagName().equals("logo")) {
                nodeList2 = element3.getChildNodes();
                Element element8 = (Element)nodeList2.item(0);
                node = (Text)element8.getFirstChild();
                if (node == null) continue;
                string5 = node.getData().trim();
                continue;
            }
            if (element3.getTagName().equals("outputDir")) {
                nodeList2 = element3.getChildNodes();
                Element element9 = (Element)nodeList2.item(0);
                node = (Text)element9.getFirstChild();
                if (node == null) continue;
                string6 = node.getData().trim();
                continue;
            }
            if (element3.getTagName().equals("runAppStr")) {
                nodeList2 = element3.getChildNodes();
                Element element10 = (Element)nodeList2.item(0);
                node = (Text)element10.getFirstChild();
                if (node == null) continue;
                string8 = node.getData().trim();
                continue;
            }
            if (element3.getTagName().equals("readmePath")) {
                nodeList2 = element3.getChildNodes();
                Element element11 = (Element)nodeList2.item(0);
                node = (Text)element11.getFirstChild();
                if (node == null) continue;
                string9 = node.getData().trim();
                continue;
            }
            if (element3.getTagName().equals("licensePath")) {
                nodeList2 = element3.getChildNodes();
                Element element12 = (Element)nodeList2.item(0);
                node = (Text)element12.getFirstChild();
                if (node == null) continue;
                string10 = node.getData().trim();
                continue;
            }
            if (element3.getTagName().equals("installDir")) {
                nodeList2 = element3.getChildNodes();
                Element element13 = (Element)nodeList2.item(0);
                node = (Text)element13.getFirstChild();
                if (node == null) continue;
                string11 = node.getData().trim();
                continue;
            }
            if (!element3.getTagName().equals("silent") || (node = (Text)(element2 = (Element)(nodeList2 = element3.getChildNodes()).item(0)).getFirstChild()) == null) continue;
            try {
                n = Integer.parseInt(node.getData().trim());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return new JarAjarXML(string, string2, string3, string4, arrayList, string5, string6, string8, string9, string10, string11, n);
    }

    public static File getBaseFile() {
        File file = null;
        URI uRI = LibJarAjar.getBaseURI();
        if (uRI != null && uRI.getScheme().startsWith("file")) {
            file = new File(uRI);
        }
        return file;
    }

    private static URI getBaseURI() {
        try {
            URI uRI = new URI(LibJarAjar.class.getProtectionDomain().getCodeSource().getLocation().toString());
            if (uRI.toString().endsWith(".jar")) {
                String string = uRI.toString();
                string = string.substring(0, string.lastIndexOf("/")) + "/";
                uRI = new URI(string);
            }
            return uRI;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static JarFile getJarFile() {
        try {
            URI uRI = new URI(LibJarAjar.class.getProtectionDomain().getCodeSource().getLocation().toString());
            if (uRI.toString().endsWith(".jar")) {
                JarFile jarFile = new JarFile(new File(uRI));
                return jarFile;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static String replaceSubstring(String string, String string2, String string3) {
        int n = 0;
        boolean bl = false;
        int n2 = string2.length();
        if (string == "") {
            return "";
        }
        while ((n = string.indexOf(string2, n)) != -1) {
            if (n + n2 >= string.length()) {
                return string.substring(0, n) + string3;
            }
            string = string.substring(0, n) + string3 + string.substring(n + n2);
            n += n2;
        }
        return string;
    }

    public static void addZipDirectory(ZipOutputStream zipOutputStream, File file, String string, String string2, boolean bl, String[] stringArray) throws FileNotFoundException, IOException {
        String string3 = "";
        String[] stringArray2 = file.list();
        for (int i = 0; i < stringArray2.length; ++i) {
            File file2 = new File(file, stringArray2[i]);
            if (stringArray != null && LibJarAjar.ignoreFile(file2, stringArray)) continue;
            if (file2.isDirectory()) {
                if (!bl) continue;
                LibJarAjar.addZipDirectory(zipOutputStream, file2, string, string2, true, null);
                continue;
            }
            string3 = file2.getAbsolutePath().substring(string.length() + 1);
            LibJarAjar.addZipEntry(zipOutputStream, file2, string3, string2);
        }
    }

    private static boolean ignoreFile(File file, String[] stringArray) {
        String string = file.getName();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean addZipEntry(ZipOutputStream zipOutputStream, File file, String string, String string2) throws IOException {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            if (string == null) {
                string = file.getName();
            }
            if (string2 != null && !string2.equals("")) {
                string = string2 + File.separator + string;
            }
            LibJarAjar.addZipEntry(zipOutputStream, bufferedInputStream, string);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("The file \"" + string + "\"" + NEWLINE + "could not be found for adding to the package." + NEWLINE + "Please check the file and try again.");
            return false;
        }
    }

    private static void addZipEntry(ZipOutputStream zipOutputStream, BufferedInputStream bufferedInputStream, String string) throws FileNotFoundException, IOException {
        byte[] byArray = new byte[4096];
        int n = 0;
        string = LibJarAjar.replaceSubstring(string, File.separator, "/");
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        System.out.println("Adding: " + string);
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            zipOutputStream.write(byArray, 0, n);
        }
        if (bufferedInputStream != null) {
            bufferedInputStream.close();
        }
        zipOutputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzip(ZipInputStream zipInputStream, String string, JTextPane jTextPane, boolean bl, ArrayList arrayList) {
        ZipEntry zipEntry = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[4096];
        int n = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            while (bl2 && (zipEntry = zipInputStream.getNextEntry()) != null) {
                File file = new File(LibJarAjar.fileSeparatorConverter(string + File.separator + zipEntry.getName()));
                File file2 = file.getParentFile();
                if (zipEntry.isDirectory()) {
                    if (!file.exists()) {
                        bl2 = file.mkdirs();
                    }
                } else if (!file2.exists()) {
                    bl2 = file2.mkdirs();
                }
                if (!bl2) {
                    boolean bl5 = false;
                    return bl5;
                }
                if (!bl2 || zipEntry.isDirectory()) continue;
                String string2 = file.getPath();
                int n2 = -1;
                if (file.exists() && !bl3 && !bl4) {
                    if (jTextPane == null) {
                        bl3 = true;
                    } else {
                        n2 = LibJarAjar.overwriteOption(jTextPane, string2, true);
                    }
                }
                if (n2 == 2) {
                    bl3 = true;
                } else if (n2 == 3) {
                    bl4 = true;
                }
                if (!file.exists() || bl3 || n2 == 0) {
                    LibJarAjar.appendToNotice("Inflating " + string2 + "\n", jTextPane, true);
                    fileOutputStream = new FileOutputStream(string2);
                    while ((n = zipInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    arrayList.add(string2);
                    continue;
                }
                if (bl4 || n2 == 1) {
                    LibJarAjar.appendToNotice(string2 + " skipped\n", jTextPane, true);
                    continue;
                }
                if (n2 != 4 && n2 != -1) continue;
                LibJarAjar.appendToNotice("Unzip cancelled.\n", jTextPane, true);
                bl2 = false;
            }
            boolean bl6 = bl2;
            return bl6;
        }
        catch (IOException iOException) {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException2) {
                boolean bl7 = false;
                return bl7;
            }
            boolean bl8 = false;
            return bl8;
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static int overwriteOption(Component component, String string, boolean bl) {
        String string2 = string + "\nalready exists.  Overwrite?";
        Object[] objectArray = new String[]{"Yes", "No", "Always yes", "Always no", "Cancel"};
        if (!bl) {
            String[] stringArray = new String[]{"Yes", "No", "Cancel"};
            objectArray = stringArray;
        }
        int n = JOptionPane.showOptionDialog(component, string2, "Overwrite?", -1, 2, null, objectArray, objectArray[1]);
        return n;
    }

    public static void appendToNotice(String string, JTextPane jTextPane, boolean bl) {
        if (jTextPane == null) {
            System.out.println(string);
            return;
        }
        Document document = jTextPane.getDocument();
        try {
            document.insertString(document.getLength(), string, null);
            if (bl) {
                jTextPane.setCaretPosition(document.getLength());
            }
        }
        catch (BadLocationException badLocationException) {
            System.out.println(string);
        }
    }

    public static void appendToNotice(String string, JTextPane jTextPane) {
        LibJarAjar.appendToNotice(string, jTextPane, false);
    }

    public static int reverseIndexOf(String string, String string2, int n) {
        int n2;
        for (n2 = n - 1; n2 >= 0 && !string.substring(n2, n2 + string2.length()).equals(string2); --n2) {
        }
        return n2;
    }

    public static String fileSeparatorConverter(String string) {
        String string2 = "/\\";
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (string2.indexOf(c) == -1) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(File.separator);
        }
        return stringBuffer.toString();
    }

    public static void msgDialog(Component component, ImageIcon imageIcon, String string, String string2, int n, Icon icon, int n2, int n3, boolean bl) {
        JTextPane jTextPane = new JTextPane();
        JScrollPane jScrollPane = LibJarAjar.makeScrollPane(jTextPane);
        jTextPane.setDocument(jTextPane.getEditorKit().createDefaultDocument());
        if (bl) {
            jTextPane.setContentType("text/html");
            jTextPane.addHyperlinkListener(new EditorPaneHyperlinkListener());
        }
        jScrollPane.setPreferredSize(new Dimension(n2, n3));
        jTextPane.setText(string);
        jTextPane.setCaretPosition(0);
        JOptionPane.showMessageDialog(component, jScrollPane, string2, n, icon);
    }

    public static void msgDialog(Component component, ImageIcon imageIcon, String string, String string2, int n, Icon icon) {
        LibJarAjar.msgDialog(component, imageIcon, string, string2, n, icon, 30, 200, true);
    }

    public static JScrollPane makeScrollPane(JTextComponent jTextComponent) {
        jTextComponent.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextComponent, 20, 31);
        return jScrollPane;
    }

    public static void addEditorPaneHyperlinkListener(JEditorPane jEditorPane) {
        jEditorPane.addHyperlinkListener(new EditorPaneHyperlinkListener());
    }

    private static class EditorPaneHyperlinkListener
    implements HyperlinkListener {
        private EditorPaneHyperlinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                JFrame jFrame = new JFrame();
                final JEditorPane jEditorPane2 = new JEditorPane();
                JScrollPane jScrollPane = LibJarAjar.makeScrollPane(jEditorPane2);
                jFrame.setSize(1000, 600);
                jEditorPane2.addHyperlinkListener(new HyperlinkListener(){

                    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            try {
                                jEditorPane2.setPage(hyperlinkEvent.getURL());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                });
                try {
                    jEditorPane2.setPage(hyperlinkEvent.getURL());
                    jEditorPane2.setSize(new Dimension(1000, 600));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                jFrame.add(jScrollPane);
                jFrame.validate();
                jFrame.setVisible(true);
            }
        }
    }
}

