/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FormatDialog
extends JDialog
implements ActionListener {
    private JLabel labelFont;
    private JLabel labelSize;
    private JLabel labelStyle;
    private JLabel labelColor;
    private JComboBox comboSize;
    private JComboBox comboFont;
    private JComboBox comboStyle;
    private JButton buttonDone;
    private JButton buttonCancel;
    private JButton buttonApply;
    private JButton buttonColor;
    private TextEditorPane textPane;

    public FormatDialog(TextEditorPane pane) {
        this.textPane = pane;
        this.setTitle("Format Options");
        this.setSize(320, 300);
        this.setDefaultCloseOperation(2);
        this.createComponent();
        this.fontFromPane();
        this.setResizable(false);
        this.setModal(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int y = screenSize.height / 2 - this.getHeight() / 2;
        int x = screenSize.width / 2 - this.getWidth() / 2;
        this.setLocation(x, y);
        this.setVisible(true);
    }

    private void createComponent() {
        this.setLayout(new GridLayout(10, 2));
        Container container = this.getContentPane();
        container.add(new JLabel(""));
        container.add(new JLabel(""));
        this.labelFont = new JLabel("Font", 0);
        container.add(this.labelFont);
        this.comboFont = new JComboBox<String>(this.getToolkit().getFontList());
        container.add(this.comboFont);
        container.add(new JLabel(""));
        container.add(new JLabel(""));
        this.labelSize = new JLabel("Size", 0);
        container.add(this.labelSize);
        this.comboSize = new JComboBox();
        this.comboSize.addItem(8);
        this.comboSize.addItem(10);
        this.comboSize.addItem(11);
        this.comboSize.addItem(12);
        this.comboSize.addItem(13);
        this.comboSize.addItem(14);
        this.comboSize.addItem(16);
        this.comboSize.addItem(18);
        this.comboSize.addItem(20);
        this.comboSize.addItem(22);
        this.comboSize.addItem(24);
        this.comboSize.addItem(28);
        this.comboSize.addItem(32);
        container.add(this.comboSize);
        container.add(new JLabel(""));
        container.add(new JLabel(""));
        this.labelStyle = new JLabel("Style", 0);
        container.add(this.labelStyle);
        this.comboStyle = new JComboBox<String>(new String[]{"Normale", "Grassetto", "Corsivo"});
        container.add(this.comboStyle);
        container.add(new JLabel(""));
        container.add(new JLabel(""));
        this.buttonColor = new JButton("Color");
        this.buttonColor.addActionListener(this);
        container.add(this.buttonColor);
        this.labelColor = new JLabel("");
        this.labelColor.setOpaque(true);
        container.add(this.labelColor);
        container.add(new JLabel(""));
        container.add(new JLabel(""));
        this.buttonDone = new JButton("Done");
        this.buttonDone.addActionListener(this);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(this);
        this.buttonApply = new JButton("Apply");
        this.buttonApply.addActionListener(this);
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(new JLabel(""));
        panel.add(this.buttonDone);
        container.add(panel);
        JPanel panel2 = new JPanel(new GridLayout(1, 2));
        panel2.add(this.buttonApply);
        panel2.add(this.buttonCancel);
        container.add(panel2);
    }

    private void fontFromPane() {
        this.comboFont.setSelectedItem(this.textPane.getFont().getName());
        this.comboSize.setSelectedItem(this.textPane.getFont().getSize());
        this.comboStyle.setSelectedIndex(this.textPane.getFont().getStyle());
        this.labelColor.setBackground(this.textPane.getForeground());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.buttonCancel)) {
            this.dispose();
        } else if (source.equals(this.buttonColor)) {
            JColorChooser chooser = new JColorChooser();
            Color color = JColorChooser.showDialog(this, "Choose the Color", this.labelColor.getBackground());
            if (color != null) {
                this.labelColor.setBackground(color);
            }
        } else if (source.equals(this.buttonDone) || source.equals(this.buttonApply)) {
            this.textPane.setFormat(new Font(this.comboFont.getSelectedItem().toString(), this.comboStyle.getSelectedIndex(), Integer.parseInt(this.comboSize.getSelectedItem().toString())), this.labelColor.getBackground());
            if (source.equals(this.buttonDone)) {
                this.dispose();
            }
        }
    }
}

