/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.XrefCtree;
import com.xrefactory.jedit.XrefTreeNode;
import com.xrefactory.jedit.s;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class XrefBrowserTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    XrefBrowserTreeCellRenderer() {
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        XrefTreeNode n = (XrefTreeNode)value;
        String name = " " + n.className;
        if (n.bestFit && !n.isTopLevel) {
            name = n.className + " *";
        }
        if (n.refNum + n.drefNum > 0) {
            name = n.drefNum > 0 && n.refNum > 0 ? name + "   (" + n.drefNum + "+" + n.refNum + ")" : name + "   (" + (n.refNum + n.drefNum) + ")";
        }
        JComponent res = n.isTopLevel ? new JTextArea("\n" + name) : new JCheckBox(name, n.selected);
        res.setBorder(s.emptyBorder);
        if (n.hasdefinition && n.isinterface) {
            res.setFont(s.ctItalicBoldFont);
        } else if (n.hasdefinition) {
            res.setFont(s.ctBoldFont);
        } else if (n.isinterface) {
            res.setFont(s.ctItalicFont);
        } else {
            res.setFont(s.ctNormalFont);
        }
        res.setBackground(tree.getBackground());
        if (n.isTopLevel) {
            if (n.className == "NOT MEMBER SYMBOLS") {
                res.setFont(s.ctBoldFont);
                res.setForeground(s.ctNmSymbolColor);
            } else {
                res.setFont(s.ctTopLevelFont);
                res.setForeground(s.ctSymbolColor);
            }
        } else {
            res.setForeground(s.ctFgColor);
        }
        if (selected) {
            if (((XrefCtree)tree).active != null) {
                ((XrefCtree)tree).active.active = false;
            }
            n.active = true;
            ((XrefCtree)tree).active = n;
        }
        if (n.active && !n.isTopLevel) {
            res.setForeground(s.ctSelectionColor);
        }
        return res;
    }
}

