/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.DockableSymbolRetriever;
import com.xrefactory.jedit.Push;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefSelectableLinesTextPanel;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gjt.sp.jedit.Buffer;

public class PushSymbolDialog
extends JDialog {
    void init(Component parent, DispatchData data) {
        this.setTitle("Xrefactory");
        PushSymbolPanel ttt = new PushSymbolPanel(data, s.getIdentifierOnCaret());
        this.setContentPane(ttt);
        this.setSize(400, 150);
        this.setLocationRelativeTo(parent);
        this.setModal(true);
        this.setVisible(true);
    }

    public PushSymbolDialog(JDialog parent, DispatchData data) {
        super(parent);
        this.init(parent, data);
    }

    public PushSymbolDialog(JFrame parent, DispatchData data) {
        super(parent);
        this.init(parent, data);
    }

    public static class PushSymbolPanel
    extends JPanel {
        JComboBox symbol;
        DispatchData data;
        static XrefStringArray history = new XrefStringArray();

        PushSymbolPanel(DispatchData data, String defaultsym) {
            int y = -1;
            this.data = data;
            this.setLayout(new GridBagLayout());
            JComponent[] buttons = new JButton[]{new ButtonCancel(), new ButtonPush()};
            if (!history.getLast().equals(defaultsym)) {
                history.add(defaultsym);
            }
            this.symbol = new JComboBox<String>(history.toStringArray(false));
            this.symbol.setEditable(true);
            this.symbol.setSelectedItem(defaultsym);
            s.addGbcComponent(this, 1, ++y, 4, 1, 1, 1, 1, new JLabel("Symbol to push on reference stack", 0));
            s.addGbcComponent(this, 0, ++y, 1, 1, 1, 1, 2, new JPanel());
            s.addGbcComponent(this, 1, y, 1, 1, 1000, 1, 2, this.symbol);
            s.addGbcComponent(this, 2, y, 1, 1, 1, 1, 2, new ButtonBrowse());
            s.addGbcComponent(this, 3, y, 1, 1, 1, 1, 2, new JPanel());
            s.addGbcComponent(this, 0, ++y, 4, 1, 1, 1, 1, new JPanel());
            s.addExtraButtonLine(this, 0, ++y, 4, 1, 1, 1, buttons, true);
            s.addGbcComponent(this, 0, ++y, 4, 1, 1, 1, 1, new JPanel());
        }

        class ButtonBrowse
        extends JButton
        implements ActionListener {
            ButtonBrowse() {
                super("Retrieve");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                DockableSymbolRetriever sr = (DockableSymbolRetriever)s.getParentView(PushSymbolPanel.this.data.callerComponent).getDockableWindowManager().getDockable("xrefactory.retriever");
                if (sr != null) {
                    sr.setResult(new XrefCharBuffer(), PushSymbolPanel.this.data);
                }
                DispatchData ndata = new DispatchData(PushSymbolPanel.this.data, (Component)this);
                XrefCharBuffer receipt = ndata.xTask.callProcessOnFile(new String[]{"-searchdefshortlist", "-olcxtagsearch="}, ndata);
                Dispatch.dispatch(receipt, ndata);
                if (ndata.symbolList != null && !ndata.panic) {
                    JDialog dd = new JDialog((Dialog)s.getParentDialog(this), true);
                    if (s.javaVersion.compareTo("1.4.0") >= 0) {
                        dd.setUndecorated(true);
                    }
                    XrefSelectableLinesTextPanel sp = new XrefSelectableLinesTextPanel(ndata.symbolList.toString(), ndata, "", 1, 0);
                    dd.setContentPane(new JScrollPane(sp));
                    Rectangle mb = PushSymbolPanel.this.getBounds(null);
                    dd.setSize((int)mb.getWidth(), 200);
                    dd.setLocationRelativeTo(s.getParentDialog(this));
                    dd.setLocation(dd.getX() + 5, this.getY() + s.getParentDialog(this).getY() + 50);
                    dd.setVisible(true);
                    PushSymbolPanel.this.symbol.setSelectedItem(sp.result);
                }
            }
        }

        class ButtonPush
        extends JButton
        implements ActionListener {
            ButtonPush() {
                super("Push");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                s.getParentDialog(this).setVisible(false);
                String name = (String)PushSymbolPanel.this.symbol.getSelectedItem();
                if (!history.getLast().equals(name)) {
                    history.add(name);
                }
                Buffer buffer = s.getBuffer();
                int caret = s.getCaretPosition();
                int line = buffer.getLineOfOffset(caret);
                int col = caret - buffer.getLineStartOffset(line);
                DispatchData ndata = new DispatchData(PushSymbolPanel.this.data, (Component)this);
                new Push(new String[]{"-olcxpushname=" + name, "-olcxlccursor=" + (line + 1) + ":" + col, "-olnodialog"}, ndata);
            }
        }

        class ButtonCancel
        extends JButton
        implements ActionListener {
            ButtonCancel() {
                super("Cancel");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                s.getParentDialog(this).setVisible(false);
            }
        }
    }
}

