/*
 * Decompiled with CFR 0.152.
 */
import com.xrefactory.jedit.BrowserTopPanel;
import com.xrefactory.jedit.CompletionDialog;
import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.OptionsForJeditBrowser;
import com.xrefactory.jedit.OptionsForJeditCompletion;
import com.xrefactory.jedit.OptionsForJeditProjects;
import com.xrefactory.jedit.OptionsForJeditRefactorer;
import com.xrefactory.jedit.OptionsForJeditRetriever;
import com.xrefactory.jedit.Push;
import com.xrefactory.jedit.PushSymbolDialog;
import com.xrefactory.jedit.RegistrationDialog;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefTaskForTagFile;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.util.Random;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.OptionsDialog;
import org.gjt.sp.jedit.jEdit;

public class XrefactoryPlugin
extends EditPlugin {
    public void start() {
        s.setGlobalValues();
        Random random = new Random();
        s.currentTmpFileCounter = random.nextInt(1000);
        s.tmpFileStep = random.nextInt(10) + 1;
        random = null;
        if (s.debug) {
            JOptionPane.showMessageDialog((Component)s.view, "Xrefactory debug mode is turned on", "Xrefactory Warning", 2);
        }
    }

    public void stop() {
        BrowserTopPanel t;
        if (jEdit.getFirstView() != null && (t = s.getBrowser(jEdit.getFirstView())) != null) {
            Opt.setBrowserTreeDividerPosition((int)t.treePanel.getSize().getWidth());
        }
    }

    public void createMenuItems(Vector menuItems) {
        menuItems.addElement(GUIUtilities.loadMenu((String)"xrefactory.menu"));
    }

    public void createOptionPanes(OptionsDialog od) {
        OptionGroup xrefactoryGroup = new OptionGroup("xrefactory");
        xrefactoryGroup.addOptionPane((OptionPane)new OptionsForJeditCompletion());
        xrefactoryGroup.addOptionPane((OptionPane)new OptionsForJeditBrowser());
        xrefactoryGroup.addOptionPane((OptionPane)new OptionsForJeditRetriever());
        xrefactoryGroup.addOptionPane((OptionPane)new OptionsForJeditRefactorer());
        xrefactoryGroup.addOptionPane((OptionPane)new OptionsForJeditProjects());
        od.addOptionGroup(xrefactoryGroup);
    }

    private static DispatchData mainBrowserNoFileInvocation(View view, String[] options) {
        DispatchData ndata = new DispatchData(s.xbTask, (Component)view);
        XrefCharBuffer receipt = ndata.xTask.callProcess(options, ndata);
        Dispatch.dispatch(receipt, ndata);
        return ndata;
    }

    private static DispatchData mainBrowserInvocation(View view, String[] options) {
        DispatchData ndata = new DispatchData(s.xbTask, (Component)view);
        XrefCharBuffer receipt = ndata.xTask.callProcessOnFile(options, ndata);
        Dispatch.dispatch(receipt, ndata);
        return ndata;
    }

    private static DispatchData mainBrowserInvocation(View view, String option) {
        return XrefactoryPlugin.mainBrowserInvocation(view, new String[]{option});
    }

    private static void mainTagInvocation(View view, String option, String message) {
        if (s.activeProject != null) {
            DispatchData ndata = new DispatchData(s.xbTask, (Component)view);
            XrefTaskForTagFile.runXrefOnTagFile(option, message, true, ndata);
        }
    }

    public static void completion(View view) {
        s.setGlobalValues(view, true);
        CompletionDialog.completion(view);
    }

    public static void createTags(View view) {
        s.setGlobalValues(view, true);
        XrefactoryPlugin.mainTagInvocation(view, "-create", "Creating Tags.");
    }

    public static void updateTags(View view) {
        s.setGlobalValues(view, true);
        XrefactoryPlugin.mainTagInvocation(view, "-fastupdate", "Updating Tags.");
    }

    public static void fullUpdateTags(View view) {
        s.setGlobalValues(view, true);
        XrefactoryPlugin.mainTagInvocation(view, "-update", "Updating Tags.");
    }

    public static void pushName(View view) {
        s.setGlobalValues(view, true);
        s.displayProjectInformationLater();
        DispatchData ndata = new DispatchData(s.xbTask, (Component)view);
        new PushSymbolDialog((JFrame)view, ndata);
    }

    public static void pushNameFromEditor(View view) {
        s.setGlobalValues(view, true);
        s.displayProjectInformationLater();
        String name = s.getIdentifierOnCaret();
        if (name != null) {
            Buffer buffer = s.getBuffer();
            int caret = s.getCaretPosition();
            int line = buffer.getLineOfOffset(caret);
            int col = caret - buffer.getLineStartOffset(line);
            DispatchData ndata = new DispatchData(s.xbTask, (Component)view);
            new Push(new String[]{"-olcxpushname=" + name, "-olcxlccursor=" + (line + 1) + ":" + col, "-olnodialog"}, ndata);
        }
    }

    public static void pushAndGotoDefinition(View view) {
        s.setGlobalValues(view, true);
        if (s.activeProject != null) {
            s.displayProjectInformationLater();
            DispatchData ndata = new DispatchData(s.xbTask, (Component)view);
            new Push(new String[]{"-olcxpush"}, ndata);
        }
    }

    public static void popAndReturn(View view) {
        s.setGlobalValues(view, true);
        if (s.activeProject != null) {
            s.displayProjectInformationLater();
            DispatchData data = XrefactoryPlugin.mainBrowserNoFileInvocation(view, new String[]{"-olcxpop"});
            if (!data.panic) {
                s.browserNeedsToUpdate(view);
            }
        }
    }

    public static void repush(View view) {
        s.setGlobalValues(view, true);
        if (s.activeProject != null) {
            s.displayProjectInformationLater();
            DispatchData ndata = XrefactoryPlugin.mainBrowserInvocation(view, "-olcxrepush");
            if (!ndata.panic) {
                s.browserNeedsToUpdate(view);
            }
        }
    }

    public static void previousReference(View view) {
        s.setGlobalValues(view, true);
        if (s.activeProject != null) {
            s.displayProjectInformationLater();
            DispatchData data = XrefactoryPlugin.mainBrowserNoFileInvocation(view, new String[]{"-olcxminus"});
            if (!data.panic && s.browserIsDisplayed((Component)view)) {
                s.getBrowser((View)view).referencesPanel.updateSelection();
            }
        }
    }

    public static void nextReference(View view) {
        s.setGlobalValues(view, true);
        if (s.activeProject != null) {
            s.displayProjectInformationLater();
            DispatchData data = XrefactoryPlugin.mainBrowserNoFileInvocation(view, new String[]{"-olcxplus"});
            if (!data.panic && s.browserIsDisplayed((Component)view)) {
                s.getBrowser((View)view).referencesPanel.updateSelection();
            }
        }
    }

    public static void globalUnusedSymbols(View view) {
        s.setGlobalValues(view, true);
        if (s.activeProject != null) {
            s.displayProjectInformationLater();
            DispatchData ndata = new DispatchData(s.xbTask, (Component)view);
            new Push(new String[]{"-olcxpushglobalunused"}, ndata);
        }
    }

    public static void localUnusedSymbols(View view) {
        s.setGlobalValues(view, true);
        if (s.activeProject != null) {
            s.displayProjectInformationLater();
            DispatchData ndata = new DispatchData(s.xbTask, (Component)view);
            new Push(new String[]{"-olcxpushfileunused"}, ndata);
        }
    }

    public static void killXrefTask(View view) {
        s.setGlobalValues(view, true);
        if (s.xbTask != null) {
            s.xbTask.killThis(true);
        }
    }

    public static void browser(View view) {
        s.setGlobalValues(view, true);
        if (s.activeProject != null) {
            view.getDockableWindowManager().showDockableWindow("xrefactory.browser");
            DispatchData ndata = new DispatchData(s.xbTask, (Component)view);
            new Push(new String[]{"-olcxpushonly", "-olnodialog"}, ndata);
        }
    }

    public static void refactor(View view) {
        s.setGlobalValues(view, true);
        if (s.activeProject != null) {
            s.displayProjectInformationLater();
            XrefactoryPlugin.mainBrowserInvocation(view, "-olcxgetrefactorings");
        }
    }

    public static void viewClassTree(View view) {
        s.setGlobalValues(view, true);
        if (s.activeProject != null) {
            s.displayProjectInformationLater();
            XrefactoryPlugin.mainBrowserInvocation(view, "-olcxclasstree");
        }
    }

    public static void retrieveSymbol(View view) {
        s.setGlobalValues(view, true);
        s.displayProjectInformationLater();
        if (s.activeProject != null) {
            s.view.getDockableWindowManager().showDockableWindow("xrefactory.retriever");
        }
    }

    public static void registration(View view) {
        s.setGlobalValues(view, false);
        int answer = JOptionPane.showOptionDialog((Component)s.view, "\nFurther evolution and maintenance  of Xrefactory is entirely dependent\non its users.  The xref task is proprietary software.  In order to run\nit legally  you need to purchase  a license.  You  can obtain detailed\ninformation   about   available   licenses   and  order   process   on\nhttp://www.xref-tech.com/xrefactory/license.html  .   After successful\nregistration you will receive a  license string which will change your\nevaluation copy into regular one.\n\nIf you  have received a valid  license string, you can now continue to\nthe next dialog.", "Xrefactory", 2, 1, null, new String[]{"Browse Url", "Continue"}, "Continue");
        if (answer == 0) {
            s.browseUrl("http://www.xref-tech.com/license.html", true, s.view);
        } else {
            new RegistrationDialog();
        }
    }
}

