/*
 * Load the required libraries
 */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

say ""
say "Starting CodeQuill installation."

directory = directory()

/*
 * Create a cq.cmd file to point to the codequill.jar in the current directory.
 */
'echo @echo off > cq.cmd'
'echo start jrepm -cp' directory || '\codequill.jar com.sonoransoft.codequill.CodeQuill %%1 %%2 %%3 %%4 %%5 %%6 >> cq.cmd'

/*
 * Create and icon for the cmd file.
 */
'copy images\cqos2.ico cq.ico'

say "Created cq.cmd - CodeQuill launch file."

/*
 * Put the CodeQuill folder on the desktop
 */
title = "CodeQuill"
classname='WPFolder'
location='<WP_DESKTOP>'
setup='OBJECTID=<WP_CODEQUILL_FOLDER>;'
action='update'
Call BldObj

/*
 * Install CodeQuill in the folder.
 */
classname = 'WPProgram'
location = '<WP_CODEQUILL_FOLDER>'
action='replace'
title = "CodeQuill"
setup = 'PROGTYPE=WINDOWABLEVIO;' || 'MINIMIZED=YES;'
setup = setup || 'EXENAME=' || directory || '\cq.cmd;'
Call BldObj

/*
 * Install CodeQuill User Guide in the folder.
 */
classname = 'WPUrl'
location = '<WP_CODEQUILL_FOLDER>'
action='Replace'
title = "CodeQuill User Guide"
setup = 'URL=file:///'||directory||'/userguide.html;' || 'DEFAULTVIEW=UNKNOWN;'
Call BldObj

/*
 * Install CodeQuill readme file in the folder.
 */
classname = 'WPShadow'
location = '<WP_CODEQUILL_FOLDER>'
action='replace'
title = "Readme first"
setup = 'SHADOWID=' || directory || '\readme.1st;' || 'DEFAULTVIEW=UNKNOWN;'
Call BldObj

say "CodeQuill installation is complete."

Exit 0

/*
 * Build Object
 */
BldObj:
call charout ,'Building: 'title

result = SysCreateObject(classname, title, location, setup, action)

If result=1 Then call charout ,'...   Object created!'
Else             call charout ,'...   Not created! Return code='result

Say '';
Return
