package de.beagtex.listener.insert;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener inserting a quotation-environment in LaTex-Code
 * 
 * @author Benjamin Haag
 */
public class QuotationListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public QuotationListener(Editor editor) {

		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		if (editor.getSelectedText() == null) {
			editor.insert("\\begin{quote}" + "\r\n" + "\r\n" + "\\end{quote}",
					editor.getCaretPosition());
			editor.requestFocus();
			editor.setCaretPosition(editor.getCaretPosition() - 12);
		} else {
			editor
					.insert("\\begin{quote}" + "\r\n", editor
							.getSelectionStart());
			editor.insert("\r\n" + "\\end{quote}" + "\r\n", editor
					.getSelectionEnd());
			editor.requestFocus();
			editor.setCaretPosition(editor.getSelectionEnd());
		}
	}

}
