package de.beagtex.listener.insert;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener for indexing a chosen word
 * 
 * @author Benjamin Haag
 * 
 */
public class IndexingListerner implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public IndexingListerner(Editor editor) {

		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {

		if (editor.getSelectedText() == null) {
			editor.insert("\\index{}", editor.getCaretPosition());
			editor.requestFocus();
			editor.setCaretPosition(editor.getCaretPosition() - 1);
		} else {
			editor.insert("\\index{", editor.getSelectionStart());
			editor.insert("}", editor.getSelectionEnd());
			editor.requestFocus();
			editor.setCaretPosition(editor.getSelectionEnd());
		}
	}

}
