package de.beagtex.listener.insert;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import de.beagtex.gui.Editor;

/**
 * Listener for automatic indexing of a chosen word in the text
 * 
 * @author Benjamin Haag
 * 
 */
public class AutoIndexListener implements ActionListener {

	/**
	 * Editor-Component
	 */
	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param pEditor :
	 *            the calling editor
	 */
	public AutoIndexListener(Editor pEditor) {
		this.editor = pEditor;
	}

	/**
	 * Sends the chosen word to the index-Method or opens a info-message
	 */
	public void actionPerformed(ActionEvent pE) {

		String wort = editor.getSelectedText();
		if (wort != null) {
			indiziere(wort);
		} else {
			JOptionPane.showMessageDialog(null,
					"Please select a word, that you want to be indexed!",
					"Info", JOptionPane.INFORMATION_MESSAGE);
		}

	}

	/**
	 * Creates a Index-Tag for all found matches of the selected word
	 * 
	 * @param pWord :
	 *            the word to be indexed
	 */
	private void indiziere(String pWord) {

		String indexWord = "\\index{" + pWord + "}";
		System.out.println(indexWord);
		String edit = editor.getText();
		edit = edit.replaceAll(pWord, "\\" + indexWord);
		editor.setText(edit);
	}
}
