package de.beagtex.listener.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import de.beagtex.gui.BFrame;
import de.beagtex.gui.Editor;
import de.beagtex.gui.SearchWindow;

/**
 * Listener for Search-Textfield in SearchWindow; calls method
 * search(SearchWindow) from Editor
 * 
 * @author Benjamin Haag
 */
public class SearchTermListener implements ActionListener {

	Editor editor;
	SearchWindow searchWindow;
	boolean isGerman = false;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 * @param suchenFenster:
	 *            the calling SearchWindow
	 */
	public SearchTermListener(SearchWindow searchWindow, Editor editor) {
		this.searchWindow = searchWindow;
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		if (editor.search(searchWindow) == false) {
			JOptionPane.showMessageDialog(null, BFrame.get_prop().getProperty(
					"beagtex.searchtermlistener.info"), BFrame.get_prop()
					.getProperty("beagtex.searchtermlistener.infotitle"),
					JOptionPane.INFORMATION_MESSAGE);
			searchWindow.setVisible(false);
		} else
			searchWindow.replaceB.setEnabled(true);
	}

}
