package de.beagtex.listener.format;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;

import de.beagtex.gui.Editor;

/**
 * Listener for formating dependent textsizes in LaTex-Code; analyzes
 * Textsize-ComboBox
 * 
 * @author Benjamin Haag
 */
public class TextSizeListener implements ActionListener {

	Editor editor;
	JComboBox size;

	final int tiny = 0;
	final int scriptsize = 1;
	final int footnotesize = 2;
	final int small = 3;
	final int normalsize = 4;
	final int large = 5;
	final int Large = 6;
	final int LARGE = 7;
	final int huge = 8;
	final int Huge = 9;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public TextSizeListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		size = editor.getBFrame().getFormate().getCbSize();
		switch (size.getSelectedIndex()) {

		case tiny:
			if (editor.getSelectedText() == null) {
				editor.insert("{\\tiny }", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("{\\tiny ", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case scriptsize:
			if (editor.getSelectedText() == null) {
				editor.insert("{\\scriptsize }", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("{\\scriptsize ", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case footnotesize:
			if (editor.getSelectedText() == null) {
				editor.insert("{\\footnotesize }", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("{\\footnotesize ", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case small:
			if (editor.getSelectedText() == null) {
				editor.insert("{\\small }", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("{\\small ", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case normalsize:
			if (editor.getSelectedText() == null) {
				editor.insert("{\\normalsize }", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("{\\normalsize ", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case large:
			if (editor.getSelectedText() == null) {
				editor.insert("{\\large }", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("{\\large ", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case Large:
			if (editor.getSelectedText() == null) {
				editor.insert("{\\Large }", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("{\\Large ", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case LARGE:
			if (editor.getSelectedText() == null) {
				editor.insert("{\\LARGE }", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("{\\LARGE ", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case huge:
			if (editor.getSelectedText() == null) {
				editor.insert("{\\huge }", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("{\\huge ", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case Huge:
			if (editor.getSelectedText() == null) {
				editor.insert("{\\Huge }", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("{\\Huge ", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;
		}
	}

}
