package de.beagtex.listener.format;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;

import de.beagtex.gui.Editor;

/**
 * Listener for Color-boxes in the text; analyzes the ComboBox for BG-Colors and
 * creates the LaTex-Command
 * 
 * Colors: red, yellow, green, blue, white, black
 * 
 * @author Benjamin Haag
 * 
 */
public class BGColorListener implements ActionListener {

	Editor editor;
	JComboBox bgColor;

	final int red = 0;
	final int yellow = 1;
	final int green = 2;
	final int blue = 3;
	final int black = 4;
	final int white = 5;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public BGColorListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {

		bgColor = editor.getBFrame().getFormate().getCbBgColors();
		switch (bgColor.getSelectedIndex()) {

		case red:
			if (editor.getSelectedText() == null) {
				editor.insert("\\colorbox{red}{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\colorbox{red}{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case yellow:
			if (editor.getSelectedText() == null) {
				editor
						.insert("\\colorbox{yellow}{}", editor
								.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor
						.insert("\\colorbox{yellow}{", editor
								.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case green:
			if (editor.getSelectedText() == null) {
				editor.insert("\\colorbox{green}{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\colorbox{green}{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case blue:
			if (editor.getSelectedText() == null) {
				editor.insert("\\colorbox{blue}{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\colorbox{blue}{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case black:
			if (editor.getSelectedText() == null) {
				editor.insert("\\colorbox{black}{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\colorbox{black}{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case white:
			if (editor.getSelectedText() == null) {
				editor.insert("\\colorbox{white}{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\colorbox{white}{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;
		}
	}

}
